%[tipo_senyal,patrones,num_senyal] = ClasificaSenyal(senyal,n_tipos,umbral)
%
%Esta funcin clasifica una seal de entrada en funcin de distintos patrones
%segn su morfologa. Para ello emplea el siguiente algoritmo: para cada
%seal de la matriz de entrada, identifica el patrn correspondiente entre
%los patrones detectados hasta el momento. Si no se corresponde con ningn
%patrn conocido, entonces aade un nuevo patrn y lo asigna a la seal.
%En caso contrario, si efectivamente se encuentra entre los patrones
%existentes, actualiza el patrn correspondiente con la seal actual. 
%
%   Entrada:
%       senyal [matriz]: secuencia de seales organizadas en filas
%       n_tipos [n entero]: n mximo de tipos de seal a clasificar
%       umbral [-1 a 1]: umbral de correlacin para detectar patrones
%
%   Salida:
%       tipo_senyal [vector]: clasificacin de cada seal
%       patrones [matriz]: conjunto de patrones detectados (en filas)
%       num_senyal [vector]: nmero de seales identificados de cada patrn
%
%   Llamadas a otras funciones:
%       IdentificaPatron

function [tipo_senyal,patrones,num_senyal] = ClasificaSenyal(senyal,n_tipos,umbral)
%% Parmetros opcionales
if nargin < 2
    n_tipos = 8;     % Este es el limite de patrones posibles.
    umbral = 0.9;    % Umbral de correlacin para parton por defecto.
elseif nargin < 3
    umbral = 0.9;    % Umbral de correlacin para parton por defecto.    
else
    % Deja los parmetros que introduce el usuario.
end

%% Clasificacin del complejo
patrones = [];       % Inicicliza patrones (Para poder pasrselo a funcin IdentificaPatron)
num_senyal = [];     % Inicializa el n de complejos QRS de cada tipo
n_senyal = size(senyal,1); % Obtener el n de QRS
% Bucle que recorre uno por uno por uno los complejos QRS detectados
for i=1:n_senyal
    % Se selecciona el patrn apropiado con un umbral de correlacin de 0.9
    % y un mximo de 3 patrones
    patron_sel = IdentificaPatron(patrones,senyal(i,:),umbral,n_tipos); 
    if patron_sel > 0   % Patrn ya existente -> Se conlabiliza y se actualiza el patrn detectado (robustez)
        tipo_senyal(i) = patron_sel; % Guardar el tipo de patron al que corresponde el QRS
        % Actualizacin del patrn por media ponderada (tienen ms pesos
        % los acumulados que el nuevo (peso unitario)
        num = patrones(patron_sel,:)*num_senyal(patron_sel)+senyal(i,:);
        den = num_senyal(patron_sel)+1;
        patrones(patron_sel,:) = num/den; % Actualizacin del patrn
        % Actualizar el n de patrones de un tipo
        num_senyal(patron_sel) = num_senyal(patron_sel) + 1;
    else                % Patrn nuevo detectado
        patrones = [patrones; senyal(i,:)];    % Aadir el nuevo complejo como patron
        tipo_senyal(i) = size(patrones,1);     % Obtener la posicin del ltimo patron asignado
        num_senyal = [num_senyal; 1]; % Primer complejo QRS de este patrn
    end
end
end

