%% Funcin que se dedica a analizar y evaluzar si hay onda F o no.

% v_ant_ms=45;
% v_pos_ms=350;

function [En1, En2, Fd] = Analizador_onda_F(ecg,tm,fs,QRS)
%% Paso 0: Filtrado de la seal
[ecg_fil,ecg_ok] = filtrado_Paso_Banda(ecg,fs,3,50,2,0);

%% Paso 1: Enventanado de los QRST.
[conjunto_QRST,intervalos]= enventanaQRST(ecg_fil,fs,QRS);

%% Paso 2: Aplicar un clasificador de QRST en Normales y Anormales
[tipo_QRST,patrones,num_senyal] = ClasificaSenyal(conjunto_QRST,2);

%% Paso 3: Obtener el QRST promedio. Media del conjunto_QRST normales por columnas (Sera el patrn)
% QRST_promedio = mean(conjunto_QRST(find(tipo_QRST == mode(tipo_QRST)),:));
QRST_promedio = patrones(mode(tipo_QRST),:);

%% Paso 4: Obtencin de la seal de ondas F:
ecg_ondasF = ecg_fil;

for i=1:size(conjunto_QRST,1)
    
%% Paso 4.1: Eliminar de la seal original los QRST anormales (pone todo a cero)   
    if tipo_QRST(i) ~= mode(tipo_QRST)   
        ecg_ondasF(intervalos(i,1):intervalos(i,2))=zeros(1,1+abs(intervalos(i,2)-intervalos(i,1)));
    end

%% Paso 4.2: Se extrae de la seal original los QRST normales mediante diferencia
%con el QRST mpromedio ponderado.
    if tipo_QRST(i) == mode(tipo_QRST)  
        
        d=(QRST_promedio*conjunto_QRST(i,:)')/(QRST_promedio*QRST_promedio');
        ecg_ondasF(intervalos(i,1):intervalos(i,2))=conjunto_QRST(i,:)-d*QRST_promedio;
    end
end    
% figure
% plot(tm,ecg_ondasF)
% title('Seal sin QRST')

%% Paso5: Obtener la PSD.
[p,w]=periodogram(ecg_ondasF,hamming(length(ecg_ondasF)),length(ecg_ondasF),fs);
% figure
% plot(w,p);
% title('Espectro de Seal sin QRST')

%% Paso 6: Obtener frecuencia predominante.Debera estar alrededor de 5-6 (Hz).
[En1, En2, Fd] = Parametros_OndaF(ecg_ondasF,w,p,fs);

end

