function [y1] = myNeuralNetworkFunction_zszs_balanced(x1)
%MYNEURALNETWORKFUNCTION neural network simulation function.
%
% Generated by Neural Network Toolbox function genFunction, 01-Sep-2017 12:02:08.
%
% [y1] = myNeuralNetworkFunction(x1) takes these arguments:
%   x = Qx25 matrix, input #1
% and returns:
%   y = Qx4 matrix, output #1
% where Q is the number of samples.

%#ok<*RPMT0>

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.xoffset = [1.3e-05;3e-06;1.032338;7.2;0.15382;0.556391;1;0.04;0.603289;15.273771;5.392451;0;-147;0;0;-6;0.000422;0.005588;5.1e-05;0.019444;-2.004626;0.11693;0.000334;1;-119.24865];
x1_step1.gain = [8.26272149257801;10.0425301150372;0.859586908319469;0.0370231163452912;0.0200308113940864;0.000659969383380135;0.0202020202020202;0.0200080032012805;0.000933429068618898;0.0101709574706957;0.00973146901677621;0.02;0.00796812749003984;0.0133333333333333;0.0178571428571429;0.0188679245283019;0.830786971266402;0.0419966994793879;0.494575985170634;0.603520516227309;0.549758807067369;1.08119913633813;2.00066822318654;0.132917699686414;0.00776065554692002];
x1_step1.ymin = -1;

% Layer 1
b1 = [-1.5990215871179079;-1.1034610426374161;0.30017429758593228;-0.13223014734975896;-0.16066688910139956;-0.13380095670116232;-0.15739217559618521;0.82351666390444789;-0.51139265016098945;0.65569768830487696;1.0847728771952732;-1.7030486248295464;1.9415175555620088];
IW1_1 = [0.47051439197722689 -0.45631748958009721 0.12249042427770866 0.31412391584968802 0.079181687373632237 -0.15259558855654035 -0.19750473092664375 -0.057786889524913163 -0.13829532063157843 -0.21147108190436911 0.31256021907578785 -0.10579287009692288 0.39300533550367339 0.47789342373704624 -0.29047971484473384 0.15487673969503277 0.5911113957817512 0.40167383166173931 0.28677006288732015 -0.410307336478692 -0.3803981591590283 0.010313123794503885 0.45862783829394754 -0.026341827521737027 -0.31670180379641999;1.401470096570284 0.93011224109659085 1.2617890504862244 -0.125450617621644 0.1497807943538782 -1.0679663352851072 1.1127403266934823 -0.32349742284789562 -0.59151843662731862 2.0891850235472722 1.5109140456478485 -0.12445201758043574 3.2518531787192084 -1.0148728220067877 -2.2330299726395442 -3.0734388830432371 1.2731192073251345 0.54544101626542041 -0.30727726991844168 1.0753911131855627 -0.1631191177799429 -0.46837756654192469 -0.64232059580684142 -0.26190832438662665 0.16602667338411831;-1.0254424235308643 -0.15913928897292839 -0.42351072928150496 -0.13174138470051128 -0.23921047110468063 -0.41141650901858873 -0.9064277043354716 -0.37408827479697682 -0.22500574208001536 -0.86685971183903576 0.10767169809433609 -0.28448166288363952 -1.8783461829217565 1.6895271891508492 0.34229410349704908 0.76853811932311056 0.58832610700743948 0.38406492035529533 0.56724559395760543 0.78549648968470709 0.10457256222071162 0.60333524582948517 -0.18681452061250403 -0.1124810905404873 -0.18774690437621247;1.2760440726270639 0.54486517995210615 0.9673950812471579 0.40762838346545133 1.2671983665115907 -0.90381134350948289 2.0552979559354512 1.0560627400034241 -1.5029282299736264 -1.3698032884791211 -1.5172333049206486 1.191698206125986 0.45188288083203509 0.34291722834566268 -5.0772232762871017 -2.0166809599248703 0.43331604428550946 0.038709161544571817 -0.76283687557538771 -0.6802072182073593 0.38962486490164394 -0.2363159631215429 1.2294349813352177 0.088409004498882199 -0.35784847551139293;-1.9616335565342895 -1.7182582499422014 0.43828298048608605 -0.4386273381541646 0.75541676686392301 -1.6561159551648896 0.89522796595633092 0.17456895400396294 -2.1073237732480323 0.99613585927651382 2.8971551519549381 2.0682701378589528 0.29292714316857704 0.62487250387156434 -1.7823763115492359 -2.4736178644637685 1.0121128443055796 2.0696239216051642 1.3533931660488314 -0.29180173400608855 0.04887506177082071 0.12532550483832405 0.14906670738087061 0.014764060263319667 -0.08852092436394178;0.44539725872935493 0.52461292305067231 -0.24822382696337811 -0.58031680495016791 0.67944744295743897 -0.47235722913528788 0.13032148953556366 0.42040198723077149 -0.27731487957773876 -0.21851939892249975 -0.013804476046464023 0.42805953367047966 0.70919939272491439 -0.025536574500391342 0.284123120382758 0.10035015481796923 0.22202688210017785 -0.34855624601187751 0.40566717584516604 0.18975283586413355 -0.15308746519452868 0.21280641181467297 -0.11435478643202841 -0.335387353806269 -0.30012905692526659;0.57058875404339293 0.30456267374671708 0.12910822086808416 0.53797693671300006 0.46181415064975623 0.55968162996431625 0.086142902329133117 0.3177549106818674 0.5577241880578705 -0.47844865160381056 -0.25944338518698395 -0.22749395950401249 -0.48037922171534292 0.43309456106762551 0.029796856038329215 -0.19236638988099083 -0.013710888709458012 -0.033541244462544695 0.2563206973785857 -0.11893858382179878 0.035099369947989512 0.29713409227023535 0.27620841954833147 0.22613808492729448 -0.3629681572664521;0.88795341486257762 0.27531484956962027 0.1411621837341186 1.9126178022901377 -0.72678152871897772 0.33790222666534042 0.91325723633603773 -1.1117709820278594 0.39154728702119695 0.38192280781540766 -0.41578456189466839 -0.37670318779418921 -1.4384410151870892 0.59334372950025538 -2.0663573969227564 1.0724823563954042 0.11662976342421809 -0.31131878148736492 -0.67916766958286223 -0.42226653882217174 0.4799882617065061 0.24039361595441708 -0.56064265434968652 0.059923894992712466 0.31022062185316313;-0.35732271287664058 0.59162264097067896 -0.30993617021991976 -0.012844363674405175 0.57793797828709459 -0.48949849818054736 0.22058529817069991 0.28839722864929535 0.41215512670611698 0.37491665347026226 -0.27382235786826836 0.38477759918329968 0.11248821323267419 -0.39972697380734828 -0.051749927161273537 0.57587546743447726 0.15199300919443173 0.13898360357793851 -0.35823015515220907 -0.1556491369127192 -0.028005051850790545 -0.13374584340483472 0.51047375980749021 0.11028386246472359 -0.22054289649792647;1.8062201264970135 1.663000222242611 1.006790353107812 0.066703535101506672 0.34035342181946937 0.33994625830442038 1.2415970423054066 0.55568466681027406 1.3459281487262211 1.7589109827633296 -0.78176042359753684 -0.047552331005489397 2.6015053048496046 -1.7537582089725308 -1.0898311380008094 -0.48157004091833761 -1.4360100631216666 -1.2521587698269292 -0.919785835858414 -0.55250376848410698 0.03465986349542053 0.69193056680769305 0.64332272234000498 -0.73693828470577738 0.17918927875539181;-0.15903606646717727 -0.14039585018967038 -0.25746398251600155 0.8006196076766221 0.17684177067364087 0.015315709242698176 -0.81771449922469597 0.14766792201393683 -0.095062744101418753 0.15631557904036433 -0.17316650701134695 -0.63587073406294836 0.65067402740075764 0.11533933571656717 0.61113369730641998 -0.16230497606221073 -0.68110084667163884 -0.062859110091774958 -0.13725991929836517 0.081613771346071937 0.48101106760061141 -0.50618326733596253 -0.21990666088219882 -0.10118039552373785 -0.046197154229668247;0.07831450132863492 0.22352390745304951 0.32676163009608766 0.18264883999078671 -0.18564803646051761 -0.2641498522249095 0.49922936976124077 0.56871892820802816 0.23171558188719282 -4.5891445965817761 -3.5024584591682495 -0.016477124714410357 -0.076305523779001239 0.17635461085072474 -0.45758380646132524 -0.88908776173778936 0.30993717897749323 0.20181808533342602 -1.0584356998802606 -0.43358437516783871 0.012219957054419837 -0.32000266415552459 -0.13189753288100292 -0.00075435327248995836 -0.42739291335043655;-0.10061380893229674 0.11143588946607939 -1.3109333388007114 -0.014821477189155854 -0.23603032645734731 1.1025210568073531 0.92984488423135581 -0.39630452853526327 0.60705592091488647 -0.26296185965134361 -1.041499608346826 -0.051247904761910656 -2.9791607743526147 1.2147101983575483 -1.6880118079428008 2.1154470333393074 -0.82845775256704712 -0.010719754681669103 0.26264505213181233 -0.84885159395677412 -0.033228008431078204 -0.37107275716178761 -0.21745896998107869 -0.46993821298861282 0.48745493816502894];

% Layer 2
b2 = [-0.77930686422519158;-0.30992509795385975;0.43481581289502486;0.89890749783705282];
LW2_1 = [0.3454167141129823 2.1735595270192904 -0.14716130564804436 4.2017753916080363 5.9310898427801328 0.45200874288922799 1.4079946791527354 0.88881890746876735 1.0383335143493959 -2.1247165312712926 -0.93122590509847192 4.2257783303428278 -0.36061365241424737;0.25558652879193938 1.941725455117159 -0.57626591828749996 -2.3626570774716589 -1.3272767449153227 0.59765170003062285 1.0440520187365907 -4.7304054225527885 0.037634484870714774 -0.078850584415615974 0.71825829517264728 0.52602397277488011 -3.463328372124014;-0.084490574937300111 -4.3474584808150913 1.9224366737332284 -3.7648407725945421 -2.9275778244047168 -1.1835789645929051 -0.29120118438822795 1.3356987901494055 -0.48639581696301515 -2.8057452016501516 -0.099822887990916029 -3.5601412540959596 3.0489343951529269;-0.84895801181716857 2.0390672552462719 -1.6987019434242292 2.7626208006324897 -2.8526764047182107 1.1854821505041895 -0.46512404936158058 2.3407220059939897 1.2515102976850208 4.4836477146601457 -0.37108096176773592 -2.0036846298982045 1.2269031260304022];

% ===== SIMULATION ========

% Dimensions
Q = size(x1,1); % samples

% Input 1
x1 = x1';
xp1 = mapminmax_apply(x1,x1_step1);

% Layer 1
a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*xp1);

% Layer 2
a2 = softmax_apply(repmat(b2,1,Q) + LW2_1*a1);

% Output 1
y1 = a2;
y1 = y1';
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
y = bsxfun(@minus,x,settings.xoffset);
y = bsxfun(@times,y,settings.gain);
y = bsxfun(@plus,y,settings.ymin);
end

% Competitive Soft Transfer Function
function a = softmax_apply(n,~)
if isa(n,'gpuArray')
    a = iSoftmaxApplyGPU(n);
else
    a = iSoftmaxApplyCPU(n);
end
end
function a = iSoftmaxApplyCPU(n)
nmax = max(n,[],1);
n = bsxfun(@minus,n,nmax);
numerator = exp(n);
denominator = sum(numerator,1);
denominator(denominator == 0) = 1;
a = bsxfun(@rdivide,numerator,denominator);
end
function a = iSoftmaxApplyGPU(n)
nmax = max(n,[],1);
numerator = arrayfun(@iSoftmaxApplyGPUHelper1,n,nmax);
denominator = sum(numerator,1);
a = arrayfun(@iSoftmaxApplyGPUHelper2,numerator,denominator);
end
function numerator = iSoftmaxApplyGPUHelper1(n,nmax)
numerator = exp(n - nmax);
end
function a = iSoftmaxApplyGPUHelper2(numerator,denominator)
if (denominator == 0)
    a = numerator;
else
    a = numerator ./ denominator;
end
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
a = 2 ./ (1 + exp(-2*n)) - 1;
end
