function [y1] = myNeuralNetworkFunction_KS(x1)
%MYNEURALNETWORKFUNCTION neural network simulation function.
%
% Generated by Neural Network Toolbox function genFunction, 29-Aug-2017 18:06:31.
%
% [y1] = myNeuralNetworkFunction(x1) takes these arguments:
%   x = Qx27 matrix, input #1
% and returns:
%   y = Qx4 matrix, output #1
% where Q is the number of samples.

%#ok<*RPMT0>

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.keep = [1 2 3 4 5 6 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27];
x1_step2.xoffset = [1.3e-05;2e-06;0;1.034102;5.666667;0.166667;0.510204;0;0.04918;0;16.825526;19.169329;0;-147;0;0;-7;0.000682561573178594;0.00558779303675048;0.000119660636306925;0;-1.4996;0.10872;0.00041268;1.0002;-93.679];
x1_step2.gain = [10.8829915167081;12.7019611828066;124.540755962389;0.827973241560779;0.03690036900369;0.631579080332438;0.00124805786906864;0.037037037037037;2.10344755053533;0.00123292194739055;0.010251859166971;0.0104306862151843;0.25;0.00796812749003984;0.0133333333333333;0.0178571428571429;0.0425531914893617;0.72248498963418;0.0419967006659664;0.494584412662678;0.600006000060001;0.53102514404057;1.07643785186062;56.43449140672;1.50003750093752;0.00872870740936329];
x1_step2.ymin = -1;

% Layer 1
b1 = [-0.63715646978310014;1.3313221158571993;-0.4432744067654244;-0.58129456074551356;0.38903245618836457;0.30913970157846965;-0.70945297922935058;-0.39902838367600574;-1.1724237850473707;-1.336921939722254];
IW1_1 = [0.5926187583333844 -0.70297720989049461 0.24972599017518385 -1.2462377962455977 0.25748365266147522 -1.5963584597716665 0.86360252688259875 -1.9935960543299924 -0.75633879814188443 1.4210587207363021 0.27172226031598534 -0.30454765921006871 -0.6043024832524142 -0.5201169799164167 0.66551266667996745 3.9272674509476229 2.9137704580390991 -2.4437373111267182 -1.7633503789089295 -1.670946296462781 -0.17292095639861013 -0.24026721968140125 0.0037333906115480059 2.0883308310462398 -0.073734311768652069 0.12681297367878869;-0.13190184664956506 -0.39958076726718533 0.12207008111785415 0.26036880639622512 -0.48640290891636567 0.31511271453666012 -0.046081000553411022 -0.43962485347473185 0.43623370274913642 0.073019824142794273 -0.024213840512993655 -0.26709331074064607 0.24583646110874818 -0.40512921442958771 -0.51867326805476122 0.03037563777267515 -0.30100121218082421 -0.43269303437158596 0.23903589734952863 -0.20588350137824865 -0.44658536454510672 -0.26708312270192114 0.21722453016103879 0.074075896455802565 0.17978784966233802 -0.21466885793449139;-0.56345687386756649 0.68804185752234837 0.27617518279854619 1.5638678111915636 -0.25772604323140907 -1.1754924725169487 0.083252742402889643 2.0880709144756771 1.3501185293172524 0.18775402676676958 -2.2301310912709988 -1.324755502593181 -0.21489375746930942 -0.043680664049482225 -0.15010380813049778 -2.2413133642495331 -0.91121449246926323 0.26983813909916343 0.24172302924553074 0.11586237913404647 -0.14481074807348585 -0.096453237474181761 -0.27979969589037801 1.7954777592516624 0.1706650763225061 -0.18469716267836123;0.64017000836353632 -0.26643187876587077 0.098305534427037197 0.14674356030782357 -0.16418352508654896 -0.15951012402183637 -0.39380182970756539 0.29712902345550829 -0.057429060960751038 0.20432184349674493 0.56045538515406135 0.082636437588214165 -0.27494893797316483 1.0311130173814618 -0.95796537624225953 0.98827651572328079 -0.41704492530460768 0.35099525228769474 -0.28122040926671421 -0.031401836107045736 0.7075424929385884 -0.42195067044308554 0.36842770628585647 -0.80833696448790415 0.36109347642343731 0.12656487823383111;-0.69287283780811293 -0.19251264544447391 -0.085387108903614992 0.35946234865041554 0.79016652245523067 -0.77662547246472868 -0.90252982606626853 0.57881854921080533 -1.4133726977459966 -0.15541552647193638 0.24718554380784255 -0.49881982575846268 0.83365932316758429 -1.4181153780759714 0.71680395070308256 -2.9233364026973621 0.31224846863064837 -0.068091442743075853 0.4020204552602325 -0.37927696426139523 -0.19770915956455148 0.26094022743718553 0.4517448197463505 0.1167815840757882 -0.19171353628037144 0.33338288698805085;0.3937399757277778 0.21871293269955008 -0.032257362082129662 -0.76673179466432639 0.55279242513487958 -0.61186890847448905 0.52219249253879951 -1.0521518483182546 -1.070245465575806 0.10401086165881734 0.27291689054371915 0.14943068574277438 -0.26037079578490724 0.81432214691880789 -0.046558315854247398 2.5306578065177527 0.20774314124259111 -1.476523067701391 -1.3965216104399121 -0.63948121097085375 0.54254702211205863 -0.18327063942183544 0.78117710240568494 0.82676763045759416 0.2617137941590939 -0.11684289470501985;0.76374090595487243 0.72948009172685613 0.93807438878352456 1.5232549617590239 -0.97406849508782334 0.87897529880153891 -0.21629268545760919 1.069479154985177 1.2891148633522784 -0.91578719675539211 -0.49976473366721164 0.039752923490873511 0.50998394157601101 2.3903300836194497 -1.4200979018816635 -0.085814975380993211 -1.9543371319388756 0.42198985186227345 0.11846115077516739 -0.33623206753088059 1.0552238742370672 -0.27365160906156971 0.5786030045578755 -1.015726358665058 -0.1364684585881796 -0.15580632403926717;-0.069907839757804582 0.3687127579377929 0.74003635275583357 0.018326750813947981 0.19660007547243571 1.9546049320181693 -0.60199642792787889 -0.72970181272350731 -0.78061703789582004 -0.62589399877963825 2.1665226276863745 1.8978552643206399 0.40069339366778289 -0.33165589723798461 0.10205696220450598 -0.18888389197372313 0.42748487170278848 -0.17184602640912336 -0.2777041856791031 0.40230411527234339 0.67765023008548164 -0.28570561576408321 -0.058667380137963611 -2.0664554676464277 -0.43653033676456177 -0.15325941276191482;0.38398866947747073 0.31665003200166597 0.017963792451874579 0.98646852539379359 0.99417642392841676 -0.60994955608573587 0.38826201196098048 1.1071552328510508 -0.20320284938904912 -0.086422161032366746 0.037365619075439421 -0.91516936935401216 -0.18348221925229186 1.4241294058582572 -1.3994897709056218 -0.97997689832713641 -1.8791748165569528 -0.20864608487626524 -0.27797464469093081 0.12634290742291546 -0.43693961934853726 -0.53415880063086452 -0.6856864092180962 -1.0229871552066137 0.81745432850632671 0.097510840266658891;0.20919606847198655 0.61480557434605276 0.45635421887134803 0.79303697898329817 0.78765904926998853 -0.48737292098290447 -0.42888145320838605 0.1866093471156117 -0.98468245661971765 0.1731125306191289 0.036673071613050869 -0.15073183514155591 0.063983231431146897 0.48726844457121571 -0.97557986342459813 -0.86145150655672009 -1.0764285247409624 -0.033583032662044494 -0.25129976355031214 -0.42326199437198281 -0.26896013643594546 0.32792606149113296 -0.30110009257923259 -1.2078677366777022 0.11958084420500033 -0.40955591403791891];

% Layer 2
b2 = [-1.8039342907969886;-0.32728180604135376;0.32346198903201218;-0.47528117346309956];
LW2_1 = [-6.2350134823679406 -0.4646679406921716 4.828717409790487 -0.39673955812439338 2.9907268712877628 -3.6497621778995564 1.9842554345051999 -3.2104270327351725 0.9459283563380132 0.51749655649285642;1.6206986188314276 0.050313201112999903 -2.1639731738728654 1.7234413770400092 -4.4877556403284879 1.0386783342542241 2.5982943015588154 -0.64883870217478323 -0.071019119803135744 -0.75103542171945503;3.9725683622306005 0.88304362500242362 -1.6595723511916902 -0.85786086981064835 1.4661285343431496 0.30233154964312925 -3.2543395668635831 2.2993285097654663 -4.0490482844510503 -2.4842714148476275;0.37135630425032623 -0.164700278924263 -1.0331006453231175 0.42835690108206304 0.53843710445113779 1.0151222507901945 -0.71860571746177837 1.5718295595690339 2.9224438046513148 2.2970175312575316];

% ===== SIMULATION ========

% Dimensions
Q = size(x1,1); % samples

% Input 1
x1 = x1';
xp1 = removeconstantrows_apply(x1,x1_step1);
xp1 = mapminmax_apply(xp1,x1_step2);

% Layer 1
a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*xp1);

% Layer 2
a2 = softmax_apply(repmat(b2,1,Q) + LW2_1*a1);

% Output 1
y1 = a2;
y1 = y1';
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
y = bsxfun(@minus,x,settings.xoffset);
y = bsxfun(@times,y,settings.gain);
y = bsxfun(@plus,y,settings.ymin);
end

% Remove Constants Input Processing Function
function y = removeconstantrows_apply(x,settings)
y = x(settings.keep,:);
end

% Competitive Soft Transfer Function
function a = softmax_apply(n,~)
if isa(n,'gpuArray')
    a = iSoftmaxApplyGPU(n);
else
    a = iSoftmaxApplyCPU(n);
end
end
function a = iSoftmaxApplyCPU(n)
nmax = max(n,[],1);
n = bsxfun(@minus,n,nmax);
numerator = exp(n);
denominator = sum(numerator,1);
denominator(denominator == 0) = 1;
a = bsxfun(@rdivide,numerator,denominator);
end
function a = iSoftmaxApplyGPU(n)
nmax = max(n,[],1);
numerator = arrayfun(@iSoftmaxApplyGPUHelper1,n,nmax);
denominator = sum(numerator,1);
a = arrayfun(@iSoftmaxApplyGPUHelper2,numerator,denominator);
end
function numerator = iSoftmaxApplyGPUHelper1(n,nmax)
numerator = exp(n - nmax);
end
function a = iSoftmaxApplyGPUHelper2(numerator,denominator)
if (denominator == 0)
    a = numerator;
else
    a = numerator ./ denominator;
end
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
a = 2 ./ (1 + exp(-2*n)) - 1;
end
