function classifyResult = challenge(recordName)
%challenge_siec - cz warunkw sieci cz normalnie dla noisy

% Version sieci1.0
%
%
% Written by: Chengyu Liu and Qiao Li January 20 2017
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by:
%
%
[tm,ecg,fs,siginfo]=rdmat(recordName);
[QRS,Rs] = qrs_detect2(ecg',0.25,0.6,fs);

if (isempty(QRS)||length(QRS)<3)
    [QRS,Rs] = qrs_detect2(ecg'*100,0.25,0.6,fs);
end

RR=diff(QRS);

%% filtracja
ord = 100;
fcutl = 1;
fcuth = 40;

b1 = fir1(ord,[2*fcutl/fs 2*fcuth/fs]);
ecg_1_40 = filtfilt(b1,1,ecg') ;

%% zapis parametrow do excela

%% moc
moc1 = bandpower(ecg',fs,[1 40])/(length(ecg'))*fs;
moc2 = bandpower(ecg',fs,[1 3])/(length(ecg'))*fs;
moc3 = bandpower(ecg',fs,[10 20])/(length(ecg'))*fs;

%% szerokosc pikow (liczba pikow szerokich)
zakres =  round(0.02*fs)-1;
angle=[];
for i =2:1:length(QRS)-1
    
    u = [-zakres, fs*(ecg_1_40(QRS(i)-zakres)-ecg_1_40(QRS(i)))];
    v = [zakres, fs*(ecg_1_40(QRS(i)+zakres)-ecg_1_40(QRS(i)))];
    
    angle(i) = acosd(dot(u,v)/(norm(u)*norm(v)));
    
end

angle=angle(angle<40);
angle=length(angle(angle>2*mean(angle)));


%% parametry
zmiana_sumy = sum(abs(diff(ecg)))/sum(abs(diff(movmean(ecg,8))));
qrs_num=length(QRS)/length(ecg')*fs;
zero_line = sum(abs(diff(sign(ecg_1_40))))/length(ecg_1_40)*fs;

roznice_RR= mean(abs(diff(RR)));

if(length(Rs)>0)
    
    procent_QRS_up = sum(Rs)/length(Rs);
else
    procent_QRS_up=-1;
end
%slowa = complexity(Rs)
[liczba_gr, max_gr] = beatPattern(ecg_1_40, fs, QRS);
std_RR = std(RR);

if(length(RR)>0)
    HR_mean = mean(60*fs./(RR));
else
    HR_mean=-1;
end

if(length(RR>2))
    sorrr=sort(60*fs./(RR));
    HR_mean_kw = mean(sorrr(1:end-2));
else
    HR_mean_kw=-1;
end

% dla AF
if length(QRS)>=2
    RR_AF = diff(QRS')/fs;
    AFEv = comput_AFEv(RR_AF);
    %Compute dRR intervals series
    dRR=comp_dRR(RR_AF);
    %Compute metrics
    [OriginCount,IrrEv,PACEv]=metrics(dRR);
else
    AFEv = NaN(); OriginCount= NaN();IrrEv= NaN();PACEv = NaN();
end

zmiana_sumy_roznice_RR = zmiana_sumy/roznice_RR;
zmiana_sumy_roznice_RR(zmiana_sumy_roznice_RR==Inf)=0;
zero_line_roznice_RR = zero_line/roznice_RR;
zero_line_roznice_RR(zero_line_roznice_RR==Inf)=0;

qrs_num_roznice_RR = qrs_num/roznice_RR;
qrs_num_roznice_RR(qrs_num_roznice_RR==Inf)=0;

qrs_num_liczba_gr = qrs_num/liczba_gr;
qrs_num_liczba_gr(qrs_num_liczba_gr==Inf)=0;
qrs_num_AFEv = qrs_num/AFEv;
qrs_num_AFEv(qrs_num_AFEv==Inf)=0;
roznice_RR_std_RR = roznice_RR/std_RR;
roznice_RR_std_RR(roznice_RR_std_RR==Inf)=0;

max_gr_HR_mean_kw = max_gr/HR_mean_kw;
max_gr_HR_mean_kw(max_gr_HR_mean_kw==Inf)=0;
HR_mean_HR_mean_kw = HR_mean/HR_mean_kw;
HR_mean_HR_mean_kw(HR_mean_HR_mean_kw==Inf)=0;
HR_mean_kw_AFEv = HR_mean_kw/AFEv;
HR_mean_kw_AFEv(HR_mean_kw_AFEv==Inf)=0;

parametry_all = [moc1, moc2,...
    zmiana_sumy, zero_line, qrs_num, ...
    roznice_RR,max_gr, std_RR, HR_mean, angle,...
    AFEv, OriginCount,PACEv,...
    HR_mean_HR_mean_kw
    ];


parametry_all_202 = [moc1, moc2,...
    zmiana_sumy, zero_line, qrs_num, ...
    roznice_RR, liczba_gr, max_gr, std_RR, HR_mean, HR_mean_kw, angle,...
    AFEv, OriginCount,IrrEv,PACEv,...
    zmiana_sumy_roznice_RR,...
    zero_line_roznice_RR,qrs_num_roznice_RR,...
    qrs_num_liczba_gr,	qrs_num_AFEv,	roznice_RR_std_RR,...
    max_gr_HR_mean_kw,	HR_mean_HR_mean_kw,	HR_mean_kw_AFEv
    ];

classifyResult = 'O'; % default

war1=moc1>0.02;
war2=moc2>0.1;
war4=zmiana_sumy>1.45;
war5=zero_line>28;
war6 = liczba_gr>6;
war7 = max_gr < 0.5;
war8 = PACEv < 0.2;
war9 = std_RR > 7;


war_noise=[war1,war2,war4,war5,war6, war7, war8, war9];

%% poczatkowe warunki plus bardzo pewne sieci


[respNO] = myNeuralNetworkFunction_zszs_balanced(parametry_all_202);

treshold = 0.9;
if(sum(war_noise)>3||liczba_gr>14||moc1>0.03||zero_line>50)
    classifyResult='~';
elseif  AFEv>38
    classifyResult = 'A';
elseif (respNO(1) == max(respNO) && max(respNO)>treshold)
    classifyResult='N';
elseif (respNO(3) == max(respNO) && max(respNO)>treshold)
    classifyResult='O';
elseif (respNO(4) == max(respNO) && max(respNO)>treshold)
    classifyResult='~';
elseif (respNO(2) == max(respNO) && max(respNO)>treshold)
    classifyResult='A';
else
    %% drzewko
    
    load Mdl_mniejN2
    Ynew = predict(Mdl_mniejN2, parametry_all);

    if  str2num(cell2mat(Ynew)) == 1
        classifyResult='N';
    elseif  str2num(cell2mat(Ynew)) == 3
        classifyResult='O';
    elseif  str2num(cell2mat(Ynew)) == 4
        classifyResult='~';
    elseif  str2num(cell2mat(Ynew)) == 2
        classifyResult='A';
    end
    
end
%end

end


