% detection of AF and AFL
function [NZsignal,Power,ff,MedianFSNM,MeanFSNM,MinFSNM,MaxFSNM,StdFSNM,MedianSpecWidth,MeanSpecWidth,MinSpecWidth,MaxSpecWidth,StdSpecWidth,MedianSpecArea,MeanSpecArea,MinSpecArea,MaxSpecArea,StdSpecArea,MedianDF,MeanDF,MinDF,MaxDF,StdDF,MedianRI,MeanRI,MinRI,MaxRI,StdRI] = func_TQfft(Y,SR,VB)

% QT elimination
if(VB>1)
    RRmean = median(VB(2:length(VB)) - VB(1:length(VB)-1));
    before=round(0.1*SR); % PR interval is between 120 and 200 ms, therefore PQ interval is between 70 and 100 ms
    after=round(0.5*SR*sqrt(RRmean/SR));
    Y(1:VB(1))=0;
    Y(VB(1):min((VB(1)+after),length(Y)))=0;
    for j=2:length(VB)-1;
        Y(max((VB(j)-before),1):min((VB(j)+after),length(Y)))=0;
    end;
    Y(max((VB(end)-before),1):VB(end))=0;
    Y(VB(end):end)=0;
end
NZelements = find(Y~=0);
NZsignal = Y(NZelements);
[Power,ff]=func_FFT(NZsignal,SR,256);
% Power(1:128) = 0;
if(~isempty(NZsignal))
    if(length(NZsignal)>6*SR)
        for i =1:1:round(length(NZsignal)/SR)-5
            NZsignalStrip = NZsignal(((i-1)*SR+1):(i+4)*SR);
            [PowerStrip,ffStrip]=func_FFT(NZsignalStrip,SR,256);
            [Max, FSNM(i)] = max(PowerStrip(1:20)); 
            
            %!!!!! new !!!!!!
            [Max, DF(i)] = max(PowerStrip(2:15)); % (3-15 Hz ???)
            RI(i) = sum(PowerStrip(2+DF(i)-1:2+DF(i)+1))/sum(PowerStrip(2:15));
            %!!!!!!!!!!!!!!!!
            
            for j = 1:1:9
                F = find(PowerStrip>j*0.1*Max);
                SpecWidth(i,j) = ffStrip(F(end)) - ffStrip(F(1));
                SpecArea(i,j) = sum(PowerStrip(F(1):F(end)));
            end
        end
        
        if(length(FSNM)>1) % i.e. round(length(NZsignal)/SR)-5 == 1
         
            MedianFSNM = median(FSNM);
            MedianSpecWidth = median(SpecWidth);
            MedianSpecArea = median(SpecArea);
            %!!!!! new !!!!!!
            MedianDF = median(DF);
            MedianRI = median(RI);
            %!!!!!!!!!!!!!!!!

            MeanFSNM = mean(FSNM);
            MeanSpecWidth = mean(SpecWidth);
            MeanSpecArea = mean(SpecArea);
            %!!!!! new !!!!!!
            MeanDF = mean(DF);
            MeanRI = mean(RI);
            %!!!!!!!!!!!!!!!!


            MinFSNM = min(FSNM);
            MinSpecWidth = min(SpecWidth);
            MinSpecArea = min(SpecArea);
            %!!!!! new !!!!!!
            MinDF = min(DF);
            MinRI = min(RI);
            %!!!!!!!!!!!!!!!!


            MaxFSNM = max(FSNM);
            MaxSpecWidth = max(SpecWidth);
            MaxSpecArea = max(SpecArea);
            %!!!!! new !!!!!!
            MaxDF = max(DF);
            MaxRI = max(RI);
            %!!!!!!!!!!!!!!!!

            StdFSNM = sqrt(sum((FSNM-MeanFSNM).^2)/length(FSNM));
            %!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            StdDF = sqrt(sum((DF-MeanDF).^2)/length(DF));
            StdRI = sqrt(sum((RI-MeanRI).^2)/length(RI));
            %!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        else
            MedianFSNM = FSNM;
            MedianSpecWidth = SpecWidth;
            MedianSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MedianDF = DF;
            MedianRI = RI;
            %!!!!!!!!!!!!!!!!

            MeanFSNM = FSNM;
            MeanSpecWidth = SpecWidth;
            MeanSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MeanDF = DF;
            MeanRI = RI;
            %!!!!!!!!!!!!!!!!
            
            MinFSNM = FSNM;
            MinSpecWidth = SpecWidth;
            MinSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MinDF = DF;
            MinRI = RI;
            %!!!!!!!!!!!!!!!!


            MaxFSNM = FSNM;
            MaxSpecWidth = SpecWidth;
            MaxSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MaxDF = DF;
            MaxRI = RI;
            %!!!!!!!!!!!!!!!!


            StdFSNM = 0; % sqrt(sum((FSNM-MeanFSNM).^2)/length(FSNM));
            StdDF = 0;
            StdRI = 0;
        end

        for i=1:9
           StdSpecWidth(i) = sqrt(sum((SpecWidth(:,i)-MeanSpecWidth(i)).^2)/9);
           StdSpecArea(i) = sqrt(sum((SpecArea(:,i)-MeanSpecArea(i)).^2)/9);
        end

   else
        NZsignalStrip = NZsignal;
        [PowerStrip,ffStrip]=func_FFT(NZsignalStrip,SR,256);
        [Max, FSNM] = max(PowerStrip(1:20));
        %!!!!! new !!!!!!
            [Max, DF] = max(PowerStrip(2:15)); % (3-15 Hz ???)
            RI = sum(PowerStrip(2+DF-1:2+DF+1))/sum(PowerStrip(2:15));
        %!!!!!!!!!!!!!!!!
        
        for j = 1:1:9
            F = find(PowerStrip>j*0.1*Max);
            SpecWidth(j) = ffStrip(F(end)) - ffStrip(F(1));
            SpecArea(j) = sum(PowerStrip(F(1):F(end)));
        end
            MedianFSNM = FSNM;
            MedianSpecWidth = SpecWidth;
            MedianSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MedianDF = DF;
            MedianRI = RI;
            %!!!!!!!!!!!!!!!!

            MeanFSNM = FSNM;
            MeanSpecWidth = SpecWidth;
            MeanSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MeanDF = DF;
            MeanRI = RI;
            %!!!!!!!!!!!!!!!!
            
            MinFSNM = FSNM;
            MinSpecWidth = SpecWidth;
            MinSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MinDF = DF;
            MinRI = RI;
            %!!!!!!!!!!!!!!!!


            MaxFSNM = FSNM;
            MaxSpecWidth = SpecWidth;
            MaxSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MaxDF = DF;
            MaxRI = RI;
            %!!!!!!!!!!!!!!!!


            StdFSNM = 0; % sqrt(sum((FSNM-MeanFSNM).^2)/length(FSNM));
            StdDF = 0;
            StdRI = 0;        
            StdSpecWidth(1:9) = 0;
            StdSpecArea(1:9) = 0;
    end        
else
    [Power,ff]=func_FFT(NZsignal,SR,256);
    Power(1:128) = 0;
    Max = 0;
    FSNM = 0;
    DF = 0;
    RI = 0;
    SpecWidth(1:9) = 0;
    SpecArea(1:9) = 0;
    
            MedianFSNM = FSNM;
            MedianSpecWidth = SpecWidth;
            MedianSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MedianDF = DF;
            MedianRI = RI;
            %!!!!!!!!!!!!!!!!

            MeanFSNM = FSNM;
            MeanSpecWidth = SpecWidth;
            MeanSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MeanDF = DF;
            MeanRI = RI;
            %!!!!!!!!!!!!!!!!
            
            MinFSNM = FSNM;
            MinSpecWidth = SpecWidth;
            MinSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MinDF = DF;
            MinRI = RI;
            %!!!!!!!!!!!!!!!!


            MaxFSNM = FSNM;
            MaxSpecWidth = SpecWidth;
            MaxSpecArea = SpecArea;
            %!!!!!!!!!!!!!!!!
            MaxDF = DF;
            MaxRI = RI;
            %!!!!!!!!!!!!!!!!


            StdFSNM = 0; % sqrt(sum((FSNM-MeanFSNM).^2)/length(FSNM));
            StdDF = 0;
            StdRI = 0;        
            StdSpecWidth(1:9) = 0;
            StdSpecArea(1:9) = 0;

end


