function [Y,o,k,g,VB,AmpVB,nv,AmpN,e,AmpPrE,ev,AmpSecE] = func_QRSanalysis(Y,SR)
flDraw = 0;

% Initialization of parameters, which have to be returned by the function
n = 0;
VB = 0;
% o = 0;
% k = 0;
% g = 0;
nv = 0; 
e = 0;
ev = 0;
%------------------------------------------------------------------------

% SR=125;		% 125 Hz sampling rate
T=1/SR;		% [s]
% comb filter with 1st zero in 25 Hz
Ycf(1:2)=Y(1:2); Ycf(length(Y)-1:length(Y))=Y(length(Y)-1:length(Y));
Ycf(3:length(Y)-2)=(Y(1:length(Y)-4) + Y(2:length(Y)-3) + Y(3:length(Y)-2) +...
   Y(4:length(Y)-1) +Y(5:length(Y)))/5;
Y=Ycf;

% high-pass filter
Fc=1;			% cut-off [Hz]
c1 = 1/[1+tan(Fc*pi*T)];
c2 = [1-tan(Fc*pi*T)]/[1+tan(Fc*pi*T)];
Y=Y-Y(1);
Yhp(1)=Y(1);
for j=2:length(Y);
  Yhp(j)=c1*(Y(j)-Y(j-1))+c2*Yhp(j-1);
end;
Y=Yhp;

%% Initialisation.

j=1;	% pointer for addresses of normal beat candidates stored in buffer n(j)
o=1;	% pointer for confirmed normal beat addresses transferred in buffer nv(o)
g=1;	% pointer for addresses of secondary detected ectopic beats transferred in buffer ev(g)
k=1;	% pointer for addresses of primary detected ectopic beats stored in buffer e(k)
durn=round(0.12/T);	% expected maximum width of normal beat candidate
dure=0.3/T;         % expected maximum width of ectopic beat
distn=0.2/T;		% expected distance between two consecutive beats
dev=round(0.08/T);	% window around ventricular beat candidate
var=round(0.14/T);	% another window around ventricular beat candidate
Mt=0.2;             % initial value of the adaptive threshold
M=Mt;               % M current value of the adaptive threshold
last=Mt;            % last detected peak > M
sl=0.8/SR;          % slope decreasing M to 0.2*M after 1 s
marg=3+1;           % border file margins where no ventricular beats can be searched
beg=3+1;            % initial value of detected address of ventricular beat candidate
done=0;             % flags 
q1=0.6; q2=0.7; ll=0.2; ul=0.4; cros=8;	% thresholds
v=1; w=1; st=1;                         % variables

% QRS detection.
for i=marg:length(Y)-marg;

% Current amplitude differences.
D1=Y(i)-Y(i-3);
D2=Y(i)-Y(i+3);

    % Comparison with the threshold.
    if (D1<0 &D2<0)|(D1>0 &D2>0);
        peak=abs(D1)+abs(D2);
        if peak>M;
            if abs(Y(i))<=0.4 &peak>0.3;
                p=q1;
            else
                p=q2;
            end;
             if j==1;
                last=peak; M=p*peak; Mp=M*sl; n(j)=i; j=j+1; beg=i; L=abs(Y(i)); 
             elseif j>1 &i-n(j-1)>=distn;
                last=peak; M=p*peak; Mp=M*sl; n(j)=i; j=j+1; beg=i; L=abs(Y(i));
             elseif j>1 &i-n(j-1)<distn &peak>last;
                last=peak; M=p*peak; Mp=M*sl; n(j-1)=i; beg=i; L=abs(Y(i));
             end;
        end;
    end;

    % Threshold modification.
    if i-beg>distn &i-beg<SR &M>Mt;
        M=M-Mp;
    elseif i-beg>SR &M>Mt;
        M=M-Mp/2;
    end;

% find the max for QRS mark
   if j>1 &i==beg+durn;
      if beg-durn<marg;
         left=marg;
      else
         left=beg-durn;
      end;
      Lmax=L; s=beg; Lpc=0; Lmc=0; lpc=0; lmc=0; cross=0;
      for m=left:i;
         if abs(Y(m))>Lmax;
            Lmax=abs(Y(m)); s=m;
         end;
         if Y(m)>Lpc;
            Lpc=Y(m);
         elseif Y(m)<Lmc;
            Lmc=Y(m);
         end;
      end;
      if s>dev;
         ldev=dev;
      else
         ldev=s-1;
      end;
      for m=s-ldev:min((s+dev),length(Y)) % Irena
         if Y(m)>max(.4*Lmax,.4);
            lpc=lpc+1;
         elseif Y(m)<min(-.4*Lmax,-.4);
            lmc=lmc+1;
         end;
      end;
      H(j-1)=Y(s); Lp(j-1)=Lpc; Lm(j-1)=Lmc; Lpp(j-1)=Lpc-Lmc; lp(j-1)=lpc; lm(j-1)=lmc;
      if s-var>marg;
         from=s-var;
      else
         from=marg;
      end;
      if s+var<i;
         to=s+var;
      else
         to=i;
      end;
      if Y(from)>ul*Lpc|Y(from)<ul*Lmc;
         in=1;
      else
         in=0;
      end;
      for m=from:to;
         if in==1 &((Y(m)>0 &Y(m)<ll*Lpc)|(Y(m)<0 &Y(m)>ll*Lmc));
            cross=cross+1; in=0;
         elseif in==0 &(Y(m)>ul*Lpc|Y(m)<ul*Lmc);
            in=1;
         end;
      end;
      if j>=13 % Irena j==13;
         Np=0; Nn=0; NpPos = []; NnPos = []; % Irena
         for m = (j-10):(j-2) % Irena m=3:11;
            if H(m)>=0;
               Np=Np+1;
               NpPos = [NpPos, m]; % Irena
            else
               Nn=Nn+1;
               NnPos = [NnPos, m]; % Irena
            end;
         end;
         if Np>Nn;
            Pol=1;
         else
            Pol=-1;
         end;
         while sign(H(m))~=sign(Pol);
            m=m-1;
         end;
%          Lpe=Lp(m); Lme=Lm(m); Lppe=Lpp(m); lpe=lp(m); lme=lm(m);

        %****************************** Irena *******************************************
        if(length(NpPos)>length(NnPos))
            Lpe=mean(Lp(NpPos)); Lme=median(Lm(NpPos)); Lppe=median(Lpp(NpPos)); lpe=median(lp(NpPos)); lme=median(lm(NpPos));
        else
            Lpe=mean(Lp(NnPos)); Lme=median(Lm(NnPos)); Lppe=median(Lpp(NnPos)); lpe=median(lp(NnPos)); lme=median(lm(NnPos));
        end
        %********************************************************************************

      end;

% confirmation of detected beats
      if Lmax>.08 &j==2 &cross<cros;
         n(j-1)=s; w=1; QT=1; st=1; done=0;
      elseif Lmax>.08 &j>2 &s-n(j-2)>distn &cross<cros;
         n(j-1)=s; w=1; QT=1; done=0;
         if j==3;
            nv(o)=n(j-2); o=o+1;
         end;
         
         if j>2 &QT==1;
            INT1=n(j-1)-n(j-2); INT=INT1; sINT=INT1;
            if j>3;
               INT2=n(j-2)-n(j-3); INT=(INT1+INT2)/2;
               if INT2<sINT;
                  sINT=INT2;
               end;
            end;
            if j>4;
               INT3=n(j-3)-n(j-4); INT=(INT1+INT2+INT3)/3;
               if INT3<sINT;
                  sINT=INT3;
               end;
            end;
            if j>5;
               INT4=n(j-4)-n(j-5); INT=(INT1+INT2+INT3+INT4)/4;
               if INT4<sINT;
                  sINT=INT4;
               end;
            end;
            mINT=(7*INT+1*sINT)/8;
            dist=.4*(1+4*mINT*T)/(4+mINT*T);
            if dist>.35; %corresponds to QT interval of HR~55 bpm using the approximate formula 
               dist=.35;
            end;
            dist=dist/T;
            distn=round(dist);
            QT=0;
         end;
         
% ectopic beats in long RR interval with compensation pause         
         if j>3 &(n(j-1)-n(j-2)>1.5*mINT|n(j-1)-n(j-2)>1.3*SR);
            if v==k;
               for h=st:k-1;
                  e(h)=susp(h);
               end;
            end;
            if v>k;
               if v-st>1 &abs(Y(susp(st)))<q1*abs(Y(susp(st+1)));
                  st=st+1; k=k-1;
               end;
               for h=st:v-1;
                  e(k)=susp(h); k=k+1;
               end;
            end;
         else
            if v>k;
               v=k;
            end;
         end;
         
         if k>1 &n(j-1)-e(k-1)<q2*distn;
            k=k-1; v=v-1;
         end;
         st=k;
         
         if Lmax>.08 &j>12;
            dLpp=abs(Lpp(j-1)-Lppe); dlp=abs(lp(j-1)-lpe); dlm=abs(lm(j-1)-lme); dLp=abs(Lp(j-1)-Lpe); dLm=abs(Lm(j-1)-Lme);
         end;
         if Lmax>.08 &j>12 &(dLpp>.4*Lppe|dlp>.02/T|dlm>.02/T|(dLpp>.2*Lppe &(dLp>.4*Lpe|dLm>.4*Lme) &sign(H(j-1))~=sign(Pol)));

%         if Lmax>.08 &j>12 &(dLpp>.5*Lppe|dlp>.05/T|dlm>.05/T|(dLpp>.25*Lppe &(dLp>.5*Lpe|dLm>.5*Lme) &sign(H(j-1))~=sign(Pol)));


%          if Lmax>.08 &j>12 &(dLpp>.4*Lppe|dlp>.02/T|dlm>.02/T|(dLpp>.2*Lppe &(dLp>.4*Lpe|dLm>.4*Lme))) % &sign(H(j-1))~=sign(Pol)));
         
            if((j>o+g-1) || (g==1)) % Irena % j>o+g-1;		% different (ectopic) beats
               ev(g)=s; g=g+1;
            elseif o>1 &s-nv(o-1)>distn;
               ev(g-1)=s;
            end;
         else						% similar to the assumed as normal beats
            if((j>o+g-1) || (o==1)) % Irena %  j>o+g-1;
               nv(o)=s; o=o+1;
            elseif g>1 &s-ev(g-1)>distn;
               nv(o-1)=s;
            end;
         end;
         
         if j>3 &n(j-1)-n(j-2)<1.6/T &n(j-2)-n(j-3)<.3*(n(j-1)-n(j-3)) &(g==1|(g>1 &ev(g-1)~=n(j-2) &ev(g-1)~=n(j-1)));
            ev(g)=n(j-2); g=g+1;
            if k>1 &e(k-1)>n(j-2) &e(k-1)<n(j-1);
               g=g-1;
            elseif o>2;
               nv(o-2)=nv(o-1); o=o-1;
            end;
         end;
         
         if Lmax>.4 &j>12;
          Lppe=.995*Lppe+.005*Lpp(j-1); Lpe=.995*Lpe+.005*Lp(j-1); Lme=.999*Lme+.001*Lm(j-1); lpe=round(.999*lpe+.001*lp(j-1)); lme=round(.995*lme+.005*lm(j-1)); 
         end;
      else
         j=j-1;
      end;
   end;
   
% detection of ectopic beats
   if j>1 &done==0 &i>=n(j-1)+durn;
      if Lmax<=.4;
         lev=.6;
      else
         lev=q1*Lmax;
      end;
      if .25*Lmax>.3;
         thr=.25*lev;
      else
         thr=.3;
      end;
      done=1;
   elseif j>1 &done==1 &i>=n(j-1)+durn;
      if w==1 &(abs(Y(i-1))<.25*Lmax|abs(Y(i-1))<.2);
         cr(w)=i; w=w+1;
         if Y(i)>0;
            u=-1;
         else
            u=1;
         end;
      end;
      if w==2 &u==-1 &Y(i)<-thr;
         cr(w)=i; w=w+1; u=1;
      elseif w==2 &u==1 &Y(i)>thr;
         cr(w)=i; w=w+1; u=-1;
      end;
      if w==3 &u==-1 &Y(i)<.1;
         cr(w)=i; w=w+1; u=1;
      elseif w==3 &u==1 &Y(i)>-.1;
         cr(w)=i; w=w+1; u=-1;
      end;
      
      if w==4;  
         a1=cr(w-3); A1=0;
         for m=cr(w-3):cr(w-2);
            if Y(cr(w-3))>0 &Y(m)>A1;
               A1=Y(m); a1=m;
            elseif Y(cr(w-3))<0 &Y(m)<A1;
               A1=Y(m); a1=m;
            end;
         end;
         a2=cr(w-2); A2=0;
         for m=cr(w-2):cr(w-1);
        		if Y(cr(w-2))>0 &Y(m)>A2;
                 A2=Y(m); a2=m;
        		elseif Y(cr(w-2))<0 &Y(m)<A2;
                 A2=Y(m); a2=m;
            end;
         end;
         
         int=a2-a1;
         
         if abs(A1)>.8*Lmax;
            crw=.7/T;
         else
            crw=.4/T;
         end;
         
         if abs(A2)>2*abs(A1);
            a=a2;
         else
            a=a1;
         end;
         
% confirmation of detected ectopic beats         
         if int>.03/T &int<dure & cr(w-1)-cr(w-3)<crw &abs(abs(A1)-abs(A2))<q1*(abs(A1)+abs(A2)) &abs(A1)+abs(A2)>lev;
            if k==1 &a-n(j-1)>distn;
               e(k)=a; k=k+1; susp(v)=a; v=v+1;
            elseif k>1 &a-n(j-1)>distn &a-e(k-1)>distn;
               e(k)=a; k=k+1;
               if v>1 &a-susp(v-1)>q2*distn;
                  susp(v)=a; v=v+1;
               end;
            elseif k==1 &v==1 &a-n(j-1)>q2*distn;
               susp(v)=a; v=v+1;
            elseif k>1 &v==1 &a-n(j-1)>q2*distn &a-e(k-1)>q2*distn;
               susp(v)=a; v=v+1;
            elseif k==1 &v>1 &a-n(j-1)>q2*distn &a-susp(v-1)>q2*distn;
               susp(v)=a; v=v+1;
            elseif k>1 &v>1 &a-n(j-1)>q2*distn &a-e(k-1)>q2*distn &a-susp(v-1)>q2*distn;
               susp(v)=a; v=v+1;
            end;
         elseif j>12 &v>1 &int>.03/T &k>1 &a-n(j-1)>q2*distn &a-e(k-1)>q2*distn &a-susp(v-1)>q2*distn &(abs((Y(a))-(Y(max((a-dev),1))))>.7*lev|abs((Y(a))-(Y(min((a+dev),length(Y)))))>.7*lev);
            susp(v)=a; v=v+1;
         end;
         cr(w-3)=cr(w-2); w=w-2; u=-u;
      end;
   end;
end;

% Correction of the numbers of detected beats.
   j=j-1; o=o-1; g=g-1; k=k-1; 

% disp(strcat('normal beats = ',num2str(o))); 
% disp(strcat('ectopic beats = ',(num2str(k+g))));
% disp([' ']);
% 
% Total ventricular beats
if k>0;
    vb=1; jj=1; kk=1;
    for vb=1:j+k;
        if (jj<=j &kk<k &n(jj)<e(kk))|(jj<=j &kk==k);
            VB(vb)=n(jj);
            if jj<j;
                jj=jj+1;
            end;
        elseif (kk<=k &jj<j &e(kk)<n(jj))|(kk<=k &jj==j); 
            VB(vb)=e(kk);
            if kk<k;
                kk=kk+1;
            end;
        end;
    end;
else
    VB=n;
end;
% patient='04936->';
% hours=8; minutes=27; seconds=14;
% channel='1^s^t';
% b1=['patient' ' ' num2str(patient) ',' ' ' num2str(hours) ':'  num2str(minutes) ':'  num2str(seconds) ',' ' ' num2str(channel) ' ' 'channel'];
% 
% start=[num2str(hours) '_' num2str(minutes) '_' num2str(seconds)];
% save (start,'VB','-mat');
% 


% When heartbeats are not detected
if(VB==0) AmpVB = 0; else AmpVB = Y(VB); end
if(nv==0) AmpN = 0; else AmpN = Y(nv); end
if(e==0) AmpPrE = 0; else AmpPrE = Y(e); end
if(ev==0) AmpSecE = 0; else AmpSecE = Y(ev); end


if(flDraw)
    figure(100)
    x=T:T:length(Y)*T;
    % x=B*T:T:B*T+ep;
    low=1.1*min(Y); high=1.1*max(Y);
    i=0;

    subplot(4,1,1);
    plot(x,Y,'k',nv*T,Y(nv),'b*'); %text(2.5, .5, b1);
%     if exist('e') &k>0; hold on;  plot(e*T,Y(e),'bo'); hold off; end;
%     if exist('ev') &g>0; hold on;  plot(ev*T,Y(ev),'bo'); hold off; end;
    if e>0&k>0; hold on;  plot(e*T,Y(e),'bo'); hold off; end;
    if ev>0&g>0; hold on;  plot(ev*T,Y(ev),'bo'); hold off; end;
    axis([i i+8 low high]);
    ylabel('[mV]');

    subplot(4,1,2);
    plot(x,Y,'k',nv*T,Y(nv),'b*');
%     if exist('e') &k>0; hold on;  plot(e*T,Y(e),'bo'); hold off; end;
%     if exist('ev') &g>0; hold on;  plot(ev*T,Y(ev),'bo'); hold off; end;
    if e>0&k>0; hold on;  plot(e*T,Y(e),'bo'); hold off; end;
    if ev>0&g>0; hold on;  plot(ev*T,Y(ev),'bo'); hold off; end;
    axis([i+8 i+2*8 low high]);
    ylabel('[mV]');

    subplot(4,1,3);
    plot(x,Y,'k',nv*T,Y(nv),'b*');
%     if exist('e') &k>0; hold on;  plot(e*T,Y(e),'bo'); hold off; end;
%     if exist('ev') &g>0; hold on;  plot(ev*T,Y(ev),'bo'); hold off; end;
    if e>0&k>0; hold on;  plot(e*T,Y(e),'bo'); hold off; end;
    if ev>0&g>0; hold on;  plot(ev*T,Y(ev),'bo'); hold off; end;
    axis([i+2*8 i+3*8 low high]);
    ylabel('[mV]');

    subplot(4,1,4);
    plot(x,Y,'k',nv*T,Y(nv),'b*');
%     if exist('e') &k>0; hold on;  plot(e*T,Y(e),'bo'); hold off; end;
%     if exist('ev') &g>0; hold on;  plot(ev*T,Y(ev),'bo'); hold off; end;
    if e>0&k>0; hold on;  plot(e*T,Y(e),'bo'); hold off; end;
    if ev>0&g>0; hold on;  plot(ev*T,Y(ev),'bo'); hold off; end;
    axis([i+3*8 i+4*8 low high]);
    xlabel('[s]'); ylabel('[mV]');
end
