function [Mean_Std_QRS,Median_Std_QRS,Max_Std_QRS,Min_Std_QRS,Range_Std_QRS,WidthQRS] = func_PCAqrs(Y,SR,VB)

if(length(VB)>2)
    RRmedian = round(median(VB(2:length(VB)) - VB(1:length(VB)-1)));
    Index = find(VB>RRmedian);
    if(RRmedian~=0)&&(Index(1)<=length(VB)-2)
        for i = Index(1):length(VB)-2
            if((VB(i)+round(0.45*SR)<length(Y))&&(VB(i)- round(0.35*SR)>0))
                QRSinterval(i,:) = Y((VB(i)- round(0.35*SR)):(VB(i)+round(0.45*SR)));
            end
        end
    else
            QRSinterval(1:round(0.8*SR)) = 0;
    end
 
    [COEFF,SCOREtmp,latent] = princomp(QRSinterval);
    QRSintervalPCA = -COEFF*SCOREtmp(1,:)'; % + COEFF*SCOREtmp(2,:)' + COEFF*SCOREtmp(3,:)';
 
    minQRSintervalPCA = min(QRSintervalPCA);
    maxQRSintervalPCA = max(QRSintervalPCA);
    K = 1/max([abs(minQRSintervalPCA),abs(maxQRSintervalPCA)]);
    
    QRSintervalPCA = K*QRSintervalPCA;
    for i=1:length(QRSinterval(:,1))
        QRSinterval(i,:) = K*QRSinterval(i,:);
%         figure(201);
%         plot(QRSinterval(i,:)); 
%         if(i==Index(1)) hold on; end
    end
    
%     plot(QRSintervalPCA,'r');
%     hold off;


    %-------- Calculation of WidthQRS -------------------------------------
    %  BEGIN of high slew rate wave 
    L=.08; %.08;  %  80 uV
    count = 0;
    LIN_beg = 0;

    i=round(0.35*SR);
    while(i>4 && LIN_beg == 0)
        D=abs(QRSintervalPCA(i)-QRSintervalPCA(i+4));
        if (D<=L && sign(QRSintervalPCA(i+3)-QRSintervalPCA(i+2))==sign(QRSintervalPCA(i+4)-QRSintervalPCA(i+3)))
            count=count+1; 
        else count=0; 
        end;
        if count==3
            LIN_beg=i; %i+4;             
        end;
        i = i - 1;
    end

    if(LIN_beg==0) LIN_beg = round(0.1*SR); end
    %--------------------------------------
    %  END of high slew rate wave 
    L=.08; %.08;  %  80 uV
    count = 0;
    LIN_end = 0;

    i=round(0.35*SR);
    while(i<length(QRSintervalPCA)-4 && LIN_end == 0)
        D=abs(QRSintervalPCA(i)-QRSintervalPCA(i+4));
        if (D<=L && sign(QRSintervalPCA(i+3)-QRSintervalPCA(i+2))==sign(QRSintervalPCA(i+4)-QRSintervalPCA(i+3)))
            count=count+1; 
        else count=0; 
        end;
        if count==3
            LIN_end=i+4;             
        end;
        i = i + 1;
    end

    if(LIN_end==0) LIN_end = length(QRSintervalPCA) - round(0.1*SR); end
    
    WidthQRS = LIN_end - LIN_beg;
    
%     plot(LIN_beg, QRSintervalPCA(LIN_beg), 'g*');
%     plot(LIN_end, QRSintervalPCA(LIN_end), 'm*');
%     plot(round(0.35*SR), QRSintervalPCA(round(0.35*SR)), 'c*');
%     hold off;
    
    %----------------------------------------------------------------------
    
    %-------- Calculation of the deviation from the first PCA vector ------
    for i = 1:length(QRSinterval(:,1))  %round(0.1*length(TRintervalPCA)):round(0.9*length(TRintervalPCA))
        Std_QRS(i) = sqrt(sum((QRSinterval(i,round(0.1*length(QRSintervalPCA)):round(0.9*length(QRSintervalPCA)))-QRSintervalPCA(round(0.1*length(QRSintervalPCA)):round(0.9*length(QRSintervalPCA)))').^2)/length(QRSinterval(:,1)));        
    end
    Mean_Std_QRS = mean(Std_QRS);          %(max(Std_QRS) - min(Std_QRS))/2
    Median_Std_QRS = median(Std_QRS);
    Max_Std_QRS = max(Std_QRS);
    Min_Std_QRS = min(Std_QRS);
    Range_Std_QRS = Max_Std_QRS - Min_Std_QRS;
    WidthQRS;
    %----------------------------------------------------------------------
else
    Mean_Std_QRS = 100;
    Median_Std_QRS = 100;
    Max_Std_QRS = 100;
    Min_Std_QRS = 100;
    Range_Std_QRS = 0;
    WidthQRS = 0;
end    
    
    
    



