function [MedianLeakage,MeanLeakage,MinLeakage,MaxLeakage,StdLeakage,MedianT,MeanT,MinT,MaxT,StdT] = func_Leak(Signal,SR)

%Calculating the period of the assessed signal and 
%combining the signal with a copy ot it which is shifted with T/2
if(~isempty(Signal))
    if(length(Signal)>5*SR)
        for i =1:1:round(length(Signal)/SR)-3
            SignalStrip = Signal(((i-1)*SR+1):(i+2)*SR);
            SUM1=0; SUM2=0; SUM3=0;
            for j=2:length(SignalStrip)
                SUM1=SUM1+abs(SignalStrip(j)-SignalStrip(j-1));
            end;
            T(i)=2*pi*(sum(abs(SignalStrip))-abs(SignalStrip(1)))/SUM1;
            T(i)=round(T(i));
            shift=round(T(i)/2);
            for j=(shift+1):length(SignalStrip)
                SUM2=SUM2+abs(SignalStrip(j)+SignalStrip(j-shift));
                SUM3=SUM3+abs(SignalStrip(j))+abs(SignalStrip(j-shift));
            end;
            Leakage(i)=SUM2/SUM3;
        end
    else
        SignalStrip = Signal;
        SUM1=0; SUM2=0; SUM3=0;
        for j=2:length(SignalStrip)
            SUM1=SUM1+abs(SignalStrip(j)-SignalStrip(j-1));
        end;
        T=2*pi*(sum(abs(SignalStrip))-abs(SignalStrip(1)))/SUM1;
        T=round(T);
        shift=round(T/2);
        for j=(shift+1):length(SignalStrip)
            SUM2=SUM2+abs(SignalStrip(j)+SignalStrip(j-shift));
            SUM3=SUM3+abs(SignalStrip(j))+abs(SignalStrip(j-shift));
        end;
        Leakage=SUM2/SUM3;
    end
else
    T = 0;
    Leakage = 0;
end
MedianLeakage = median(Leakage);
MeanLeakage = mean(Leakage);
MinLeakage = min(Leakage);
MaxLeakage = max(Leakage);
StdLeakage = sqrt(sum((Leakage-MeanLeakage).^2)/length(Leakage));

MedianT = median(T);
MeanT = mean(T);
MinT = min(T);
MaxT = max(T);
StdT = sqrt(sum((T-MeanT).^2)/length(T));
