function classifyResult = challenge(recordName)
flTest=1;
Fs = 250; %Hz
[tm,ecg,fs,siginfo]=rdmat(recordName);
ECG_250Hz = resample(ecg,250,300);

    % ---------------- QRS detection and analyses -------------------------
    [ECGfilt_250Hz,NbN,NbPrE,NbSecE,PosVB,AmpVB,PosN,AmpN,PosPrE,AmpPrE,PosSecE,AmpSecE] = func_QRSanalysis(ECG_250Hz,Fs);
    
    PosPVC_Tmp = [PosPrE PosSecE];
    [PosPVC,IX] = sort(PosPVC_Tmp,'ascend'); 
    AmpPVC_Tmp = [AmpPrE AmpSecE];
    AmpPVC = AmpPVC_Tmp(IX);
    
    RR_VB = (PosVB(2:end) - PosVB(1:end-1))/Fs;
    RR_N = (PosN(2:end) - PosN(1:end-1))/Fs;
    RR_PrE = (PosPrE(2:end) - PosPrE(1:end-1))/Fs;
    RR_SecE = (PosSecE(2:end) - PosSecE(1:end-1))/Fs;
    RR_PVC = (PosPVC(2:end) - PosPVC(1:end-1))/Fs;

    NbBeats = length(PosVB);
    NbNormalBeats = NbN;
    NbNormalBeatsPct = 100*NbNormalBeats/NbBeats;
    NbPrEctBeats = NbPrE;
    NbPrEctBeatsPct = 100*NbPrEctBeats/NbBeats;
    NbSecEctBeats = NbSecE;
    NbSecEctBeatsPct = 100*NbSecEctBeats/NbBeats;
    NbPVCBeats = NbPrEctBeats + NbSecEctBeats;
    NbPVCBeatsPct = 100*(NbPrEctBeats + NbSecEctBeats)/NbBeats;

    if(~isempty(RR_VB))
        MeanRR_VB = mean(RR_VB); 
        StdRR_VB = sqrt(sum((RR_VB-mean(RR_VB)).^2)/length(RR_VB)); 
        MinRR_VB = min(RR_VB);
        MaxRR_VB = max(RR_VB);
        MeanAmpVB = mean(AmpVB);
        StdAmpVB = sqrt(sum((AmpVB-mean(AmpVB)).^2)/length(AmpVB));
        MinAmpVB = min(AmpVB);
        MaxAmpVB = max(AmpVB);
    else
        MeanRR_VB = 0; 
        StdRR_VB = 0; 
        MinRR_VB = 0;
        MaxRR_VB = 0;
        MeanAmpVB = 0;
        StdAmpVB = 0;
        MinAmpVB = 0;
        MaxAmpVB = 0;
    end

    if(~isempty(RR_N))
        MeanRR_N = mean(RR_N);
        StdRR_N = sqrt(sum((RR_N-mean(RR_N)).^2)/length(RR_N));
        MinRR_N = min(RR_N);
        MaxRR_N = max(RR_N);
        MeanAmpN = mean(AmpN);
        StdAmpN = sqrt(sum((AmpN-mean(AmpN)).^2)/length(AmpN));
        MinAmpN = min(AmpN);
        MaxAmpN = max(AmpN);
    else
        MeanRR_N = 0;
        StdRR_N = 0;
        MinRR_N = 0;
        MaxRR_N = 0;
        MeanAmpN = 0;
        StdAmpN = 0;
        MinAmpN = 0;
        MaxAmpN = 0;
    end

    if(~isempty(RR_PrE))
        MeanRR_PrE = mean(RR_PrE);
        StdRR_PrE = sqrt(sum((RR_PrE-mean(RR_PrE)).^2)/length(RR_PrE));
        MinRR_PrE = min(RR_PrE);
        MaxRR_PrE = max(RR_PrE);
        MeanAmpPrE = mean(AmpPrE);
        StdAmpPrE = sqrt(sum((AmpPrE-mean(AmpPrE)).^2)/length(AmpPrE));
        MinAmpPrE = min(AmpPrE);
        MaxAmpPrE = max(AmpPrE);
    else
        MeanRR_PrE = 0;
        StdRR_PrE = 0;
        MinRR_PrE = 0;
        MaxRR_PrE = 0;
        MeanAmpPrE = 0;
        StdAmpPrE = 0;
        MinAmpPrE = 0;
        MaxAmpPrE = 0;
    end

    if(~isempty(RR_SecE))
        MeanRR_SecE = mean(RR_SecE);
        StdRR_SecE = sqrt(sum((RR_SecE-mean(RR_SecE)).^2)/length(RR_SecE));
        MinRR_SecE = min(RR_SecE);
        MaxRR_SecE = max(RR_SecE);
        MeanAmpSecE = mean(AmpSecE);
        StdAmpSecE = sqrt(sum((AmpSecE-mean(AmpSecE)).^2)/length(AmpSecE));
        MinAmpSecE = min(AmpSecE);
        MaxAmpSecE = max(AmpSecE);
    else
        MeanRR_SecE = 0;
        StdRR_SecE = 0;
        MinRR_SecE = 0;
        MaxRR_SecE = 0;
        MeanAmpSecE = 0;
        StdAmpSecE = 0;
        MinAmpSecE = 0;
        MaxAmpSecE = 0;
    end
    
    if(~isempty(RR_PVC))
        MeanRR_PVC = mean(RR_PVC);
        StdRR_PVC = sqrt(sum((RR_PVC-mean(RR_PVC)).^2)/length(RR_PVC));
        MinRR_PVC = min(RR_PVC);
        MaxRR_PVC = max(RR_PVC);
        MeanAmpPVC = mean(AmpPVC);
        StdAmpPVC = sqrt(sum((AmpPVC-mean(AmpPVC)).^2)/length(AmpPVC));
        MinAmpPVC = min(AmpPVC);
        MaxAmpPVC = max(AmpPVC);
    else
        MeanRR_PVC = 0;
        StdRR_PVC = 0;
        MinRR_PVC = 0;
        MaxRR_PVC = 0;
        MeanAmpPVC = 0;
        StdAmpPVC = 0;
        MinAmpPVC = 0;
        MaxAmpPVC = 0;
    end
 
    % ---------------- P wave detection and analyses -------------------------
    if(mean(AmpN))>0
      flPosP = 1;
    else
      flPosP = 0;
    end

   [Pwaves, Pinterval, Pwave_mediane, Pwave_std, Mean_Std_TR] = func_GenTemplatePwave(ECGfilt_250Hz(1:2:end),Fs/2,round(PosVB/2),flPosP);

    %----------------------------------------------------------------------

    [AFpct,AF,number,lev1,lev2,up,PosPtmp,AmpPtmp,Y] = func_PanalysisTodor(ECGfilt_250Hz(1:2:end),Fs/2,round(PosVB/2));
    lastPosPtmp = length(PosPtmp);
    [sort_PosPtmp,iPosPtmp] = sort(PosPtmp);
    for i=1:length(sort_PosPtmp)-1
        if(sort_PosPtmp(i)==sort_PosPtmp(i+1))
            lastPosPtmp = i-1;
            break
        end
    end
    PosP = PosPtmp(iPosPtmp(1:lastPosPtmp));
    AmpP = AmpPtmp(iPosPtmp(1:lastPosPtmp));

        
    PosVB_125Hz = round(PosVB/2);
    IdxFirstP = 1;
    Pcount_RRint = [];
    Pcount_RRint(1:length(PosVB)-1) = 0;
    for iRR = 1:1:length(PosVB_125Hz)-1
        for iP = IdxFirstP:1:length(PosP)
            if(~isempty(find(PosVB_125Hz(iRR):1:PosVB_125Hz(iRR+1)==PosP(iP))))
                Pcount_RRint(iRR) = Pcount_RRint(iRR) + 1; 
            else
                if(PosP(iP)<PosVB_125Hz(1))
                    IdxFirstP = iP+1;
                    continue
                else
                    IdxFirstP = iP;
                    break
                end
            end
        end
    end
    
    if(~isempty(Pcount_RRint))
        MeanPcount_RRint = mean(Pcount_RRint);
        Std_Pcount_RRint = sqrt(sum((Pcount_RRint-mean(Pcount_RRint)).^2)/length(Pcount_RRint));
        Double_Pcount_RRint_Pnt = 100*length(find(Pcount_RRint>1))/length(Pcount_RRint);
    else
        MeanPcount_RRint = 0;
        Std_Pcount_RRint = 0;
        Double_Pcount_RRint_Pnt = 0;
    end

    idxPcount_RRint_NZ = find(Pcount_RRint~=0);
    if(~isempty(idxPcount_RRint_NZ))
        MeanPcount_RRint_NZ = mean(Pcount_RRint(idxPcount_RRint_NZ));
        Std_Pcount_RRint_NZ = sqrt(sum((Pcount_RRint(idxPcount_RRint_NZ)-mean(Pcount_RRint(idxPcount_RRint_NZ))).^2)/length(Pcount_RRint(idxPcount_RRint_NZ)));
    else
        MeanPcount_RRint_NZ = 0;
        Std_Pcount_RRint_NZ = 0;    
    end
    

    NbP = length(PosP);
    if(NbP>1)
        PPint = PosP(2:end) - PosP(1:end-1);
    else
        PPint = 0;
    end
    
    if(~isempty(PPint))
        Mean_PPint = mean(PPint);
        Std_PPint = sqrt(sum((PPint-mean(PPint)).^2)/length(PPint));
        Min_PPint = min(PPint);
        Max_PPint = max(PPint);
        MeanAmpP = mean(AmpP);
        StdAmpP = sqrt(sum((AmpP-mean(AmpP)).^2)/length(AmpP));
        MinAmpP = min(AmpP);
        MaxAmpP = max(AmpP);
    else
        Mean_PPint = 0;
        Std_PPint = 0;
        Min_PPint = 0;
        Max_PPint = 0;
        MeanAmpP = 0;
        StdAmpP = 0;
        MinAmpP = 0;
        MaxAmpP = 0;
    end
    
    
    [TQsignal,Power,ff,MedianFSNM,MeanFSNM,MinFSNM,MaxFSNM,StdFSNM,MedianSpecWidth,MeanSpecWidth,MinSpecWidth,MaxSpecWidth,StdSpecWidth,MedianSpecArea,MeanSpecArea,MinSpecArea,MaxSpecArea,StdSpecArea,MedianDF,MeanDF,MinDF,MaxDF,StdDF,MedianRI,MeanRI,MinRI,MaxRI,StdRI] = func_TQfft(ECGfilt_250Hz,Fs,PosVB);
    [MedianLeak_TQsignal,MeanLeak_TQsignal,MinLeak_TQsignal,MaxLeak_TQsignal,StdLeak_TQsignal,MedianT_TQsignal,MeanT_TQsignal,MinT_TQsignal,MaxT_TQsignal,StdT_TQsignal] = func_Leak(TQsignal,Fs);
    [C, ComplArea, ComplFreq, ComplFreqLeak, Xtmp, Xnew]=func_ComplexityMeasure_ShortInt(TQsignal(1:2:end),length(TQsignal(1:2:end)),Fs/2,6); 
    [Mean_Std_PQRST,Median_Std_PQRST,Max_Std_PQRST,Min_Std_PQRST,Range_Std_PQRST,WidthQRS] = func_PCAqrs(ECGfilt_250Hz,Fs,PosVB);

   

    if(flTest)
        if(Mean_Std_TR>=0.5)
            classifyResult = '~';
        else
            if(AFpct<=50)
                if(MinRR_N<=0.574)
                    if(MeanRR_N<=0.61735)
                        if(Std_Pcount_RRint<=0.275)
                            classifyResult = 'O';
                        else
                            classifyResult = 'A';
                        end
                    else
                        if(MinRR_N<=0.422)
                            if(MeanDF<=2.8542)
                                classifyResult = 'N';
                            else
                                classifyResult = 'O';
                            end
                        else
                            if(MeanRR_N>0.76017)
                                classifyResult = 'O';
                            else
                                if(StdRR_VB<=0.06969)
                                    classifyResult = 'N';
                                else
                                    if(MeanAmpP<=0.04066)
                                        classifyResult = 'A';
                                    else
                                        classifyResult = 'O';
                                    end
                                end
                            end
                        end
                    end
                else
                    if(MeanRR_N>1.1898)
                        classifyResult = 'O';
                    else
                        if(StdRR_VB<=0.0604)
                            classifyResult = 'N';
                        else
                            if(Mean_Std_PQRST>0.20444)
                                classifyResult = 'N';
                            else
                                if(StdRR_N>0.09048)
                                    classifyResult = 'O';
                                else
                                    if(MeanAmpP<=0.00923)
                                        classifyResult = 'A';
                                    else
                                        if(MinLeak_TQsignal<=0.72419)
                                            classifyResult = 'N';
                                        else
                                            classifyResult = 'O';
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            else
                if(MeanRR_N<=0.71518)
                    if(MinLeak_TQsignal>0.72534)
                        classifyResult = 'A';
                    else
                        if(MinRR_N<=0.466)
                            classifyResult = 'A';
                        else
                            classifyResult = 'O';
                        end
                    end
                else
                    if(MeanAmpP<=0)
                        if(MeanRI<=0.64833)
                            classifyResult = 'A';
                        else
                            classifyResult = 'O';
                        end
                    else
                        if(C<=0.39283)
                            classifyResult = 'O';
                        else
                            if(NbNormalBeatsPct<=87.939)
                                classifyResult = 'O';
                            else
                                if(StdRR_VB>0.28212)
                                    classifyResult = 'O';
                                else
                                    if(StdRR_VB>0.17146)
                                        classifyResult = 'A';
                                    else
                                        if(MeanSpecWidth(8)<=2.2135)
                                            classifyResult = 'O';
                                        else
                                            classifyResult = 'A';
                                        end
                                    end
                                end
                            end
                        end
                    end
                end            
            end                
        end            
    end