/*
 * types.h
 *
 *  Created on: Feb 4, 2013
 *      Author: jtmakela
 */

#ifndef TYPES_H_
#define TYPES_H_

#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include <errno.h>
#include <time.h>

#include <linux/types.h>

#ifndef ssize_t
#define ssize_t int64_t
#endif

#ifndef _error
#define _error(msg) fprintf(stderr, "[%s:%u] %s: %s\n", __FUNCTION__, __LINE__, msg, strerror(errno))
#endif

#define _BV(x) (1 << x)

enum trigger_type {
	TRIGGERED_BEAT = 7,
	NORMAL_BEAT = 0,
	ARTIFACT = 8,
	ASYSTOLE = 9,
	VENTRICULAR = 2,
	SUPRAVENTRICULAR = 1,
	FUSION = 3,
	OTHER = 4,
	OTHER_PSEUDOBEAT = 5,
	UNREADABLE_PSEUDOBEAT = 6
};

struct data_channel {
	double *raw;
	double samples_per_mv;
};


struct data {
	size_t samples_per_channel;
	size_t number_of_channels;
	double sample_freq;
	time_t time_offset;

	struct data_channel *ch;
};

struct details {
	size_t samples_per_channel;
	size_t number_of_channels;
	double default_sample_rate;
	double projected_sample_rate;
	time_t time_offset;
};

#endif /* TYPES_H_ */
