/*
 * trig.h
 *
 *  Created on: Apr 13, 2015
 *      Author: hvaanane
 */

#ifndef SRC_TRIG_H_
#define SRC_TRIG_H_

#include "test_types.h"
#include "types.h"

#define TRIG_MAX_ANNOTATION_GROUPS 5 // maximum number of cluster groups / annotation

struct trig_missing_event{
	size_t start;
	size_t end;
	size_t expected_rr;
};

struct trig_missing_events{
	struct trig_missing_event *missing_range;
	size_t n_missing;
};

int trig_do(struct data *original_data, struct data *energy_data, struct data *filtered_data, struct test_events *events, struct test_event_infos *event_infos, struct test_ch_info *ch_info, char *conf_file, struct test_clusters *cluster_set);
int trig_define_notch_frequencies(struct data *data, struct data *notch_data, struct test_ranges *ch_ranges);
int trig_label_clusters_and_events(struct data *data, struct test_events *events, struct test_clusters *cluster_set, struct test_ch_info *ch_info);
int trig_define_ch_goodness(struct data *original_data, char *conf_file, struct test_ch_info *ch_info);
#endif /* SRC_TRIG_H_ */
