/*
 * tests.h
 *
 *  Created on: Aug 3, 2015
 *      Author: hvaanane
 */

#ifndef SRC_TESTS_H_
#define SRC_TESTS_H_

#include "types.h"
#include "test_types.h"





int tests_create_whitened_dataset2(struct data *data, struct test_events *events, int win_before, int win_after, double ****dataset);
int create_cinc2017_event_clusters(struct data *data,  double *ch_goodness, struct test_events *events,double ***dataset, size_t *process_these, size_t n_to_process, struct test_clusters *cluster_set);
int tests_recluster(struct data *data, double *ch_goodness, struct test_events *events,double ***dataset, char **bad_chs_in_dataset,float **badness_in_dataset, struct test_clusters *cluster_set);
size_t tests_free_cluster_match(struct data *data, size_t start, size_t end, struct test_clusters *cluster_set, double *ch_goodness, size_t min_n_beats, size_t *sample, double *sample_offset, int *best_n, double *corr);
size_t tests_one_ch_cluster_match(struct data *data, size_t start, size_t end, struct test_clusters *cluster_set, size_t min_n_beats, size_t *sample, double *sample_offset, int *best_n, double *corr);
int tests_combine_clusters(struct data *data, struct test_clusters *cluster_set, struct test_ch_info *ch_info);
int tests_get_cluster_correlations(double *ch_goodness, int compare_to,int start_from, struct test_clusters *cluster_set,int *cluster_offsets, double *cluster_corrs, int only_undefined);
int tests_get_max_cluster_correlation(double *ch_goodness, int this, enum test_trigger_type this_type, int min_n_beats, struct test_clusters *cluster_set,int *cluster_offset, double *cluster_corr);
int tests_define_cluster_markers(struct test_clusters *cluster_set, struct test_ch_info *ch_info);
int tests_define_cluster_event_timings(struct test_events *events,struct test_clusters *cluster_set,size_t start, size_t end, double *ratio_to_nn_, double *median_nn);
int tests_define_cluster_annotation_markers(struct test_events *events,struct test_clusters *cluster_set,struct test_ch_info *ch_info,ssize_t *event_cluster_ids,double **correlations_mat);
int tests_define_event_cluster_ids(struct test_events *events, ssize_t *event_cluster_ids, struct test_clusters *cluster_set);
int tests_print_first_cluster_beats(char *filename, struct data *data, struct test_events *events,  struct test_clusters *cluster_set, int n_beats);
int tests_free_clusters(struct test_clusters *cluster_set);
int tests_trigger_type_from_char(enum test_trigger_type *to_type,char from_type);
char  *tests_range_name(enum test_range_type type);
double test_define_cluster_event_probability(struct test_events *events, struct test_cluster *this_cluster);
int tests_get_cluster_tachyratio(struct test_events *events, struct test_cluster *this_cluster, double sfreq, double *tachy_ratio, double *extreme_tachy_ratio);
int tests_free_ch_info(struct test_ch_info *ch_info);
int tests_free_events(struct test_events *events);
int free_data(struct data *dat);
char tests_trigger_type_to_c(enum test_trigger_type i);
char  *tests_trigger_type_to_string(enum test_trigger_type i);
char  *tests_range_name(enum test_range_type type);
int tests_change_filename_ending(char *filename,char  *  parameter_filename, char *ending);
int tests_is_bad_range(enum test_range_type type);

int tests_get_one_ch_cluster_correlations(int compare_to, int start_from,struct test_clusters *cluster_set, int *cluster_offsets,double *cluster_corrs,int only_undefined, double win_before_s, double win_after_s, double fine_tune);



#endif /* SRC_TESTS_H_ */
