/*
 * test_types.h
 *
 *  Created on: Mar 18, 2015
 *      Author: hvaanane
 */

#ifndef SRC_TEST_TYPES_H_
#define SRC_TEST_TYPES_H_


#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include <errno.h>
#include <time.h>
#include <linux/types.h>

//#include "../types.h"

#ifndef ssize_t
#define ssize_t int64_t
#endif


#define N_REAL_TEST_LABELS 7
#define N_READABLE_TEST_LABELS (N_REAL_TEST_LABELS+1)
#define N_ALL_TEST_LABELS (N_REAL_TEST_LABELS+2)
#define N_EXTENDED_TEST_LABELS (2*N_ALL_TEST_LABELS)

enum test_trigger_type {
	TEST_BEAT_UNDEFINED = 0,
	TEST_NORMAL_BEAT = 1,
	TEST_SUPRAVENTRICULAR = 2,
	TEST_VENTRICULAR = 3,
	TEST_FUSION = 4,
	TEST_OTHER = 5,
	TEST_ARTIFACT = 6,
	TEST_OTHER_PSEUDOBEAT = 7,
	TEST_UNREADABLE_PSEUDOBEAT = 8,
	TEST_REFERENCE_BEAT_UNDEFINED = (TEST_BEAT_UNDEFINED+N_ALL_TEST_LABELS),
	TEST_REFERENCE_NORMAL_BEAT = (TEST_NORMAL_BEAT+N_ALL_TEST_LABELS),
	TEST_REFERENCE_SUPRAVENTRICULAR = (TEST_SUPRAVENTRICULAR+N_ALL_TEST_LABELS),
	TEST_REFERENCE_VENTRICULAR = (TEST_VENTRICULAR+N_ALL_TEST_LABELS),
	TEST_REFERENCE_FUSION = (TEST_FUSION+N_ALL_TEST_LABELS),
	TEST_REFERENCE_OTHER = (TEST_OTHER+N_ALL_TEST_LABELS),
	TEST_REFERENCE_OTHER_PSEUDOBEAT = (TEST_OTHER_PSEUDOBEAT+N_ALL_TEST_LABELS),
	TEST_REFERENCE_UNREADABLE_PSEUDOBEAT = (TEST_UNREADABLE_PSEUDOBEAT+N_ALL_TEST_LABELS),
	TEST_REFERENCE_ARTIFACT = (TEST_ARTIFACT+N_ALL_TEST_LABELS),

	TEST_REFERENCE_AF_START = 1001,
	TEST_REFERENCE_AF_END = 1002,
	TEST_REFERENCE_AF_ON = 1003,
};
/*
#define N_REAL_TEST_LABELS 5
#define N_READABLE_TEST_LABELS (N_REAL_TEST_LABELS+1)
#define N_ALL_TEST_LABELS (N_REAL_TEST_LABELS+2)
#define N_EXTENDED_TEST_LABELS (2*N_ALL_TEST_LABELS)

enum test_trigger_type {
	TEST_BEAT_UNDEFINED = 99,
	TEST_NORMAL_BEAT = 0,
	TEST_SUPRAVENTRICULAR = 1,
	TEST_VENTRICULAR = 2,
	TEST_FUSION = 3,
	TEST_OTHER = 4,
	TEST_OTHER_PSEUDOBEAT = 5,
	TEST_UNREADABLE_PSEUDOBEAT = 6,
	TEST_REFERENCE_BEAT_UNDEFINED = (TEST_BEAT_UNDEFINED+N_ALL_TEST_LABELS),
	TEST_REFERENCE_NORMAL_BEAT = (TEST_NORMAL_BEAT+N_ALL_TEST_LABELS),
	TEST_REFERENCE_SUPRAVENTRICULAR = (TEST_SUPRAVENTRICULAR+N_ALL_TEST_LABELS),
	TEST_REFERENCE_VENTRICULAR = (TEST_VENTRICULAR+N_ALL_TEST_LABELS),
	TEST_REFERENCE_FUSION = (TEST_FUSION+N_ALL_TEST_LABELS),
	TEST_REFERENCE_OTHER = (TEST_OTHER+N_ALL_TEST_LABELS),
	TEST_REFERENCE_OTHER_PSEUDOBEAT = (TEST_OTHER_PSEUDOBEAT+N_ALL_TEST_LABELS),
	TEST_REFERENCE_UNREADABLE_PSEUDOBEAT = (TEST_UNREADABLE_PSEUDOBEAT+N_ALL_TEST_LABELS)
};
*/
#define TO_TEST_REFERENCE_TYPE(t) (t<N_ALL_TEST_LABELS ? t+N_ALL_TEST_LABELS : t)

struct test_event{
	size_t sample;
	double sub_sample;   // floating point offset (in sample space) to the sample for exact event times
	enum test_trigger_type type;
	float probability;   // how sure we are that this really is an event of this type?
};

#define N_TEST_RANGES 34
#define N_EXTENDED_TEST_RANGES (2*N_TEST_RANGES)
#define TO_TEST_REFERENCE_RANGE(t) (t+N_TEST_RANGES)

enum test_range_type{
	TEST_RHYTHM_UNDEFINED = 0,  // Unknown
	TEST_UNREADABLE = 1,  // Unreadable (special annotations in standard annotation tests)
	TEST_ABNORMAL_RHYTHM = 2,
	REGION_OF_INTEREST = 3, // RESERVED for external notation related information, ROI
	TEST_SIGNAL_AMPLITUDE_DRIFT = 4,
	TEST_NOISY_NOTCHES = 5,
	TEST_SHORT_OUT_OF_RANGE = 6,
	TEST_SIGNAL_OUT_OF_RANGE = 7,
	TEST_LOW_SNR = 8,
	TEST_NO_SIGNAL = 9,
	TEST_NO_ENERGY_SIGNAL = 10,
	TEST_SIGNAL_LEVEL_CHANGE = 11,
	TEST_RETURNING_AMPLITUDE_DRIFT = 12,
	TEST_COMBINED_ANOMALY = 13,
	TEST_NORMAL_RHYTHM = 14,
	TEST_VF = 15,			 // Ventricular fibrillation (not included in standard annotation tests)
	TEST_AF = 16,
	TEST_AFL = 17,
	TEST_VT = 18,
	TEST_SVT = 19,
	TEST_AVJ = 20,
	TEST_V_PAIR = 21,
	TEST_V_TRIPLET = 22,
	TEST_V_RUN = 23,
	TEST_BIGEMINY = 24,
	TEST_TRIGEMINY = 25,
	TEST_QUADRIGEMINY = 26,
	TEST_SINUSBRADYCARDIA = 27,
	TEST_2DEGHEARTBLOCK = 28,
	TEST_PACED = 29,
	TEST_IVR = 30, // idioventricular
	TEST_NOD = 31, // nodal (AV-junctional)
	TEST_PREX = 32, // Pre-excitation (WPW)
	TEST_RANGE_ST = 33,
	TEST_REFERENCE_UNREADABLE = (TEST_UNREADABLE+N_TEST_RANGES),
	TEST_REFERENCE_REGION_OF_INTEREST = (REGION_OF_INTEREST+N_TEST_RANGES),
	TEST_REFERENCE_VF = (TEST_VF+N_TEST_RANGES),
	TEST_REFERENCE_AF = (TEST_AF + N_TEST_RANGES),
	TEST_REFERENCE_BIGEMINY = (TEST_BIGEMINY + N_TEST_RANGES),
	TEST_REFERENCE_TRIGEMINY = (TEST_TRIGEMINY + N_TEST_RANGES),
};


#define TEST_EVENT_OK_BUT_CORRUPTED 5
#define TEST_EVENT_OK_BUT_SATURATED 3
#define TEST_EVENT_TOTALLY_OK 0
#define TEST_EVENT_TOTALLY_BAD 10

#define TESTS_TYPES_IS_BAD_RANGE(range_type) (range_type==TEST_NOISY_NOTCHES)


struct test_range{
	size_t start;
	size_t end;
	enum test_range_type type;
};

struct test_events{
	size_t n_events;
	struct test_event *events;
	size_t n_ranges;
	struct test_range *ranges;
};

struct test_ranges{
	size_t n_ranges;
	struct test_range *ranges;
};

struct test_old_ch_info{
	int nch;
	double *ch_goodness;
	struct test_ranges *ch_ranges;
};

struct test_ch_info{
	int nch;
	double *amplitude_normalization;
	double *ch_goodness;
	struct test_ranges *ch_ranges;
};

struct test_event_info{
	size_t sample;
	char *info_txt;
};

struct test_event_infos{
	size_t n_infos;
	struct test_event_info *event_infos;
};

struct test_event_markers{
	char name[100];
	double *values;
	int n_values;
	double range_min_value;
	double range_max_value;
};

struct test_marker_events{
	char name[100];
	int ch;
	size_t n_samples;
	size_t *samples;
};

enum test_data_format{
	AHA_TXT = 0,
	BRAEMAR_JSON = 1,
	MITDATA = 2,
	MC10_CSV = 3,
	HEARTBUG = 4,
	ONEBYTE3CH = 5,
	RIJUVEN_CSV = 6,
	POLAR_TXT = 7,
	SHORT_STRUCT_DATA = 8,
	GE_ONL500 = 9,
	VTT_TXTDATA = 10,
	DOUBLE_STRUCT_DATA = 11,
};

enum test_reference_format{
	NO_REFERENCE = -1,
	AHA_TXT_REFERENCE = 0,
	MIT_REFERENCE = 2,
	QRSCARD_REFERENCE = 3,
	JSON_REFERENCE = 4,
	BINARY_REFERENCE = 5,
};

enum test_method{
	ORIGINAL_TRIGGER = 0,
	TEST_TRIGGER = 1,
	BRAEMAR_LASSE = 2,
	AINEISTO_TRIGGER = 3,
};

struct test_cluster_markers{
	float qrs_onset;
	float qrs_offset;
	double qrs_width;
	double *initial_qrs_slope_length;
	double *max_qrs_slope;
	double *qrs_power;
	int *n_qrs_waves;

};

struct test_cluster_annotation_markers{
	double similarity_to_normals;
	double one_ch_similarity_to_normals;
	double diff_from_normals;
	double close_by_similarity;
	double event_timing;
	double tachy_ratio;
	double extreme_tachy_ratio;
};

struct test_cluster{
	enum test_trigger_type type;    // type / label of the beat
	int main_type_group;			// index of the main group where cluster belongs to.
	size_t n_beats;					// number of beats / events in cluster (includes all the templates)
	size_t *inds;                   // indexes of the beats / events that 'belong to' this cluster
	int cluster_offset;             // offset (in multiplied frequency) against 'main cluster'
	int *sample_offsets;            // offset (in multiplied frequency) of each event. The actual offset of each of the events is sum of both cluster and sample offsets
	int n_templates;                // number of templates
	char **bad_chs;                 // flags for bad channels [n_templates][nch].
	float **ch_badness;             // badness [0,1] of the all the bad channels in each template [n_templates][nch].
	double ***templates;
	double ****template_sets;
	size_t n_ave;
	struct test_cluster_annotation_markers annotation_markers;
	struct test_cluster_markers *markers;
};



struct test_clusters{
	int nch;
	double original_freq;
	int frequency_mult;
	int template_offset;
	int template_len;
	int template_in_sets_len;
	int n_move;
	int n_clusters;
	struct test_cluster *clusters;
};

#endif /* SRC_TEST_TYPES_H_ */
