/*
 * rhythm.h
 *
 *  Created on: Nov 18, 2015
 *      Author: hvaanane
 */

#ifndef SRC_RHYTHM_H_
#define SRC_RHYTHM_H_

#include "trig.h"

struct rhythm_hrv_markers{
  double min_bpm;
  double ave_bpm;
  double max_bpm;
  double sdnn;
  double rmssd;
  double pnn20;
  double pnn50;
};


double *rhythm_simplified_bpm_entropy(struct test_events *events, double freq, int win_len, double leave_out);
double *rhythm_short_bpm_entropy(struct test_events *events, double freq, double win_duration, double step_size);
double *rhythm_variability(struct test_events *events, double freq, double win_duration, double step_size);
int rhythm_normality_for_events(struct test_events *events,double *ratio_to_nn, double *median_nn_, double default_nn,int ignore_artifacts);
int rhythm_identify_missing(struct test_events *events,double *ratio_to_nn, double *median_nn, double freq, struct trig_missing_events *missing_events);
double rhythm_reset_af_ranges(struct test_events *events, double freq);
int rhythm_hrv(struct test_events *events, double freq, struct rhythm_hrv_markers *markers);
double *rhythm_define_rr(struct test_events *events, double freq);

#endif /* SRC_RHYTHM_H_ */
