/*
 * memory_manager.h
 *
 *  Created on: Apr 8, 2015
 *      Author: jtmakela
 */

#ifndef SRC_UTILS_MEMORY_MANAGER_H_
#define SRC_UTILS_MEMORY_MANAGER_H_

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdint.h>
#include <errno.h>
#include <pthread.h>
#include <unistd.h>

#define PERROR(str) { fprintf(stderr, "[%s:%u] %s: %s\n", __FILE__, __LINE__, str, strerror(errno)); }

#ifdef USE_MEMORY_MANAGER
void *_my_malloc(size_t size, char const * const file, size_t const line);
void _my_free(void *ptr, char const * const file, size_t const line);
void *_my_calloc(size_t nmemb, size_t size, char const * const file, size_t const line);
void *_my_realloc(void *ptr, size_t size, char const * const file, size_t const line);
void memory_manager_atexit(void);

#define my_malloc(_a)		(_my_malloc((_a), __FILE__, __LINE__))
#define my_calloc(_a, _b)	(_my_calloc((_a), (_b), __FILE__, __LINE__))
#define my_realloc(_a, _b)	(_my_realloc((_a), (_b), __FILE__, __LINE__))
#define my_free(_a)			(_my_free((_a), __FILE__, __LINE__))

#else
#ifdef SHARED_OBJ
void *my_malloc(size_t size);
void my_free(void *ptr);
void *my_calloc(size_t nmemb, size_t size);
void *my_realloc(void *ptr, size_t size);
#else
#define my_malloc(size)			(malloc(size))
#define my_free(ptr)			(free(ptr))
#define my_calloc(nmemb, size)	(calloc(nmemb, size))
#define my_realloc(ptr, size)	(realloc(ptr, size))
#endif /* SHARED_OBJ */
#endif /* USE_MEMORY_MANAGER */

#endif /* SRC_UTILS_MEMORY_MANAGER_H_ */
