/*
 * matrix.c
 *
 *  Created on: Jan 26, 2016
 *      Author: hvaanane
 */

#include "types.h"
#include "memory_manager.h"

char **matrix_malloc_c(size_t dim1,size_t dim2){
	size_t i;
	char *cmat2,**cmat;
	cmat2 = my_malloc(dim1 * dim2 * sizeof(char));
	cmat = my_malloc(dim1 * sizeof(char *));

	for (i = 0; i < dim1; i++) {
		cmat[i] = cmat2+i*dim2;
	}
	return(cmat);
}

char **matrix_calloc_c(size_t dim1,size_t dim2){
	size_t i;
	char *cmat2,**cmat;
	cmat2 = my_calloc(dim1 * dim2,sizeof(char));
	cmat = my_calloc(dim1,sizeof(char *));

	for (i = 0; i < dim1; i++) {
		cmat[i] = cmat2+i*dim2;
	}
	return(cmat);
}

void matrix_free_c(char **templates){
	if(templates==NULL){
		return;
	}
	my_free(*templates);
	my_free(templates);
}

float **matrix_malloc_f(size_t dim1,size_t dim2){
	size_t i;
	float *fmat2,**fmat;
	fmat2 = my_malloc(dim1 * dim2 * sizeof(float));
	fmat = my_malloc(dim1 * sizeof(float *));

	for (i = 0; i < dim1; i++) {
		fmat[i] = fmat2+i*dim2;
	}
	return(fmat);
}

float **matrix_calloc_f(size_t dim1,size_t dim2){
	size_t i;
	float *fmat2,**fmat;
	fmat2 = my_calloc(dim1 * dim2,sizeof(float));
	fmat = my_malloc(dim1 * sizeof(float *));

	for (i = 0; i < dim1; i++) {
		fmat[i] = fmat2+i*dim2;
	}
	return(fmat);
}

void matrix_free_f(float **templates){
	if(templates==NULL){
		return;
	}
	my_free(*templates);
	my_free(templates);
}


double **matrix_malloc_d(size_t dim1,size_t dim2){
	size_t i;
	double *dmat2,**dmat;
	dmat2 = my_malloc(dim1 * dim2 * sizeof(double));
	dmat = my_malloc(dim1 * sizeof(double *));

	for (i = 0; i < dim1; i++) {
		dmat[i] = dmat2+i*dim2;
	}
	return(dmat);
}

double **matrix_calloc_d(size_t dim1,size_t dim2){
	size_t i;
	double *dmat2,**dmat;
	dmat2 = my_calloc(dim1 * dim2,sizeof(double));
	dmat = my_malloc(dim1 * sizeof(double *));

	for (i = 0; i < dim1; i++) {
		dmat[i] = dmat2+i*dim2;
	}
	return(dmat);
}

void matrix_free_d(double **templates){
	if(templates==NULL){
		return;
	}
	my_free(*templates);
	my_free(templates);
}

double ***matrix_malloc_d3_(size_t dim1, size_t dim2, size_t dim3, char const * file, unsigned int const line) {
	size_t i,j;
	double *dmat3,**dmat2,***dmat;
	/*dmat3 = _my_malloc(dim1 * dim2 * dim3 * sizeof(double), file, line);
	dmat2 = _my_malloc(dim1 * dim2 * sizeof(double *), file, line);
	dmat =  _my_malloc(dim1 * sizeof(double **), file, line);*/

	dmat3 = my_malloc(dim1 * dim2 * dim3 * sizeof(double));
	dmat2 = my_malloc(dim1 * dim2 * sizeof(double *));
	dmat =  my_malloc(dim1 * sizeof(double **));

	for (i = 0; i < dim1; i++) {
		dmat[i] = dmat2+i*dim2;
		for (j = 0; j < dim2; j++) {
			dmat2[i*dim2+j] = dmat3+(i*dim2+j)*dim3;
		}
	}
	return(dmat);
}

double ***matrix_calloc_d3(size_t dim1,size_t dim2,size_t dim3){
	size_t i,j;
	double *dmat3,**dmat2,***dmat;
	dmat3 = my_calloc(dim1 * dim2 * dim3,sizeof(double));
	dmat2 = my_malloc(dim1 * dim2 * sizeof(double *));
	dmat =  my_malloc(dim1 * sizeof(double **));

	for (i = 0; i < dim1; i++) {
		dmat[i] = dmat2+i*dim2;
		for (j = 0; j < dim2; j++) {
			dmat2[i*dim2+j] = dmat3+(i*dim2+j)*dim3;
		}
	}
	return(dmat);
}

void matrix_free_d3(double ***templates){
	if(templates==NULL){
		return;
	}
	my_free(**templates);
	my_free(*templates);
	my_free(templates);
}
