/*
 * data.c
 *
 *  Created on: Oct 24, 2016
 *      Author: hvaanane
 */

#include <stdio.h>

#include "types.h"
#include "test_types.h"
#include "memory_manager.h"



int data_initiate_based_on_template(struct data *to, struct data const * const from){
	int ch;
	to->sample_freq=from->sample_freq;
	to->samples_per_channel=from->samples_per_channel;
	to->number_of_channels=from->number_of_channels;
	to->time_offset=from->time_offset;
	// alloc
	to->ch = my_malloc(sizeof(struct data_channel)*(to->number_of_channels));
	if(!to->ch){
		perror("Unable to allocate data template\n");
		return(1);
	}
	for(ch=0;ch<to->number_of_channels;ch++){
		to->ch[ch].samples_per_mv=from->ch[ch].samples_per_mv;
		to->ch[ch].raw=NULL;
	}
	return(0);
}

int data_initiate_and_alloc_based_on_template(struct data *to, struct data const * const from){
	int ch;
	to->sample_freq=from->sample_freq;
	to->samples_per_channel=from->samples_per_channel;
	to->number_of_channels=from->number_of_channels;
	to->time_offset=from->time_offset;
	// alloc
	to->ch = my_malloc(sizeof(struct data_channel)*(to->number_of_channels));
	if(!to->ch){
		perror("Unable to allocate data template\n");
		return(1);
	}
	for(ch=0;ch<to->number_of_channels;ch++){
		to->ch[ch].samples_per_mv=from->ch[ch].samples_per_mv;
		to->ch[ch].raw=my_calloc(sizeof(double),(to->samples_per_channel));
		if(to->ch[ch].raw==NULL){
			perror("Unable to allocate data ch\n");
			return(1);
		}
	}
	return(0);
}
