/*
 * conf.h
 *
 *  Created on: Feb 19, 2016
 *      Author: hvaanane
 */

#ifndef SRC_CONF_H_
#define SRC_CONF_H_


#include "types.h"

struct conf_cluster{
	double move;						// maximum movement of the beat window
	double win_before;					// beat window start before the event sample
	double win_after;					// beat window end after the event sample
	double ave_win_before;              // start of the average before the event sample
	double ave_win_after;               // end of the average after the event sample
	int frequency_mult;					// frequency multiplication for resampling the templates
	int max_n_ave;						// maximum number of beats included in average
	double similarity_limit_for_averaging;	// similarity limit for selecting beats to average template
	double similarity_limit;			// similarity limit for selecting beats to cluster
	double similarity_limit_for_clusters;	// similarity limit for regrouping the clusters
	double similarity_limit_for_cluster_offsets; // similarity limit for setting cluster offsets to match
	double minimum_similarity_for_normals; // minimum similarity value for two normal clusters
	double maximum_std_difference[2];     // relative [0] and absolute [1] limit values for original std difference (before whitening)
	double allowed_amplitude_variation_mult; // multiple that defines relative amplitude (std) beat-to-beat variation that isn't penalized (e.g. for 25 % variation, defined value is 1.25 %)
};

struct conf_trig{
	char reject_amplitude_drifts;
	char reject_saturated;
	char reject_no_signal;
	char reject_notchy_signal;
	enum trig_ch_goodness{TRIG_NO_CH_GOODNESS = 0} ch_goodness_mode;

	enum trigger_algorithm{TRIG_SLOPES = 0,TRIG_SD = 1, TRIG_ABSDIFF = 2} type;
	enum trigger_algorithm_mode{MINMAX_DIFFERENCE = 0,MIN_ABSMAX = 1,MINWEIGHTED_DIFFERENCE = 2} mode;
	double step_len;
	double win_len;
	double min_rr;
	double max_rr;
	int define_ch_events;
	int require_all_ch_above_threshold;
	double max_below_threshold;
	double threshold_high_weight;
	double notch_rel_limit;
	double notch_abs_limit;
	double data_max;
	double data_min;
	struct bp_filter{
		enum filter_type{IIR,FIR,NONLINEAR,NOFILTER} type;
		int length;
		double low;
		double high;
	} bp_filter;
  int keep_artifacts;
};

struct conf_qrs{
	double low_pass; 			// low pass cutoff frequency
	double energy_win_len; 		// length of the max deviation window (s)
	double onset_win_start;		// start of the onset window relative to QRS detection (s)
	double onset_win_end; 		// end of the onset window relative to QRS detection
	double offset;				// approximative time from QRS detection to QRS offset
	double abs_threshold_limit; // absolute threshold component to stabilize the partly relative limit value
	double drop_time;
};


struct conf_t_wave{
	double line_fit_len;
	double parabole_fit_len;
	double min_amplitude;
	double min_onset_slope;
	double min_offset_slope;
	double min_qt_apex_x0;
	double max_qt_apex_x0;
	double qtrr_apex_k;
	double max_tpe_def;
	double tq_deadtime;
	double qt_deadtime;
};

struct conf_baseline{
  double seek_win_len;
  double qr_estimate;
  double def_win_len;
  double min_rr;
  double min_extra_rr;
};

struct conf_rhythm{
	double tachy_limit;  // in bpm
	double extreme_tachy_limit;  // in bpm
	char set_supraventriculars_during_af; // flag to chose if 'S' is used during AF (all should all the 'normal looking beat' set as 'N')


};

struct conf_plot{

};

int conf_cluster_set_default(struct data *data);
int conf_initialize(struct data *data, char *filename);
int conf_set(char const *conf_file);

struct conf_cluster *conf_cluster_get(void);
struct conf_trig *conf_trig_get(void);
struct conf_qrs *conf_qrs_get(void);
struct conf_t_wave *conf_t_wave_get(void);
struct conf_baseline *conf_baseline_get(void);
struct conf_rhythm *conf_rhythm_get(void);


#endif /* SRC_CONF_H_ */
