/*
 * conf.c
 *
 *  Created on: Feb 19, 2016
 *      Author: hvaanane
 */

#include "conf.h"
#include "types.h"

static struct conf_cluster cluster;
static struct conf_trig trig;
static struct conf_qrs qrs;
static struct conf_t_wave t_wave;
static struct conf_baseline baseline;
static struct conf_rhythm rhythm;

//#define CINC2017
struct conf_cluster *conf_cluster_get(void){
	return(&cluster);
}

struct conf_trig *conf_trig_get(void){
	return(&trig);
}

struct conf_qrs *conf_qrs_get(void){
	return(&qrs);
}

struct conf_t_wave *conf_t_wave_get(void){
	return(&t_wave);
}

struct conf_baseline *conf_baseline_get(void){
	return(&baseline);
}

struct conf_rhythm *conf_rhythm_get(void){
	return(&rhythm);
}

#ifndef CINC2017
#define MIN_RESAMPLED_FREQUENCY 1500.0
int conf_cluster_set_default(struct data *data) {
	struct conf_cluster *conf=&cluster;
	conf->move = 0.100;
	conf->win_before = 0.100; // 0.180, 0.050
	conf->win_after = 0.120;
	conf->ave_win_before = 0.200;
	conf->ave_win_after = 0.130;
	if(data){
		for(conf->frequency_mult = 1; conf->frequency_mult*data->sample_freq<MIN_RESAMPLED_FREQUENCY; conf->frequency_mult*=2);
	}
	else{
		conf->frequency_mult = 16;
	}
	conf->max_n_ave = 1000;
	conf->similarity_limit = 0.95; // 0.95
	conf->similarity_limit_for_averaging = 0.96; // 0.97
	conf->similarity_limit_for_clusters = 0.92;
	conf->similarity_limit_for_cluster_offsets = 0.7;
//	conf->similarity_limit_for_cluster_offsets = 2; // skip cluster offset match!
	conf->minimum_similarity_for_normals = 0.85;
	conf->allowed_amplitude_variation_mult = 1.2;
	conf->maximum_std_difference[0] = 0.60;
	conf->maximum_std_difference[1] = 35;
	return (0);
}
#else
#define MIN_RESAMPLED_FREQUENCY 1500.0
int conf_cluster_set_default(struct data *data) {
	struct conf_cluster *conf=&cluster;
	conf->move = 0.100;
	conf->win_before = 0.100; // 0.180, 0.050
	conf->win_after = 0.120;
	conf->ave_win_before = 0.200;
	conf->ave_win_after = 0.200;
	if(data){
		for(conf->frequency_mult = 1; conf->frequency_mult*data->sample_freq<MIN_RESAMPLED_FREQUENCY; conf->frequency_mult*=2);
	}
	else{
		conf->frequency_mult = 16;
	}
	conf->max_n_ave = 1000;
	conf->similarity_limit = 0.95; // 0.95
	conf->similarity_limit_for_averaging = 0.96; // 0.97
	conf->similarity_limit_for_clusters = 0.92;
	conf->similarity_limit_for_cluster_offsets = 0.7;
//	conf->similarity_limit_for_cluster_offsets = 2; // skip cluster offset match!
	conf->minimum_similarity_for_normals = 0.86;
	conf->maximum_std_difference[0] = 0.60;
	conf->maximum_std_difference[1] = 35;
	return (0);
}
#endif

#ifndef CINC2017
int conf_trig_set_default(void){
	struct conf_trig *trig_conf=&trig;
	trig_conf->reject_amplitude_drifts=1;
//	trig_conf->reject_saturated=1;
	trig_conf->reject_saturated=0; // VTT modifications
	trig_conf->reject_no_signal=1;
	trig_conf->reject_notchy_signal=1;
	trig_conf->ch_goodness_mode=1;

	trig_conf->type=TRIG_SLOPES;
//	trig_conf->type=TRIG_ABSDIFF;
	trig_conf->mode=MINMAX_DIFFERENCE;
//	trig_conf->mode=MIN_ABSMAX;
//	trig_conf->mode=MINWEIGHTED_DIFFERENCE;
	trig_conf->step_len=0.024;
	trig_conf->win_len=0.100;
	trig_conf->min_rr=0.250;
//	trig_conf->min_rr=0.200;// VTT modifications
	trig_conf->max_rr=4.000;
	trig_conf->define_ch_events=0;
	trig_conf->require_all_ch_above_threshold=0;
//	trig_conf->max_below_threshold=0.02;
	trig_conf->max_below_threshold=0.300; // we effectively ignore this
	trig_conf->threshold_high_weight=0.35;
//	trig_conf->threshold_high_weight=0.35;
//	trig_conf->threshold_high_weight=0.20;// VTT modifications
//	trig_conf->notch_rel_limit=0.30;
	trig_conf->notch_rel_limit=0.25;
//	trig_conf->notch_rel_limit=0.16;
	trig_conf->notch_abs_limit=20;
	trig_conf->data_max=0.0;
	trig_conf->data_min=0.0;
//	trig_conf->bp_filter.type=NOFILTER;
	trig_conf->bp_filter.type=FIR;
//	trig_conf->bp_filter.type=IIR;
	trig_conf->bp_filter.low=5.0;
	trig_conf->bp_filter.high=15.0;

	trig_conf->keep_artifacts=0;
	return(0);
}
#else
// TEMPORARY CINC2017 setup below!!! Remember to convert back...!!!
int conf_trig_set_default(void){
	struct conf_trig *trig_conf=&trig;
	trig_conf->reject_amplitude_drifts=1;
	trig_conf->reject_saturated=0;
//	trig_conf->reject_saturated=0; // VTT modifications
	trig_conf->reject_no_signal=1;
	trig_conf->reject_notchy_signal=1;
	trig_conf->ch_goodness_mode=1;

	trig_conf->type=TRIG_SLOPES;
//	trig_conf->type=TRIG_ABSDIFF;
	trig_conf->mode=MINMAX_DIFFERENCE;
//	trig_conf->mode=MIN_ABSMAX;
//	trig_conf->mode=MINWEIGHTED_DIFFERENCE;
	trig_conf->step_len=0.024;
	trig_conf->win_len=0.100;
	trig_conf->min_rr=0.220;
//	trig_conf->min_rr=0.200;// VTT modifications
	trig_conf->max_rr=3.500;
	trig_conf->define_ch_events=0;
	trig_conf->require_all_ch_above_threshold=0;
//	trig_conf->max_below_threshold=0.02;
	trig_conf->max_below_threshold=0.300; // we effectively ignore this
	trig_conf->threshold_high_weight=0.30;
//	trig_conf->threshold_high_weight=0.35;
//	trig_conf->threshold_high_weight=0.20;// VTT modifications
//	trig_conf->notch_rel_limit=0.30;
	trig_conf->notch_rel_limit=0.21;
//	trig_conf->notch_rel_limit=0.16;
	trig_conf->notch_abs_limit=20;
	trig_conf->data_max=0.0;
	trig_conf->data_min=0.0;
//	trig_conf->bp_filter.type=NOFILTER;
	trig_conf->bp_filter.type=FIR;
//	trig_conf->bp_filter.type=IIR;
	trig_conf->bp_filter.low=5.0;
	trig_conf->bp_filter.high=15.0;

	trig_conf->keep_artifacts=0;
	return(0);
}
#endif

int conf_qrs_set_default(void){
	qrs.low_pass = 35.0; 			// low pass cutoff frequency
	qrs.energy_win_len = 0.030; 	// length of the max deviation window (s)
	qrs.onset_win_start = -0.140;	// start of the onset window relative to QRS detection (s)
	qrs.onset_win_end = -0.040; 	// end of the onset window relative to QRS detection
	qrs.offset = 0.080;				// approximative time from QRS detection to QRS offset
	qrs.abs_threshold_limit = 10.0; // absolute threshold component to stabilize the partly relative limit value
	qrs.drop_time = 0.100;
	return(0);
};

/*int conf_t_wave_set_default(void){
	t_wave.line_fit_len = 0.030;
	t_wave.parabole_fit_len = 0.050;
	t_wave.min_amplitude = 0.030;
	t_wave.min_rt_apex = 0.150;
	t_wave.tr_deadtime = 0.075;
	t_wave.tapexr_deadtime = 0.160;
//	t_wave.min_onset_slope = 0.460;
	t_wave.min_onset_slope = 0.230;
	t_wave.rt_deadtime = 0.100;
	t_wave.min_tpe = 0.150;
	t_wave.max_rt_apex = 0.450;
//	t_wave.min_offset_slope = 0.920;
	t_wave.min_offset_slope = 0.460;
	return(0);
};*/
int conf_t_wave_set_default(void){
	t_wave.line_fit_len = 0.030;
	t_wave.parabole_fit_len = 0.060;
	t_wave.min_amplitude = 0.030;
	t_wave.min_onset_slope = 0.250;
	t_wave.min_offset_slope = 0.500;
	t_wave.min_qt_apex_x0 = 0.080;
	t_wave.max_qt_apex_x0 = 0.350;
	t_wave.qtrr_apex_k = 0.10;
	t_wave.max_tpe_def = 0.150;
	t_wave.tq_deadtime = 0.140;
	t_wave.qt_deadtime = 0.140;

	return(0);
}

int conf_baseline_set_default(void){
	baseline.seek_win_len = 0.050;
	baseline.qr_estimate = 0.040;
	baseline.def_win_len = 0.036;
	baseline.min_rr = 0.330;
	baseline.min_extra_rr = 0.450;
	return(0);
}

int conf_rhythm_set_default(void){
	rhythm.tachy_limit=100.0;
	rhythm.extreme_tachy_limit=140.0;
	rhythm.set_supraventriculars_during_af=1;
	return(0);
}

int conf_initialize(struct data *data, char *filename){
	conf_cluster_set_default(data);
	conf_trig_set_default();
	conf_qrs_set_default();
	conf_t_wave_set_default();
	conf_baseline_set_default();
	conf_rhythm_set_default();
	if(filename){
		conf_set(filename);
	}
	return(0);
}

#define TRIG_CONF_LINE_MAX 1024
int conf_set(char const *conf_file){

	return(0);
}
