/*
 * cinc2017.c
 *
 *  Created on: Apr 7, 2017
 *      Author: hvaanane
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define CINC2017_CLASS_OUTPUT
//#define CINC2017_MARKER_OUTPUT
//#define CINC2017_TEST_OUTPUT
//#define CINC2017_INCLUDE_FILENAME_TO_OUTPUT
//#define CINC2017_RESULTS_TO_FILE
//#define CINC2017_RUN_ALL_TESTDATA
//#define CINC2017_JSON_OUTPUT
//#define CINC2017_DEV_OUTPUT

#include "types.h"
#include "test_types.h"
#include "rhythm.h"
#include "tests.h"
#include "array.h"
#include "mit.h"
#include "conf.h"
#include "trig.h"
#include "util.h"
#include "data.h"
#include "memory_manager.h"


extern double rhythm_good_entropy(unsigned int *words, int win_len, double normalization_len);
extern unsigned int *rhythm_define_good_words(double *rr, struct test_events *events, double freq, int step_size, int word_len,int n_symbols);
extern unsigned int *rhythm_define_words(struct test_events *events, double freq, int step_size, int word_len,int n_symbols);
extern double rhythm_entropy(unsigned int *words, int win_len, double normalization_len);


/*************p corr***************/
static inline void moving_std_(double *data, double *std, double *ave, int len, int nsamp){
	int i,j;
	int half_len1,half_len2;
	if(len>nsamp){
		len=nsamp;
	}
	half_len1=len/2;
	half_len2=len-half_len1;
	for(i=0;i<half_len1;i++){
		ave[i]=std[i]=0.0;
		for(j=0;j<i+half_len2;j++){
			ave[i]+=data[j];
			std[i]+=data[j]*data[j];
		}
	}
	for(;i<nsamp-half_len2;i++){
		ave[i]=ave[i-1]+data[i+half_len2]-data[i-half_len1];
		std[i]+=std[i-1]+data[i+half_len2]*data[i+half_len2]-data[i-half_len1]*data[i-half_len1];
	}
	for(;i<nsamp;i++){
		ave[i]=ave[i-1]-data[i-half_len1];
		std[i]=std[i-1]-data[i-half_len1]*data[i-half_len1];
	}

	for(i=0;i<half_len1;i++){
		ave[i]/=(double)(i+half_len2-1);
		std[i]=sqrt(std[i]/(double)(i+half_len2-1)-ave[i]*ave[i]);
	}
	for(;i<nsamp-half_len2;i++){
		ave[i]/=(double)(len);
		std[i]=sqrt(std[i]/(double)(len)-ave[i]*ave[i]);
	}
	for(;i<nsamp;i++){
		ave[i]/=(double)(nsamp-i+half_len1);
		std[i]=sqrt(std[i]/(double)(nsamp-i+half_len1)-ave[i]*ave[i]);
	}
}

static inline void moving_std(double *data, double *std, double *ave, int len, int nsamp){
	int i,j;
	if(len>nsamp){
		len=nsamp;
	}
	i=0;
	ave[i]=std[i]=0.0;
	for(j=0;j<len;j++){
		ave[i]+=data[j];
		std[i]+=data[j]*data[j];
	}
	for(i++;i<nsamp-len;i++,j++){
		ave[i]=ave[i-1]+data[j]-data[j-len];
		std[i]+=std[i-1]+data[j]*data[j]-data[j-len]*data[j-len];
	}
	for(i=0;i<nsamp-len;i++){
		ave[i]/=(double)(len);
		std[i]=sqrt(std[i]/(double)(len)-ave[i]*ave[i]);
	}
}

static inline void define_std(double *data, double *std, double *ave, int len){
	int i;
	*ave=0.0;
	for(i=0;i<len;i++){
		*ave+=data[i];
	}
	*ave/=(double)(len);
	*std=0.0;
	for(i=0;i<len;i++){
		*std+=(data[i]-*ave)*(data[i]-*ave);
	}
	*std=sqrt(*std/(double)(len));
}



static inline double moving_max_corr(double *data1, double *ave1, double *std1, double *data2, double *ave2, double *std2, int half_len1, int half_len2, int nsamp, double max_std_diff_mult, int *max_i){
	int i,j;
	double corr,max_corr = 0.0; // ignore negative correlations -- we just aren't interested on those..
	for(i=0;i<nsamp;i++){
		if(std1[i]==0.0 || std2[i]==0.0){
			continue;
		}
		corr=0.0;
		for(j=i-half_len1+1;j<=i+half_len2;j++){
			corr+=(data1[j]-ave1[i])*(data2[j]-ave2[i]);
		}

		if(std1[i]>std2[i]){
			if(std2[i]*max_std_diff_mult<std1[i]){
				corr/=std1[i];
			}
			else{
				corr/=sqrt(std1[i]*std2[i]);
			}
		}
		else{
			if(std1[i]*max_std_diff_mult<std2[i]){
				corr/=std2[i];
			}
			else{
				corr/=sqrt(std1[i]*std2[i]);
			}
		}
		if(corr>max_corr){
			max_corr=corr;
			*max_i=i;
		}
	}
	return(max_corr);
}

static inline void add_moving_corr_(double *data1, double *ave1, double *std1, double *data2, double *ave2, double *std2, int half_len1, int half_len2, int nsamp, double max_std_diff_mult, double *moving_corr){
	int i,j;
	double corr;
	for(i=0;i<nsamp;i++){
		corr=0.0;
		if(std1[i]==0.0 || std2[i]==0.0){
			continue;
		}
		for(j=i-half_len1;j<i+half_len2;j++){
			corr+=(data1[j]-ave1[i])*(data2[j]-ave2[i]);
		}
		if(std1[i]>std2[i]){
			if(std2[i]*max_std_diff_mult<std1[i]){
				corr/=std1[i]*std1[i];
			}
			else{
				corr/=std1[i]*std2[i];
			}
		}
		else{
			if(std1[i]*max_std_diff_mult<std2[i]){
				corr/=std2[i]*std2[i];
			}
			else{
				corr/=(std1[i]*std2[i]);
			}
		}
		moving_corr[i]+=corr;
	}
}

static inline void  add_moving_resampled_corr(double *data1, double *data2, int index_mult , int half_len1, int half_len2, int nsamp, double max_std_diff_mult, double *moving_corr){
	int i,j;
	double corr;
	/*	double a1,a2,s1,s2;
		for(i=0;i<nsamp;i++){
			corr=0.0;
			a1=a2=s1=s2=0.0;

			for(j=i-half_len1;j<i+half_len2;j++){
				a1+=data1[j];
				a2+=data2[j];
			}
			a1/=(half_len1+half_len2);
			a2/=(half_len1+half_len2);
			for(j=i-half_len1;j<i+half_len2;j++){
				corr+=(data1[j]-a1)*(data2[j]-a2);
				s1+=(data1[j]-a1)*(data1[j]-a1);
				s2+=(data2[j]-a2)*(data2[j]-a2);
			}
			if(s1==0.0 || s2==0.0){
				continue;
			}
			if(s1>s2){
				if(s2*max_std_diff_mult<s1){
					corr/=s1;
				}
				else{
					corr/=sqrt(s1*s2);
				}
			}
			else{
				if(s1*max_std_diff_mult<s2){
					corr/=s2;
				}
				else{
					corr/=sqrt(s1*s2);
				}
			}
			moving_corr[i]+=corr;
		}*/
	double a1,a2,a11,a12,a21, a22,s1,s2;
	int slope_ave_len=3;
	double slope1,slope2,step=1.0/(half_len1+half_len2-slope_ave_len);

	for(i=0;i<nsamp;i++){
		corr=0.0;
		a11=a12=a21=a22=s1=s2=0.0;

		for(j=0;j<slope_ave_len;j++){
			a11+=data1[i-half_len1+j];
			a12+=data1[i+half_len2-j];
			a21+=data2[index_mult*(i-half_len1+j)];
			a22+=data2[index_mult*(i+half_len2-j)];
		}
		a11/=slope_ave_len;
		a12/=slope_ave_len;
		a21/=slope_ave_len;
		a22/=slope_ave_len;
		slope1=(a12-a11)*step;
		slope2=(a22-a21)*step;

		for(j=i-half_len1;j<i+half_len2;j++){
			a1=a11+slope1*(j-(i-half_len1+slope_ave_len/2));
			a2=a21+slope2*(j-(i-half_len1+slope_ave_len/2));
			corr+=(data1[j]-a1)*(data2[index_mult*j]-a2);
			s1+=(data1[j]-a1)*(data1[j]-a1);
			s2+=(data2[index_mult*j]-a2)*(data2[index_mult*j]-a2);
		}
		if(s1==0.0 || s2==0.0){
			continue;
		}
		if(s1>s2){
			if(s2*max_std_diff_mult<s1){
				corr/=s1;
			}
			else{
				corr/=sqrt(s1*s2);
			}
		}
		else{
			if(s1*max_std_diff_mult<s2){
				corr/=s2;
			}
			else{
				corr/=sqrt(s1*s2);
			}
		}
		moving_corr[i]+=corr;
	}

}

static inline void  add_sliding_resampled_corr(double *data1, double *data2, int index_mult , int half_len1, int half_len2, int nsamp, double max_std_diff_mult, double *moving_corr){
	int i,j;
	double corr;
	double a1,a2,s1,s2;
	for(i=0;i<nsamp;i++){
		corr=0.0;
		a1=a2=s1=s2=0.0;

		for(j=i-half_len1;j<i+half_len2;j++){
			a1+=data1[j];
			a2+=data2[index_mult*(j-i)];
		}
		a1/=(half_len1+half_len2);
		a2/=(half_len1+half_len2);
		for(j=i-half_len1;j<i+half_len2;j++){
			corr+=(data1[j]-a1)*(data2[index_mult*(j-i)]-a2);
			s1+=(data1[j]-a1)*(data1[j]-a1);
			s2+=(data2[index_mult*(j-i)]-a2)*(data2[index_mult*(j-i)]-a2);
		}
		if(s1==0.0 || s2==0.0){
			continue;
		}
		if(s1>s2){
			if(s2*max_std_diff_mult<s1){
				corr/=s1;
			}
			else{
				corr/=sqrt(s1*s2);
			}
		}
		else{
			if(s1*max_std_diff_mult<s2){
				corr/=s2;
			}
			else{
				corr/=sqrt(s1*s2);
			}
		}
		moving_corr[i]+=corr*1000.0;
	}/*
			double a1,a2,a11,a12,a21, a22,s1,s2;
			int slope_ave_len=3;
			double slope1,slope2,step=1.0/(half_len1+half_len2-slope_ave_len);

			a21=a22=s2=0.0;

			for(j=0;j<slope_ave_len;j++){
				a21+=data2[index_mult*(-half_len1+j)];
				a22+=data2[index_mult*(half_len2-j)];
			}
			a21/=slope_ave_len;
			a22/=slope_ave_len;
			slope2=(a22-a21)*step;
			for(j=-half_len1;j<half_len2;j++){
				a2=a21+slope2*(j-(-half_len1+slope_ave_len/2));
				s2+=(data2[index_mult*j]-a2)*(data2[index_mult*j]-a2);
			}

			for(i=0;i<nsamp;i++){
				corr=0.0;
				a11=a12=s1=0.0;

				for(j=0;j<slope_ave_len;j++){
					a11+=data1[i-half_len1+j];
					a12+=data1[i+half_len2-j];
				}
				a11/=slope_ave_len;
				a12/=slope_ave_len;
				slope1=(a12-a11)*step;

				for(j=i-half_len1;j<i+half_len2;j++){
					a1=a11+slope1*(j-(i-half_len1+slope_ave_len/2));
					a2=a21+slope2*(j-(i-half_len1+slope_ave_len/2));
					corr+=(data1[j]-a1)*(data2[index_mult*(j-i)]-a2);
					s1+=(data1[j]-a1)*(data1[j]-a1);
				}
				if(s1==0.0 || s2==0.0){
					continue;
				}
				if(s1>s2){
					if(s2*max_std_diff_mult<s1){
						corr/=s1;
					}
					else{
						corr/=sqrt(s1*s2);
					}
				}
				else{
					if(s1*max_std_diff_mult<s2){
						corr/=s2;
					}
					else{
						corr/=sqrt(s1*s2);
					}
				}
				moving_corr[i]+=corr*1000.0;
			}*/

}

static inline void add_moving_corr(double *data1, double *ave1_, double *std1_, double *data2, double *ave2_, double *std2_, int half_len1, int half_len2, int nsamp, double max_std_diff_mult, double *moving_corr){
	int i,j;
	double corr;
	/*	double a1,a2,s1,s2;
		for(i=0;i<nsamp;i++){
			corr=0.0;
			a1=a2=s1=s2=0.0;

			for(j=i-half_len1;j<i+half_len2;j++){
				a1+=data1[j];
				a2+=data2[j];
			}
			a1/=(half_len1+half_len2);
			a2/=(half_len1+half_len2);
			for(j=i-half_len1;j<i+half_len2;j++){
				corr+=(data1[j]-a1)*(data2[j]-a2);
				s1+=(data1[j]-a1)*(data1[j]-a1);
				s2+=(data2[j]-a2)*(data2[j]-a2);
			}
			if(s1==0.0 || s2==0.0){
				continue;
			}
			if(s1>s2){
				if(s2*max_std_diff_mult<s1){
					corr/=s1;
				}
				else{
					corr/=sqrt(s1*s2);
				}
			}
			else{
				if(s1*max_std_diff_mult<s2){
					corr/=s2;
				}
				else{
					corr/=sqrt(s1*s2);
				}
			}
			moving_corr[i]+=corr;
		}*/
	double a1,a2,a11,a12,a21, a22,s1,s2;
	int slope_ave_len=3;
	double slope1,slope2,step=1.0/(half_len1+half_len2-slope_ave_len);

	for(i=0;i<nsamp;i++){
		corr=0.0;
		a11=a12=a21=a22=s1=s2=0.0;

		for(j=0;j<slope_ave_len;j++){
			a11+=data1[i-half_len1+j];
			a12+=data1[i+half_len2-j];
			a21+=data2[i-half_len1+j];
			a22+=data2[i+half_len2-j];
		}
		a11/=slope_ave_len;
		a12/=slope_ave_len;
		a21/=slope_ave_len;
		a22/=slope_ave_len;
		slope1=(a12-a11)*step;
		slope2=(a22-a21)*step;

		for(j=i-half_len1;j<i+half_len2;j++){
			a1=a11+slope1*(j-(i-half_len1+slope_ave_len/2));
			a2=a21+slope2*(j-(i-half_len1+slope_ave_len/2));
			corr+=(data1[j]-a1)*(data2[j]-a2);
			s1+=(data1[j]-a1)*(data1[j]-a1);
			s2+=(data2[j]-a2)*(data2[j]-a2);
		}
		if(s1==0.0 || s2==0.0){
			continue;
		}
		if(s1>s2){
			if(s2*max_std_diff_mult<s1){
				corr/=s1;
			}
			else{
				corr/=sqrt(s1*s2);
			}
		}
		else{
			if(s1*max_std_diff_mult<s2){
				corr/=s2;
			}
			else{
				corr/=sqrt(s1*s2);
			}
		}
		moving_corr[i]+=corr;
	}

}

double p_wave_correlation(struct test_events *events, struct data *data_, struct test_clusters *cluster_set, double *pq){
	/* conf */
	//	double win_len = 0.100;
	//	double check_len = 0.300;
	double win_len = 0.120;
	double check_len = 0.350;
	double max_std_diff_mult = 1.30; // We accept 30 % amplitude modulation (due to breathing etc.) without any penalty
	double min_rr = 0.500;

	double freq=data_->sample_freq;
	int len = win_len * freq + 0.5;
	int nsamp = check_len * freq + 0.5;
	int i=0,j;
	int n=0,nn=0;
	int start1,start2;
	double *corr=my_calloc(nsamp,sizeof(double));
	double max_corr;
	int max_i;
	double extra_plot = 0.000;

	// 0. define data (this could / should be outside...)
	double *data = data_->ch[0].raw;
	double *ave=NULL;//=my_calloc(data_->samples_per_channel,sizeof(double));
	double *std=NULL;//=my_calloc(data_->samples_per_channel,sizeof(double));
	double qrs_onset;
	if(cluster_set->n_clusters>0){
		qrs_onset=cluster_set->clusters[0].markers[0].qrs_onset*freq-(double)(cluster_set->template_offset)/cluster_set->frequency_mult;
	}
	else{
		qrs_onset = -0.04*freq;
	}
	min_rr*=freq;
	qrs_onset+=extra_plot*freq; // tmp mod to continue the corr check over the qrs. TODO: remove!
	//		moving_std(data, std, ave, len, data_->samples_per_channel);

	// 1. define the correlations

	if(events->events[i].sample-events->events[i].sub_sample < len/2 + nsamp + qrs_onset){
		i++;
	}
	for(;i<events->n_events;i++){
		if((events->events[i].type==TEST_NORMAL_BEAT || events->events[i].type==TEST_SUPRAVENTRICULAR) &&
				i>0 ? (events->events[i].sample-events->events[i-1].sample)>min_rr : (i+1<events->n_events ? (events->events[i+1].sample-events->events[i].sample)> min_rr : 1)){
			for(j=i+1;j<events->n_events;j++){
				if(events->events[j].type==TEST_NORMAL_BEAT && (events->events[j].sample-events->events[j-1].sample)>min_rr){
					start1=(double)(events->events[i].sample)-events->events[i].sub_sample-nsamp+qrs_onset+0.5;
					start2=(double)(events->events[j].sample)-events->events[j].sub_sample-nsamp+qrs_onset+0.5;
					if(start1<len/2){
						continue;
					}
					add_moving_corr(data+start1, ave+start1, std+start1, data+start2, ave+start2, std+start2, len/2, len-len/2, nsamp, max_std_diff_mult, corr);
					n++;
					nn++;
				}
			}
		}
	}
	if(n<2){
		*pq=0.0;
		return(0.0);
	}
/*	if(n<10){ // if there was less than 5 beats labeled as TEST_NORMAL_BEAT,or TEST_SUPRAVENTIRCULAR we include the ones labeled as TEST_BEAT_UNDEFINED too..
		i=0;
		if(events->events[i].sample-events->events[i].sub_sample < len/2 + nsamp + qrs_onset){
			i++;
		}
		for(;i<events->n_events && n<0.5*events->n_events;i++){
			if(events->events[i].type==TEST_NORMAL_BEAT || events->events[i].type==TEST_SUPRAVENTRICULAR || events->events[i].type==TEST_BEAT_UNDEFINED){
				for(j=i+1;j<events->n_events;j++){
					if(events->events[j].type==TEST_BEAT_UNDEFINED){
						start1=(double)(events->events[i].sample)-events->events[i].sub_sample-nsamp+qrs_onset+0.5;
						start2=(double)(events->events[j].sample)-events->events[j].sub_sample-nsamp+qrs_onset+0.5;
						add_moving_corr(data+start1, ave+start1, std+start1, data+start2, ave+start2, std+start2, len/2, len-len/2, nsamp, max_std_diff_mult, corr);
						n++;
					}
				}
			}
		}
	}*/

	// 2. find the max correlation
	max_corr=corr[0];
	max_i=0;
	for(i=1;i<nsamp-len/2-extra_plot*freq;i++){
		if(corr[i]>max_corr){
			max_corr=corr[i];
			max_i=i;
		}
	}
	max_corr/=(n);
	*pq=(double)(nsamp-max_i+len/2)/freq-extra_plot;

	// save. Tmp. TODO: remove!
	if(0){
		FILE *fp=fopen("p_corr.txt","a");
		fprintf(fp,"%lf\t%lf\t%lf\t%lf\t%d\t%d\t-",max_corr,*pq, qrs_onset, freq,n,nn);
		if(n>0){
			for(i=0;i<nsamp;i++){
				fprintf(fp,"\t%lf",corr[i]/(n));
			}
		}
		else{
			fprintf(fp,"\t%lf",0.0);
		}
		fprintf(fp,"\n");
		fclose(fp);
	}
	my_free(corr);
	return(max_corr);
}

double p_wave_ave_correlation(struct test_events *events, struct data *data_, struct test_clusters *cluster_set, double *pq){
	/* conf */
	//	double win_len = 0.100;
	//	double check_len = 0.300;
	double win_len = 0.120;
	double check_len = 0.500;
	double max_std_diff_mult = 1.30; // We accept 30 % amplitude modulation (due to breathing etc.) without any penalty
	double min_rr = 0.450;

	double freq=data_->sample_freq;
	int len = win_len * freq + 0.5;
	int nsamp = check_len * freq + 0.5;
	int i=0;
	int n=0,nn=0;
	int start1,start_template;
	double *corr=my_calloc(nsamp,sizeof(double));
	double max_corr;
	int max_i;
	double extra_plot = 0.100;

	// 0. define data (this could / should be outside...)
	double *data = data_->ch[0].raw;
	double qrs_onset;
	if(cluster_set->n_clusters>0){
		qrs_onset=cluster_set->clusters[0].markers[0].qrs_onset*freq-(double)(cluster_set->template_offset)/cluster_set->frequency_mult;
	}
	else{
		goto p_wave_ave_correlation_out;
	}
	qrs_onset+=extra_plot*freq; // tmp mod to continue the corr check over the qrs. TODO: remove!
	min_rr *= freq;

	// 1. define the correlations

	if(events->events[i].sample-events->events[i].sub_sample < len/2 + nsamp + qrs_onset){
		i++;
	}
	for(;i<events->n_events;i++){
		if((events->events[i].type==TEST_NORMAL_BEAT || events->events[i].type==TEST_SUPRAVENTRICULAR) &&
				i>0 ? (events->events[i].sample-events->events[i-1].sample)>min_rr : (i+1<events->n_events ? (events->events[i+1].sample-events->events[i].sample)> min_rr : 1)){
			start1=(double)(events->events[i].sample)-events->events[i].sub_sample-nsamp+qrs_onset+0.5;
			start_template=((double)(start1)-((double)(events->events[i].sample)-events->events[i].sub_sample))*cluster_set->frequency_mult+cluster_set->template_offset+0.5;
			add_moving_resampled_corr(data+start1, cluster_set->clusters[0].templates[0][0]+start_template, cluster_set->frequency_mult, len/2, len-len/2, nsamp, max_std_diff_mult, corr);
			n++;
			nn++;
		}
	}

	// 2. find the max correlation
	max_corr=corr[0];
	max_i=0;
	for(i=1;i<nsamp-len/2-extra_plot*freq;i++){
		if(corr[i]>max_corr){
			max_corr=corr[i];
			max_i=i;
		}
	}
	max_corr/=(n);
	*pq=(double)(nsamp-max_i+len/2)/freq-extra_plot;

	// save. Tmp. TODO: remove!
	p_wave_ave_correlation_out:
	{
		FILE *fp=fopen("p_corr.txt","a");
		fprintf(fp,"%lf\t%lf\t%lf\t%lf\t%d\t%d\t-",max_corr,*pq, qrs_onset, freq,n,nn);
		if(n>0){
			for(i=0;i<nsamp;i++){
				fprintf(fp,"\t%lf",corr[i]/(n));
			}
		}
		else{
			for(i=0;i<nsamp;i++){
				fprintf(fp,"\t%lf",0.0);
			}
		}
		fprintf(fp,"\n");
		fclose(fp);
	}
	my_free(corr);
	return(max_corr);
}



/********************/



static int tests_double_comparison(const void *event1,const void *event2){
	if(*((double *)(event1)) < *((double *)(event2))){
		return(-1);
	}
	else if(*((double *)(event1)) > *((double *)(event2))){
		return(1);
	}
	return(0);
}

double tests_class_entropy_val(struct test_events *events, double freq, double win_duration){
/* configuration parameters: */
	int step_size=6; // increasing this parameter upto 10 increases the meter robustness against small RR changes. The value use in was 5. Zhou X, Ding H, Wu W, Zhang Y. A Real-Time Atrial Fibrillation Detection Algorithm Based on the Instantaneous State of Heart Rate. PLoS One. 2015 Sep 16;10(9):e0136544
	int word_len=3;
	int n_symbols=64;
	double min_bpm_for_scaling = 45.0;

	size_t i;
	double min_win_len = (size_t)(win_duration * min_bpm_for_scaling / 60.0 +0.5);
	double win_dur=win_duration*freq;
	long int win_len;
	size_t end_i;
	unsigned int *words;
	double result = -1.0;

	if(events->n_events<word_len+3){ // not enough events to do anything..
		// printf("AARGH!\n");
		return(0.0);
	}
	words = rhythm_define_words(events, freq, step_size, word_len, n_symbols);
	if(events->events[events->n_events-word_len-1].sample-events->events[0].sample<=win_dur){ // just one entropy estimate
		win_len=events->n_events-word_len;
		result=rhythm_entropy(words, win_len, win_len<min_win_len ? min_win_len : win_len);
	}
	else{ // take the median of the 15 s estimates
		double *entropy = my_malloc(events->n_events*sizeof(double));

		for(end_i=0,i=0;i<events->n_events;i++){
			for(;end_i<events->n_events-word_len && events->events[end_i+1].sample-events->events[i].sample<win_dur;end_i++);
			if(end_i>=events->n_events-word_len){
				break;
			}
			win_len=end_i-i;

			if(win_len>1){
				entropy[i]=rhythm_entropy(words+i, win_len, min_win_len);
			}else{
				if(i>0){
					entropy[i]=entropy[i-1];
				}else{
					entropy[i]=0.0;
				}
			}
		}
		qsort(entropy, i, sizeof(double),tests_double_comparison);
		result=entropy[i/2];
		my_free(entropy);
	}
	my_free(words);
	return(result);
}

double tests_class_good_entropy_val(double *rr, struct test_events *events, double freq, double win_duration){
/* configuration parameters: */
	int step_size=6; // increasing this parameter upto 10 increases the meter robustness against small RR changes. The value use in was 5. Zhou X, Ding H, Wu W, Zhang Y. A Real-Time Atrial Fibrillation Detection Algorithm Based on the Instantaneous State of Heart Rate. PLoS One. 2015 Sep 16;10(9):e0136544
	int word_len=3;
	int n_symbols=64;
	double min_bpm_for_scaling = 45.0;

	size_t i;
	double min_win_len = (size_t)(win_duration * min_bpm_for_scaling / 60.0 +0.5);
	double win_dur=win_duration*freq;
	long int win_len;
	size_t end_i;
	unsigned int *words;
	double result = -1.0;

	if(events->n_events<word_len+3){ // not enough events to do anything..
		// printf("AARGH!\n");
		return(0.0);
	}
	words = rhythm_define_good_words(rr, events, freq, step_size, word_len, n_symbols);
	if(events->events[events->n_events-word_len-1].sample-events->events[0].sample<=win_dur){ // just one entropy estimate
		win_len=events->n_events-word_len;
		result=rhythm_good_entropy(words, win_len, (size_t)((events->events[events->n_events-1].sample-events->events[0].sample)/freq * min_bpm_for_scaling / 60.0 +0.5));
	}
	else{ // take the median of the win_duration long estimates
		double *entropy = my_malloc(events->n_events*sizeof(double));

		for(end_i=0,i=0;i<events->n_events;i++){
			for(;end_i<events->n_events-word_len && events->events[end_i+1].sample-events->events[i].sample<win_dur;end_i++);
			if(end_i>=events->n_events-word_len){
				break;
			}
			win_len=end_i-i;

			if(win_len>1){
				entropy[i]=rhythm_good_entropy(words+i, win_len, min_win_len);
			}else{
				if(i>0){
					entropy[i]=entropy[i-1];
				}else{
					entropy[i]=0.0;
				}
			}
		}
		qsort(entropy, i, sizeof(double),tests_double_comparison);
		result=entropy[i/2];
		my_free(entropy);
	}
	my_free(words);
	return(result);
}

double tests_class_badness_ratio(struct data *data, struct test_events *events, struct test_ch_info *ch_info){
	size_t i;
	size_t bad_dur=0;
	for(i=0;i<events->n_ranges;i++){
		if(events->ranges[i].type==TEST_UNREADABLE){
			bad_dur+=events->ranges[i].end-events->ranges[i].start;
		}
	}
	return((double)(bad_dur)/(double)(data->samples_per_channel));
}

double tests_class_af_ratio(struct data *data, struct test_events *events, struct test_ch_info *ch_info){
	size_t i;
	size_t bad_dur=0;
	size_t af_dur=0;
	for(i=0;i<events->n_ranges;i++){
		if(events->ranges[i].type==TEST_UNREADABLE){
			bad_dur+=events->ranges[i].end-events->ranges[i].start;
		}
		else if(events->ranges[i].type==TEST_AF){
			af_dur+=events->ranges[i].end-events->ranges[i].start;
		}
	}
	if(data->samples_per_channel<bad_dur+data->sample_freq){ // just bad?
		return(0.0);
	}
	return((double)(af_dur)/(double)(data->samples_per_channel-bad_dur));
}

double tests_class_abnormal_rhythm_ratio(struct data *data, struct test_events *events, struct test_ch_info *ch_info){
	size_t i;
	size_t bad_dur=0;
	size_t ab_dur=0;
	for(i=0;i<events->n_ranges;i++){
		if(events->ranges[i].type==TEST_UNREADABLE){
			bad_dur+=events->ranges[i].end-events->ranges[i].start;
		}
		else if(events->ranges[i].type==TEST_ABNORMAL_RHYTHM){
			ab_dur+=events->ranges[i].end-events->ranges[i].start;
		}
	}
	if(data->samples_per_channel<bad_dur+data->sample_freq){ // just bad?
		return(0.0);
	}
	return((double)(ab_dur)/(double)(data->samples_per_channel-bad_dur));
}

double tests_class_other_rhythm_ratio(struct data *data, struct test_events *events, struct test_ch_info *ch_info){
	size_t i;
	size_t bad_dur=0;
	size_t other_dur=0;
	for(i=0;i<events->n_ranges;i++){
		if(events->ranges[i].type==TEST_UNREADABLE){
			bad_dur+=events->ranges[i].end-events->ranges[i].start;
		}
		else if(events->ranges[i].type!=TEST_AF && events->ranges[i].type!=TEST_ABNORMAL_RHYTHM){
			other_dur+=events->ranges[i].end-events->ranges[i].start;
		}
	}
	if(data->samples_per_channel<bad_dur+data->sample_freq){ // just bad?
		return(0.0);
	}

	return((double)(other_dur)/(double)(data->samples_per_channel-bad_dur));
}

double tests_class_V_ratio(struct data *data, struct test_events *events, struct test_ch_info *ch_info){
	size_t i;
	size_t n_V=0;
	size_t n_N=0;
	size_t n_U=0;
	if(events->n_events==0){
		return(0.0);
	}
	for(i=1;i<events->n_events-1;i++){  // we skip the first and last beat due to some potential classification challenges (TO BE CORRECTED) in there..
		if(events->events[i].type==TEST_NORMAL_BEAT){
			n_N++;
		}
		else if(events->events[i].type==TEST_BEAT_UNDEFINED){
			n_U++;
		}
		else if(events->events[i].type==TEST_VENTRICULAR || events->events[i].type==TEST_FUSION){
			n_V++;
		}

	}
	if(n_V){
		return((double)(n_V)/(double)(n_N+n_V));
	}
	return(0.0);
}

double tests_class_U_ratio(struct data *data, struct test_events *events, struct test_ch_info *ch_info){
	size_t i;
	size_t n_V=0;
	size_t n_N=0;
	size_t n_U=0;
	if(events->n_events==0){
			return(0.0);
		}
	for(i=1;i<events->n_events-1;i++){  // we skip the first and last beat due to some potential classification challenges (TO BE CORRECTED) in there..
		if(events->events[i].type==TEST_NORMAL_BEAT){
			n_N++;
		}
		else if(events->events[i].type==TEST_BEAT_UNDEFINED){
			n_U++;
		}
		else if(events->events[i].type==TEST_VENTRICULAR || events->events[i].type==TEST_FUSION){
			n_V++;
		}

	}
	if(n_U){
		return((double)(n_U)/(double)(n_N+n_U));
	}
	return(0.0);
}

double tests_class_ave_ch_goodness(struct data *data, struct test_events *events, struct test_ch_info *ch_info){
	double ave=0.0;
	int ch;
	for(ch=0;ch<ch_info->nch;ch++){
		ave+=ch_info->ch_goodness[ch];
	}
	return(ave/ch_info->nch);
}

double tests_class_ave_bpm(double *rr, size_t n_rr){
	double sum_rr;
	size_t i,n;
	for(i=n=0;i<n_rr;i++){
		if(rr[i]>0.0){
			sum_rr+=rr[i];
			n++;
		}
	}
	if(n){
		return((double)(n)/(sum_rr/60.0));
	}
	return(0.0);
}


double tests_class_rrrms_d(double *rr, size_t n_rr){
	double drr=0.0;
	size_t i,j,n;
	if(!n_rr){
		return(-1.0);
	}
	for(n=i=0;i<n_rr-1;i++){
		if(rr[i]>0){
			for(j=i++;i<n_rr && rr[i]==0;i++);
			if(i<n_rr && rr[i]>0){
				drr+=fabs(rr[i]-rr[j]);
				n++;
			}
		}
	}
	if(n){
		return(sqrt(drr/n));
	}
	return(-1.0);
}

double tests_class_rrrms(double *rr, size_t n_rr){
	double drr=0.0;
	size_t i,j,n;
	if(!n_rr){
		return(-1.0);
	}
	for(n=i=0;i<n_rr-1;i++){
		if(rr[i]>0){
			for(j=i++;i<n_rr && rr[i]==0;i++);
			if(i<n_rr && rr[i]>0){
				drr+=(rr[i]-rr[j])*(rr[i]-rr[j]);
				n++;
			}
		}
	}
	if(n){
		return(sqrt(drr/n));
	}
	return(-1.0);
}

double tests_class_qrs_width(struct test_clusters *cluster_set){
	size_t i;
	size_t n=0;
	double qrs_width=0.0;
	for(i=0;i<cluster_set->n_clusters;i++){
		//if(cluster_set->clusters[i].type==TEST_NORMAL_BEAT || cluster_set->clusters[i].type==TEST_SUPRAVENTRICULAR || cluster_set->clusters[i].type==TEST_BEAT_UNDEFINED){
		if(cluster_set->clusters[i].type!=TEST_ARTIFACT){
			qrs_width+=cluster_set->clusters[i].markers[0].qrs_width*cluster_set->clusters[i].n_beats;
			n+=cluster_set->clusters[i].n_beats;
		}
	}
	if(n){
		return(qrs_width/n);
	}
	return(0.0);
}

double tests_class_normal_qrs_width(struct test_clusters *cluster_set){
	size_t i;
	size_t n=0;
	double qrs_width=0.0;
	for(i=0;i<cluster_set->n_clusters;i++){
		if(cluster_set->clusters[i].type==TEST_NORMAL_BEAT){
			qrs_width+=cluster_set->clusters[i].markers[0].qrs_width*cluster_set->clusters[i].n_beats;
			n+=cluster_set->clusters[i].n_beats;
		}
	}
	if(n){
		return(qrs_width/n);
	}
	return(0.0);
}



int tests_class_cluster_widths(struct test_clusters *cluster_set, int n_steps, int nth_cluster, double *widths, double *raise_times){
	int i,j,n,k,max_i;
	double base1,base2,max;
	double limit;
	double dt,freq=cluster_set->frequency_mult*cluster_set->original_freq;
	for(i=0,n=0;i<cluster_set->n_clusters;i++){
		if(cluster_set->clusters[i].type!=TEST_ARTIFACT){
			if(n==nth_cluster)
				break;
			n++;
		}
	}
	if(n<nth_cluster){
		for(i=0;i<n_steps;i++){
			widths[i]=-1.0;
		}
		return(-1);
	}

	i=cluster_set->clusters[n].markers[0].qrs_onset*freq+0.5;
	max=fabs(cluster_set->clusters[n].templates[0][0][i]);
	for(i++;i<cluster_set->clusters[n].markers[0].qrs_offset*freq+0.5;i++){
		if(max<fabs(cluster_set->clusters[n].templates[0][0][i])){
			max=fabs(cluster_set->clusters[n].templates[0][0][i]);
			max_i=i;
		}
	}

	i=cluster_set->clusters[n].markers[0].qrs_onset*freq+0.5;
	if(cluster_set->clusters[n].templates[0][0][i]>0){
		for(;i>0 && cluster_set->clusters[n].templates[0][0][i]>cluster_set->clusters[n].templates[0][0][i-1];i--);
	}
	else{
		for(;i>0 && cluster_set->clusters[n].templates[0][0][i]<cluster_set->clusters[n].templates[0][0][i-1];i--);
	}
	base1=cluster_set->clusters[n].templates[0][0][i];

	j=cluster_set->clusters[n].markers[0].qrs_offset*freq+0.5;
	if(cluster_set->clusters[n].templates[0][0][j]>0){
		for(;j<cluster_set->template_len && cluster_set->clusters[n].templates[0][0][j]>cluster_set->clusters[n].templates[0][0][j+1];j++);
	}
	else{
		for(;j<cluster_set->template_len && cluster_set->clusters[n].templates[0][0][j]<cluster_set->clusters[n].templates[0][0][j+1];j++);
	}
	base2=cluster_set->clusters[n].templates[0][0][j];
	widths[0]=(double)(j-i)/freq;

	dt=1/freq;
	for(k=1;k<n_steps;k++){
		limit=fabs(max-base1)*(double)(k)/(double)(n_steps);
		raise_times[k]=0.0;
		for(;fabs(cluster_set->clusters[n].templates[0][0][i]-base1)<limit;i++,raise_times[k-1]+=dt);
		limit=fabs(max-base2)*(double)(k)/(double)(n_steps);
		for(;fabs(cluster_set->clusters[n].templates[0][0][j]-base2)<limit;j--);
		widths[k]=(double)(j-i)/freq;
	}
	raise_times[n_steps-1]=(max_i-i)*dt;
	return(0);
}

double tests_class_st(struct data *data, struct test_events *events, struct test_clusters *cluster_set){
	size_t i,win_start;
	int pq_val_len=data->sample_freq*0.030+0.5,st_val_len=data->sample_freq*0.030+0.5;
	double pq_before=data->sample_freq*0.010,st_after=data->sample_freq*0.050;
	double *st=my_malloc(cluster_set->clusters[0].n_beats*sizeof(double));
	double *tmp_data=my_malloc(MAX(pq_val_len,st_val_len)*sizeof(double));
	double st_val=0.0;
	double trig_offset=(cluster_set->template_offset - cluster_set->clusters[0].cluster_offset) / cluster_set->frequency_mult;
	if(cluster_set->n_clusters<1){
		return(0);
	}
	for(i=0;i<cluster_set->clusters[0].n_beats;i++){
		// ST level
		win_start=(size_t)((double)(events->events[cluster_set->clusters[0].inds[i]].sample)-events->events[cluster_set->clusters[0].inds[i]].sub_sample-trig_offset+cluster_set->clusters[0].markers[0].qrs_offset*data->sample_freq+st_after+0.5);
		memcpy(tmp_data,data->ch[0].raw+win_start,sizeof(double)*st_val_len);
		st[i]=array_dmedian(tmp_data,st_val_len);
		// PQ level
		win_start=(size_t)((double)(events->events[cluster_set->clusters[0].inds[i]].sample)-events->events[cluster_set->clusters[0].inds[i]].sub_sample+trig_offset+cluster_set->clusters[0].markers[0].qrs_onset*data->sample_freq-pq_before+0.5);
		memcpy(tmp_data,data->ch[0].raw+win_start,sizeof(double)*pq_val_len);
		st[i]-=array_dmedian(tmp_data,pq_val_len);

	}
	st_val=array_dmedian(st,cluster_set->clusters[0].n_beats);
	my_free(st);
	my_free(tmp_data);
	return(st_val);
}

double tests_class_normal_initial_qrs_slope(struct test_clusters *cluster_set){
	size_t i;
	size_t n=0;
	int ch;
	double slope_length=0.0;
	for(i=0;i<cluster_set->n_clusters;i++){
		if(cluster_set->clusters[i].type==TEST_NORMAL_BEAT){
			for(ch=0;ch<cluster_set->nch;ch++){
				slope_length+=cluster_set->clusters[i].markers[0].initial_qrs_slope_length[ch]*cluster_set->clusters[i].n_beats;
			}
			n+=cluster_set->clusters[i].n_beats;
		}
	}
	if(n){
		return(slope_length/(n*cluster_set->nch));
	}
	return(0.0);
}

double tests_class_initial_qrs_slope(struct test_clusters *cluster_set){
	size_t i;
	size_t n=0;
	int ch;
	double slope_length=0.0;
	for(i=0;i<cluster_set->n_clusters;i++){
		//if(cluster_set->clusters[i].type==TEST_NORMAL_BEAT || cluster_set->clusters[i].type==TEST_SUPRAVENTRICULAR || cluster_set->clusters[i].type==TEST_BEAT_UNDEFINED){
		if(cluster_set->clusters[i].type!=TEST_ARTIFACT){
			for(ch=0;ch<cluster_set->nch;ch++){
				slope_length+=cluster_set->clusters[i].markers[0].initial_qrs_slope_length[ch]*cluster_set->clusters[i].n_beats;
			}
			n+=cluster_set->clusters[i].n_beats;
		}
	}
	if(n){
		return(slope_length/(n*cluster_set->nch));
	}
	return(0.0);
}

double tests_class_beat_homogenity(struct test_clusters *cluster_set, struct test_events *events, size_t data_len, double freq){
	double homogenity=0.0;
	double n_clusters=0.0,tot_n=0.0;
	const double missing_limit = 3.5;
	size_t prev,k;
	for(k=0;k<cluster_set->n_clusters;k++){
		if(cluster_set->clusters[k].type!=TEST_ARTIFACT){
			homogenity+=cluster_set->clusters[k].n_beats*cluster_set->clusters[k].n_beats;
			tot_n+=cluster_set->clusters[k].n_beats;
			n_clusters++;
		}
	}
	for(prev=0, k=0;k<events->n_events;k++){
		if(cluster_set->clusters[k].type==TEST_ARTIFACT){
			continue;
		}
		if(events->events[k].sample-prev>missing_limit*freq){ // 'add' pseudo events to the 'empty intervals'
			tot_n+=(events->events[k].sample-prev)/(missing_limit*freq);
		}
		prev=events->events[k].sample;
	}
	if(data_len-events->events[events->n_events-1].sample>missing_limit*freq){
		tot_n+=(data_len-events->events[events->n_events-1].sample>missing_limit*freq)/(missing_limit*freq);
	}

	if(tot_n>2){
		return(sqrt(homogenity)/tot_n);
	}
	return(0.0);
}

double tests_class_moving_correlation(double *data1, double *data2, int len, int move, double *sum_corr, size_t *count){
	double ave1=0.0,ave2=0.0,ave12=0.0,ave22=0.0;
	double var1=0.0,var2=0.0;
	double sumproduct=0.0;
	size_t i=0,j;

	// first values
	for(i=0;i<len;i++){
		ave1 += data1[i];
		ave12 += POW2(data1[i]);
		ave2 += data2[i];
		ave22 += POW2(data2[i]);
	}
	ave1/=len;
	ave12/=len;
	ave2/=len;
	ave22/=len;
	for (i = 0; i < len; i++) {
		sumproduct += (data1[i] - ave1) * (data2[i]-ave2);
	}
	var1 = ave12 - POW2(ave1);
	var2 = ave22 - POW2(ave2);
	sum_corr[i]+=sumproduct/(MAX(var1,var2)*len);
	count[i]++;

	// move..
	for(i=1;i<move;i++){
		j=i-1;
		ave1 += (data1[j+len]-data1[j])/len;
		ave12 += (POW2(data1[j+len])-POW2(data1[j]))/len;
		ave2 += (data2[j+len]-data2[j])/len;
		ave22 += (POW2(data2[j+len])-POW2(data2[j]))/len;
		sumproduct += ((data1[j+len] - ave1) * (data2[j+len]-ave2)) - ((data1[j] - ave1) * (data2[j]-ave2));
		sum_corr[i]+=sumproduct/(MAX(var1,var2)*len);
		count[i]++;
	}
	return(0);
}


int tests_class_n_V(struct test_events *events){
	int i,n;
	for(i=0,n=0;i<events->n_events;i++){
		if(events->events[i].type==TEST_VENTRICULAR){
			n++;
		}
	}
	return(n);
}

int tests_class_n_S(struct test_events *events){
	int i,n;
	for(i=0,n=0;i<events->n_events;i++){
		if(events->events[i].type==TEST_SUPRAVENTRICULAR){
			n++;
		}
	}
	return(n);
}


int signal_continuity(double *rr, size_t nsamp, double freq){


	return(0);
}

extern double rhythm_sorted_rr_and_median(double *rr, size_t len);
double tests_class_med_bpm(double *rr, size_t len){
	double med_rr=rhythm_sorted_rr_and_median(rr, len);
	if(med_rr>0){
		return(60.0/med_rr);
	}
	else{
		return(60.0);
	}
}

double get_max_bpm(struct test_events *events, double freq, double win_len_s){
	int win_len=win_len_s*freq;
	int i,j,n=0,max_n=0;
	double start;
	for(j=0,i=0;i<events->n_events;i++){
		if(events->events[i].type==TEST_ARTIFACT){
			continue;
		}
		start=events->events[i].sample-events->events[i].sub_sample;
		for(;j<events->n_events && (events->events[j].sample-events->events[j].sub_sample)-start<win_len;j++){
			if(events->events[j].type!=TEST_ARTIFACT){
				n++;
			}
		}
		if(n>max_n){
			max_n=n;
		}
		n--;
	}
	return(60.0/win_len_s*(double)(max_n));
}

double get_max_c_bpm(struct test_events *events, double freq, double win_len_s){
	int win_len=win_len_s*freq;
	int i,j,n=0,max_n=0;
	double start;
	for(j=0,i=0;i<events->n_events;i++){
		if(events->events[i].type==TEST_ARTIFACT || events->events[i].type==TEST_BEAT_UNDEFINED){
			continue;
		}
		start=events->events[i].sample-events->events[i].sub_sample;
		for(;j<events->n_events && (events->events[j].sample-events->events[j].sub_sample)-start<win_len;j++){
			if(events->events[j].type!=TEST_ARTIFACT && events->events[j].type!=TEST_BEAT_UNDEFINED){
				n++;
			}
		}
		if(n>max_n){
			max_n=n;
		}
		n--;
	}
	return(60.0/win_len_s*(double)(max_n));
}

/*int test_print_rr_variability_series(char *dataname, struct test_events *events, double freq){
	char filename[FILENAME_MAX];
	FILE *fp;
	size_t i;
	double ave=0.0,ave2=0.0;
	double drr;
	sprintf(filename,"%s.rr_variability",dataname);
	fp = fopen(filename,"w");

	for(i=0;i<events->n_events;i++){
		fprintf(fp,"%c\t", tests_trigger_type_to_c(events->events[i].type));
	}
	fprintf(fp,"\n");

	if(events->n_events>1){
		for(ave=0.0,ave2=0.0,i=1;i<events->n_events;i++){
			drr=(events->events[i].sample-events->events[i-1].sample)/freq;
			fprintf(fp,"%lf\t", 1000.0*drr);
			ave+=drr;
			ave2+=drr*drr;
		}
		ave/=(double)(events->n_events-1);
		ave2/=(double)(events->n_events-1);
		fprintf(fp,"\n%lf\t%lf\n",ave,sqrt(ave2 - ave*ave));
	}

	if(events->n_events>2){
		for(ave=0.0,ave2=0.0,i=2;i<events->n_events;i++){
			drr=(2.0*events->events[i-1].sample-events->events[i-2].sample-events->events[i].sample)/freq;
			fprintf(fp,"%lf\t", 1000.0*drr);
			ave+=drr;
			ave2+=drr*drr;
		}
		ave/=(double)(events->n_events-2);
		ave2/=(double)(events->n_events-2);
		fprintf(fp,"\n%lf\t%lf\n",ave,sqrt(ave2 - ave*ave));
	}

	if(events->n_events>3){
		for(ave=0.0,ave2=0.0,i=3;i<events->n_events;i++){
			drr=(-1.0*events->events[i-3].sample+events->events[i-2].sample+events->events[i-1].sample-events->events[i].sample)/freq;
			fprintf(fp,"%lf\t", 1000.0*drr);
			ave+=drr;
			ave2+=drr*drr;
		}
		ave/=(double)(events->n_events-3);
		ave2/=(double)(events->n_events-3);
		fprintf(fp,"\n%lf\t%lf\n",ave,sqrt(ave2 - ave*ave));
	}

	fclose(fp);

	return(0);
}

*/

#ifdef CINC2017_JSON_OUTPUT
int tests_print_data_to_json(FILE *out, struct data const * const dat,struct data *filtered_dat, struct data const * const extra_dat,struct test_events const * const events, struct test_ranges *ch_ranges,struct test_marker_events *marker_events, int n_marker_events, int downsample_mult, double *timeseries, struct test_clusters *cluster_set, struct test_events *cluster_events);
int tests_plot_cluster_templates(char *json_filename/*char *path, char *data_filename, */, struct test_clusters *cluster_set, struct test_events *events, struct test_events *reference_events, struct data *data);
#endif


extern double rhythm_frequency_ratio(double *rr, size_t n);
int do_classify(char *filename, FILE *fp, FILE *fp2){
	struct data data,energy;
	struct test_events events;
	struct test_clusters cluster_set;
	struct test_ch_info ch_info;
	struct test_event_infos event_infos;
	int ch;
	double bpm;
	double rhythm_ratio;
	double *rr;
	double pq=-1;
	double p_corr=0.0;

	// 1. initialize

	cluster_set.n_clusters=-1;
	event_infos.n_infos = 0;
	events.n_events=0;
	events.n_ranges=0;
	data.number_of_channels=0;
	data.ch=0;
	energy.number_of_channels=0;
	energy.ch=0;
	ch_info.nch=0;
	ch_info.ch_goodness=NULL;
	ch_info.ch_ranges=NULL;
	ch_info.amplitude_normalization=NULL;

	// 2. read the data
	mit_read_data(filename, &data);
	//test_std_accuracy(data.ch[0].raw, data.samples_per_channel, 0.15*data.sample_freq);
	//return(0);

	conf_initialize(&data,NULL);
	ch_info.ch_goodness=my_malloc(data.number_of_channels*sizeof(double));
	ch_info.ch_ranges = my_malloc(data.number_of_channels	* sizeof(struct test_ranges));
	for (ch = 0; ch < data.number_of_channels; ch++) {
		ch_info.ch_goodness[ch]=2.0; // initialized with > 1.0 for easier debugging
		ch_info.ch_ranges[ch].n_ranges = 0;
		ch_info.ch_ranges[ch].ranges = NULL;
	}

	ch_info.nch=data.number_of_channels;

	// 3. detect beats
	trig_do(&data, &energy,NULL, &events,&event_infos, &ch_info, NULL,&cluster_set);

	// 4. print the results

#ifdef CINC2017_INCLUDE_FILENAME_TO_OUTPUT
	fprintf(fp,"%s;",filename);
#endif

#ifdef CINC2017_CLASS_OUTPUT
	if(events.n_events<5 || cluster_set.n_clusters<1){ // Noise?
		fprintf(fp,"~\n");
	}

	//else if(tests_class_beat_homogenity(&cluster_set,&events,data.samples_per_channel,data.sample_freq)<0.5){ // Noise?
	else if(tests_class_beat_homogenity(&cluster_set,&events,data.samples_per_channel,data.sample_freq)<0.40){ // Noise?
		fprintf(fp,"~\n");
	}
	else{
		rr=rhythm_define_rr(&events,data.sample_freq);
		if(events.n_events>3){
			rhythm_ratio=rhythm_frequency_ratio(rr+1, events.n_events-1);
		}
		else{
			rhythm_ratio=0.0;
		}
//		if(tests_class_good_entropy_val(rr,&events,data.sample_freq,30.0)>0.80 && (p_corr=p_wave_correlation(&events, &data, &cluster_set, &pq))<0.25){ // AF?
		if(tests_class_good_entropy_val(rr,&events,data.sample_freq,30.0)>0.80 && (p_corr=p_wave_correlation(&events, &data, &cluster_set, &pq))<0.25 && rhythm_ratio<1.0){ // AF?
			fprintf(fp,"A\n");
		}
//		else if(tests_class_rrrms_d(rr,events.n_events)>0.39){ // O?
		else if(tests_class_rrrms_d(rr,events.n_events)>0.39){ // O?
			fprintf(fp,"O\n");
		}
		else{
			bpm=tests_class_med_bpm(rr,events.n_events); // O?
			if(bpm<50 || bpm>100){ // O?
				fprintf(fp,"O\n");
			}
//			else if(tests_class_qrs_width(&cluster_set)>0.12){ // O?
			else if(tests_class_normal_qrs_width(&cluster_set)>0.120){ // O?
				fprintf(fp,"O\n");
			}
			else if(tests_class_n_S(&events)+tests_class_n_V(&events)>1){ // O?
				fprintf(fp,"O\n");
			}
		/*	else if(tests_class_n_V(&events)>3){ // O?
				fprintf(fp,"O\n");
			}*/
			else if(pq>0.25 && pq<0.35){ // O?
				fprintf(fp,"O\n");
			}
			else if(tests_class_normal_initial_qrs_slope(&cluster_set)>0.070){ // O?
				fprintf(fp,"O\n");
			}
			else{ //N
				fprintf(fp,"N\n");
			}
		}
		my_free(rr);
	}

#endif
#ifdef CINC2017_MARKER_OUTPUT
#ifdef CINC2017_INCLUDE_FILENAME_TO_OUTPUT
	fprintf(fp2,"%s;",filename);
#endif
#ifndef CINC2017_DEV_OUTPUT
	if(events.n_events<2 || cluster_set.n_clusters<1){
		fprintf(fp2,"0.0;0.0;0.0;0.0;0.0;0.0\n");
	}
	else{
		rr=rhythm_define_rr(&events,data.sample_freq);
		if(pq<0){
			p_corr=p_wave_correlation(&events, &data, &cluster_set, &pq);
		}
		fprintf(fp2,"%lf;%lf;%lf;%lf;%lf;%lf;",
				tests_class_good_entropy_val(rr,&events,data.sample_freq,30.0),
				tests_class_beat_homogenity(&cluster_set,&events,data.samples_per_channel,data.sample_freq),
				tests_class_rrrms_d(rr,events.n_events),
				tests_class_qrs_width(&cluster_set),
				p_corr,pq);
		fprintf(fp2,"%lf\n",tests_class_med_bpm(rr,events.n_events)); // NOTICE: this has to be printed last, since it reorders rr
		my_free(rr);
	}
#else
		if(events.n_events<2 || cluster_set.n_clusters<1){
			fprintf(fp2,"0.0;0.0;0.0;0.0;0.0;0.0;0;0;0.0;0.0;0.0;0.0;0.0;0.0;0.0\n");
		}
		else{
			rr=rhythm_define_rr(&events,data.sample_freq);
			if(pq<0){
				p_corr=p_wave_correlation(&events, &data, &cluster_set, &pq);
			}
			if(events.n_events>3){
						rhythm_ratio=rhythm_frequency_ratio(rr+1, events.n_events-1);
					}
			else{
				rhythm_ratio=0.0;
			}
			fprintf(fp2,"%lf;%lf;%lf;%lf;%lf;%lf;%d;%d;%lf;%lf;%lf;%lf;",
					tests_class_good_entropy_val(rr,&events,data.sample_freq,30.0),
					tests_class_beat_homogenity(&cluster_set,&events,data.samples_per_channel,data.sample_freq),
					tests_class_rrrms_d(rr,events.n_events),
					tests_class_normal_qrs_width(&cluster_set),
					tests_class_normal_initial_qrs_slope(&cluster_set),
					tests_class_st(&data,&events,&cluster_set),
					tests_class_n_S(&events),
					tests_class_n_V(&events),
					get_max_c_bpm(&events, data.sample_freq, 5.0),
					rhythm_ratio,
					p_corr,
					pq);
			fprintf(fp2,"%lf;%lu;%lu\n",tests_class_med_bpm(rr,events.n_events),events.n_events,data.samples_per_channel); // NOTICE: this has to be printed last, since it reorders rr
			my_free(rr);
		}

#endif
#endif
#ifdef CINC2017_TEST_OUTPUT
	rr=rhythm_define_rr(&events,data.sample_freq);
		if(events.n_events>1){
			rhythm_frequency_ratio(rr+1, events.n_events-1);
		}
		else{
			rhythm_frequency_ratio(NULL, 0);
		}
#endif
#ifdef CINC2017_JSON_OUTPUT
		{
			// CONF
			struct conf_cluster *c_conf=conf_cluster_get();
//			int win_before = c_conf->win_before * data.sample_freq + 0.5;
//			int win_after = c_conf->win_after * data.sample_freq + 0.5;
			int win_before = 0.050 * data.sample_freq + 0.5;
			int win_after = 0.050 * data.sample_freq + 0.5;

			double max_std_diff_mult = 1.20; // We accept 30 % amplitude modulation (due to breathing etc.) without any penalty

			FILE *out_fp;
			char *p;
			char json_filename[FILENAME_MAX];
			struct data correlation_data;
			strcpy(json_filename, "/var/www/RAecg_annotation/cache/"); // hardcoded destination path..
			p = strrchr(filename, '/');
			if (p == NULL) {
				strcat(json_filename, "/");
				strcat(json_filename, filename);
			} else {
				strcat(json_filename, p);
			}
			strcat(json_filename, ".cinc.json");

			out_fp = fopen(json_filename, "w");

			data_initiate_and_alloc_based_on_template(&correlation_data,&data);
			correlation_data.ch[0].samples_per_mv=1000.0;
			if(cluster_set.n_clusters>0){
				add_sliding_resampled_corr(data.ch[0].raw+win_before, cluster_set.clusters[0].templates[0][0]+cluster_set.template_offset, cluster_set.frequency_mult, win_before, win_after+1, data.samples_per_channel-(win_before+win_after+1), max_std_diff_mult, correlation_data.ch[0].raw+win_before);
			}
			tests_print_data_to_json(out_fp, &data,&correlation_data,NULL, &events, ch_info.ch_ranges, NULL, 0, 1, NULL, &cluster_set, &events);
			fclose(out_fp);
			tests_plot_cluster_templates(json_filename, &cluster_set, &events,NULL, &data);
			free_data(&correlation_data);
		}
#endif


	tests_free_clusters(&cluster_set);
	tests_free_ch_info(&ch_info);
	tests_free_events(&events);
	free_data(&data);

	return(0);
}


int main(int argc, char *argv[]) {
	FILE *fp_class=stdout;
	FILE *fp_marker=stdout;

#ifdef CINC2017_RESULTS_TO_FILE
#ifdef CINC2017_RUN_ALL_TESTDATA
#ifdef CINC2017_CLASS_OUTPUT
	fp_class=fopen("class.txt","a");
#endif
#ifdef CINC2017_MARKER_OUTPUT
	fp_marker=fopen("marker.txt","a");
#endif
#else
#ifdef CINC2017_CLASS_OUTPUT
	fp_class=fopen("class.txt","w");
#endif
#ifdef CINC2017_MARKER_OUTPUT
	fp_marker=fopen("marker.txt","w");
#endif
#endif

#endif

#ifndef CINC2017_RUN_ALL_TESTDATA
	return(do_classify(argv[1],fp_class,fp_marker));
#else
	char filename[FILENAME_MAX+1];
	FILE *fp_list=fopen(argv[1],"r");
	fgets(filename,FILENAME_MAX,fp_list); // skip the header
	while(fgets(filename,FILENAME_MAX,fp_list)){	// loop all the filenames
		filename[strlen(filename)-1]='\0'; // remove '\n'
		do_classify(filename,fp_class,fp_marker);
	}
	fclose(fp_list);
#endif

#ifdef CINC2017_RESULTS_TO_FILE
#ifdef CINC2017_CLASS_OUTPUT
	fclose(fp_class);
#endif
#ifdef CINC2017_MARKER_OUTPUT
	fclose(fp_marker);
#endif
#endif

	return(0);
}

