/*
 * array.c
 *
 *  Created on: Oct 24, 2016
 *      Author: hvaanane
 */

#include <stdio.h>
#include <stdlib.h>


static int array_char_comparison(const void *event1,const void *event2){
	if(*((char *)(event1)) < *((char *)(event2))){
		return(-1);
	}
	else if(*((char *)(event1)) > *((char *)(event2))){
		return(1);
	}
	return(0);
}

static int array_int_comparison(const void *event1,const void *event2){
	if(*((int *)(event1)) < *((int *)(event2))){
		return(-1);
	}
	else if(*((int *)(event1)) > *((int *)(event2))){
		return(1);
	}
	return(0);
}

static int array_size_t_comparison(const void *event1,const void *event2){
	if(*((size_t *)(event1)) < *((size_t *)(event2))){
		return(-1);
	}
	else if(*((size_t *)(event1)) > *((size_t *)(event2))){
		return(1);
	}
	return(0);
}

static int array_float_comparison(const void *event1,const void *event2){
	if(*((float *)(event1)) < *((float *)(event2))){
		return(-1);
	}
	else if(*((float *)(event1)) > *((float *)(event2))){
		return(1);
	}
	return(0);
}

static int array_double_comparison(const void *event1,const void *event2){
	if(*((double *)(event1)) < *((double *)(event2))){
		return(-1);
	}
	else if(*((double *)(event1)) > *((double *)(event2))){
		return(1);
	}
	return(0);
}

void array_csort(char *data, size_t len){
	qsort(data,len,sizeof(char),array_char_comparison);
}

void array_isort(int *data, size_t len){
	qsort(data,len,sizeof(int),array_int_comparison);
}

void array_ssort(size_t *data, size_t len){
	qsort(data,len,sizeof(size_t),array_size_t_comparison);
}

void array_fsort(float *data, size_t len){
	qsort(data,len,sizeof(float),array_float_comparison);
}

void array_dsort(double *data, size_t len){
	qsort(data,len,sizeof(double),array_double_comparison);
}

// function for finging kth smallest element in array. Notice that this implementation modifies the input array a!!!
double array_kth_biggest(double *a, size_t n, size_t k){
    long int i,j,l,m;
    double x,tmp;
    l=0;
    m=n-1;
    while (l<m){
    	x=a[k];
    	i=l;
    	j=m;
    	do {
    		while (a[i]<x) i++;
    		while (x<a[j]) j--;
    		if (i<=j){
    			tmp=a[i]; // swap
    			a[i++]=a[j];
    			a[j--]=tmp;
    		}
    	}
    	while (i<=j);
    	if (j<k) l=i;
    	if (k<i) m=j;
    }
    return a[k] ;
}

// Median. Notice that the algorithm modifies the input array!
double array_dmedian(double *a, size_t n){
	if(n%2==1){
		return(array_kth_biggest(a, n, n/2));
	}
	else{
		if(n==0){
			return(0);
		}
		array_dsort(a,n);
		return((a[n/2-1]+a[n/2])/2.0);
	}
}

// Median. Notice that the algorithm modifies the input array!
double array_dmedmean(double *a, size_t n,size_t n_out){
	size_t i;
	double sum=0.0;
	if(n==0){
		return(0);
	}
	if(n_out*2>=n){
		return(array_dmedian(a,n));
	}
	if(n_out>0){
		array_dsort(a,n);
	}
	for(i=n_out;i<n-n_out;i++){
		sum+=a[i];
	}
	return(sum/(double)(n-2*n_out));
}
