function [brob,stats] = smg_createFit(RR,figureId)
%CREATEFIT(RR)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      Y Output: RR
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 28-Mar-2017 15:55:22


%% Fit: 'untitled fit 1'.

% isplot = 0;

% [msgStr,msgId] = lastwarn;
warnStruct = warning('off','stats:statrobustfit:IterationLimit');

[xData, yData] = prepareCurveData( [], RR );

[brob,stats] = robustfit(xData,yData);
% bls = polyfit(xData,yData,1);

if figureId>0
    set(gcf,'visible','on')

    index123 = find(stats.w==0);
    
figure(figureId);    
clf;
plot(xData,RR, 'o');
hold on;
if length(index123) > 0
    expRR = RR(index123);
plot(index123,expRR, 'x');
end
hold on;
%plot(xData,bls(2)+bls(1)*xData,'r','LineWidth',2);
hold on;
plot(xData,brob(1)+brob(2)*xData,'g','LineWidth',2)
ylim([-2,2]);
hold off;
% legend( h, 'RR', 'untitled fit 1', 'Location', 'NorthEast' );
% Label axes
ylabel 'dRR'
grid on
% pause();

end

end

