function Td = uniformrrmeasure(t)
% UniformRRmeasure Returns the Toeplitz distance as a measure for uniform
% RR intervals.
%   Td = UNIFORMRRMEASURE(t) with a vector t calculates the Frobenius norm
%   of the residual matrix of the distance matrix D and its projected
%   Toeplitz matrix. The entry D(i,j) is defined as t(j)-t(i).

% The distance matrix:
D = zeros(numel(t));
for i = 1:numel(t)
    for j = i+1:numel(t)
        D(i,j) = t(j)-t(i);
    end
end
D = D+D.';
R = D-toeplitzize(detoeplitzize(D));
Td = frob(R);