function T = toeplitzize(X,varargin)
%HANKELIZE Hankelization of vectors, matrices or tensors.
%   H = HANKELIZE(X) with a vector X of length N constructs a Hankel matrix
%   with X(1:ceil(N/2)) on the first column and X(ceil(N/2):end) on the
%   last row.
%
%   HANKELIZE(X,'key',value) or HANKELIZE(X,options) can be used to
%   pass the following options:
%   
%   - Ind:      Instead of using the segments Y(ceil((k-1)*N/K):
%               ceil(k*N/K)) of every fiber Y in X for 1<=k<=K, the
%               segments Y(1:ind(1)), Y(ind(k-1)+1:ind(k)) for 1<k<K, and
%               Y(ind(K-1)+1:end) are used. Ind is a vector of length
%               K-1.
%
%   - Sizes:    Instead of setting the breakpoints of the segments with the
%               Ind option, the user can indicate the size of the Hankel
%               tensor using the Sizes option. Sizes is a vector of length
%               K-1. The Kth element is determined as N-sum(sizes)+K-1.
%
%   See also detoeplitzize, hankelize, loewnerize, segmentize, decimate

%   Authors: Otto Debals (Otto.Debals@esat.kuleuven.be)
%            Lieven De Lathauwer (Lieven.DeLathauwer@kuleuven-kulak.be)
%
%   References:
%   [1] O. Debals, L. De Lathauwer, "Stochastic and Deterministic
%       Tensorization for Blind Signal Separation," Latent Variable
%       Analysis and Signal Separation, Springer Berlin / Heidelberg, Vol.
%       9237, 2015, pp. 3-13.
%
%   Version History:
%   - 2017/02/28    OD      Initial version

if isvector(X), X = X(:);
else error('toeplitzize:X','Non-vector data in X is not yet supported!'); end

T = hankelize(X,varargin{:});
T = T(end:-1:1,:);