function classifyResult = challenge(recordName)
%
% Sample entry for the 2017 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     N = normal rhythm
%                     A = AF
%                     O = other rhythm
%                     ~ = noisy recording (poor signal quality)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2017/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Chengyu Liu and Qiao Li January 20 2017
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by:
%
%
% rng('default')
featurevector = [];
classifyResult = 'N'; % default output normal rhythm
db = [];
load input_SVM
load types
rng('default')
%% AF determination
[tm,ecg,fs,siginfo]=rdmat(recordName);
ecg = ecg';
ecg = zscore(ecg);

ecg = preprocess_wavelet(ecg);
ecg = ecg - bwqvr(1000, ecg);
[QRS,~,en_thres] = qrs_detect2(ecg,0.25,0.6,fs);

featurematrix = zeros(1,8);

s = 300;                                               % Sampling Frequency (Hz)
Fn = fs/2;                                              % Nyquist Frequency
Wp = [1  100]/Fn;                                       % Passband (Normalised)
Ws = [0.5  110]/Fn;                                     % Stopband (Normalised)
Rp = 10;                                                % Passband Ripple (dB)
Rs = 30;                                                % Stopband Ripple (dB)
[n,Ws] = cheb2ord(Wp, Ws, Rp, Rs);                      % Chebyshev Type II Order
[b,a] = cheby2(n, Rs, Ws);                              % Transfer Function Coefficients
ecg = filter(b,a,ecg);

[qrs_pos,~,en_thres] = qrs_detect2(ecg,0.25,0.6,fs); % Try different QRS detector?

RR = diff(qrs_pos);
HR = 60./(RR./fs);
if length(qrs_pos) > 2
    Td_n = uniformrrmeasure(diff(qrs_pos));
else
    Td_n = 0;
end
featurematrix(1) = mean(HR);
featurematrix(2) = min(HR);
featurematrix(3) = max(HR);
featurematrix(4) = std(HR);
featurematrix(5) = length(HR);
featurematrix(6) = Td_n;

if length(RR) > 2
    AFEv = comput_AFEv(RR');
else
    AFEv = 0;
end
featurematrix(8) = AFEv;

options = struct;
options.Display = false;
options.TolFun = eps^2;
options.TolX = eps;
options.MaxIter = 200;
options.CGMaxIter = 250;

temp = find(qrs_pos < 0.25*fs + 1);
qrs_pos(temp) = [];
temp = find(qrs_pos > length(ecg) - 0.4*fs);
qrs_pos(temp) = [];
beat = zeros(length(qrs_pos), 0.65*fs + 1);
for j = 1:length(qrs_pos)
    beat(j,:) = (ecg(qrs_pos(j) - 0.25*fs:qrs_pos(j) + 0.4*fs));
end

mean_beat = mean(beat); %TODO: Add irregular beat detection/rejection?


[r_or,c_or] = size(mean_beat);
sig = changeSize(mean_beat);
% sig = x;
Lo_D = [ 0 -2 2 0 ];
Hi_D = [1/8 3/8 3/8 1/8];
scale_qrs = 5;
res = swt(sig, scale_qrs, Hi_D, Lo_D );
res = res(:,1:c_or);
for j = 1:5
    totaltensor(j,:) = res(j,:);
end

cinit = {randn(1,size(S,2)), randn(1,size(S,3))};
c = kpe_nls(U{1}*tens2mat(S,1,[]), totaltensor(4,:)', cinit, options);


c = cellfun(@(x) x(:)./norm(x)*sign(x(1)), c, 'uni', 0);
scoreshb = sqrt(sum(bsxfun(@minus, db, c{2}).^2));
[~, tmp] = sort(scoreshb, 'ascend');
featurematrix(7) = types(tmp(1));

res = predict(Mdl, featurematrix);

if res == 1
    classifyResult = 'A';
elseif res == 2
    classifyResult = 'O';
elseif res == 3
    classifyResult = '~';
elseif res == 4
    classifyResult = 'N';
end



end





