function y=bwqvr(lambda,x)

if ~isscalar(lambda)||lambda<0
    error('Input ''lambda'' must be a non-negative scalar.')
end
if ~isvector(x)||length(x)<2
    error('Input ''x'' must be a vector with length(x)>1.')
end

if lambda~=0
    y=zeros(size(x));
    n=length(x);
    y(1) = -lambda/(1+lambda);
    x(1) = x(1)/(1+lambda);

    for i = 2:n-1
        t = 1+lambda*(2+y(i-1));
        y(i) = -lambda/t;
        x(i) = (x(i)+lambda*x(i-1))/t;
    end

    y(n) =(x(n)+lambda*x(n-1))/(1+lambda+lambda*y(n-1));
    for i = n-1:-1:1
        y(i) = x(i) - y(i)*y(i + 1);
    end
else
    y=x;
end

