function [X] = visualizeFeaturesCBL(loc, ref, classAsChar)
%%%
%
%   Extracts features from each example listed in example
%
%   @param loc: location of EKG example files
%   @param ref: name of references file (with extension)
%%%

%load filenames from REFERENCES
[filenames, class] = textread(strcat(loc, ref), '%s,%s', 'whitespace', ',');
%Initialize vars
m = size(filenames, 1);
X = zeros(m, 13);
desiredClassifier = uint8(classAsChar);
c = 0;

%Iterate over examples and accumulate features
for i = 1:m
    c = 1;
    %Grab this file
    currfile = strcat(loc, (filenames(i)));
    if(cell2mat(class(i)) == desiredClassifier)
        fprintf('Current File: %s\n', currfile{1});
        [tm, signal, fs, ~] = rdmat(currfile{1});

        %Create annotation file (NOT NEEDED ATM)
        %try
            %wqrs(currfile{1});
        %catch
            %dispaly("Error. Continuing.");
        %end

        %Calculate RR Interval
        [RR, ~] = ann2rr(currfile{1}, 'wfdb');

        %Calculate Inst. Heart Rate
        hr = tach(currfile{1}, 'wfdb');

        %Set row 1 to HRV
        X(i, c) = std(RR);
        fprintf('RR STD DEV: %g\n', X(i, c));
        c = c + 1;

        %Set row 1 to HRV
        X(i, c) = mean(RR);
        fprintf("RR MEAN: %g\n", X(i, c));
        c = c + 1;

        %Set row 2 to avg HR
        X(i, c) = std(hr);
        fprintf('HR STD DEV: %g\n', X(i, c));
        c = c + 1;

        %Set row 2 to avg HR
        X(i, c) = mean(hr);
        fprintf('HR MEAN: %g\n', X(i, c));
        c = c + 1;

        %Calculate ECG-Derived Repiratory (NOT WORKING YET)
        %y = edr(1, currfile{1}, 'wqrs', fs)

        %Calculate multiscale entropy
        ent = msentropy(signal);

        %Entropy mean
        X(i, c) = mean(ent);
        fprintf('ENTROPY MEAN: %g\n', X(i, c));
        c = c + 1;

        %Entropy std
        X(i, c) = std(ent);
        fprintf('ENTROPY STD DEV: %g\n', X(i, c));
        c = c + 1;

        [peaks, idx] = findpeaks(signal);

        %Frequency Analysis(?)
        X(i, c) = size(peaks, 1);
        fprintf('NUM DETECTED PEAKS: %g\n', X(i, c));
        c = c + 1;

        %Frequency Analysis(?)
        X(i, c) = std(peaks);
        fprintf('*STD DEV OF PEAK HEIGHTS: %g\n', X(i, c));
        c = c + 1;

        %Time/Frequency Analysis(?)
        X(i, c) = std(idx);
        fprintf('*STD DEV OF PEAK LOC: %g\n', X(i, c));
        c = c + 1;

        %Actual Frequency Analysis - std dev of fft
        f = fft(signal);
        X(i, c) = std(f);
        fprintf('FFT STD DEV: %g\n', X(i, c));
        c = c + 1;

        %Actual Frequency Analysis - avg of fft
        X(i, c) = mean(f);
        fprintf('FFT MEAN: %g\n', X(i, c));
        c = c + 1;

        %Actual Frequency Analysis
        X(i, c) = var(f);
        fprintf('FFT VARIANCE: %g\n', X(i, c));
        c = c + 1;

        %Set Output to last col
        X(i, c) = cell2mat(class(i));
        fprintf('CLASS: %g\n', X(i, c));

        %display data (fullscreen)
        fig = figure('units','normalized','outerposition',[0 0 1 1]);
        %fig = figure; (not fullscreen)
        plot(tm, signal);
        waitfor(fig);
        fprintf('----------------\n');
    end
end

end