function [X] = extractNonValidationCBL(loc, ref, valloc, valref)
%%%
%
%   Returns vector of 1's and 0's, where 1 is unique to the training set,
%   and 0 is in the validation set.
%
%   @param loc: location of EKG example files
%   @param ref: name of references file (with extension)
%%%

%load filenames from REFERENCES
[filenames, class] = textread(strcat(loc, ref), '%s,%s', 'whitespace', ',');
[filenamesVal, classVal] = textread(strcat(valloc, valref), '%s,%s', 'whitespace', ',');

%Initialize vars
m = size(filenames, 1);
X = zeros(m, 1);
c = 0;
currValLoc = 1;

%Iterate over examples and accumulate features
for i = 1:m
    c = 1;
    
    %Grab this file
    currfile = strcat(loc, (filenames(i)))
    
    if currValLoc < size(filenamesVal, 1) + 1
        currfileVal = strcat(loc, (filenamesVal(currValLoc)));
    
        %Keep track of location in validation set
        if strcmp(currfile{1}, currfileVal{1})
            disp(currfile{1});
            currValLoc = currValLoc + 1;
            continue;
        else
            X(i) = 1;
        end
    else
        X(i) = 1;
    end
end