function [X] = extractFeaturesChallengeCBL(recordName)
%%%
%
%   Extracts features from each example listed in example
%
%   @param loc: name of EKG file
%%%

%Initialize vars
X = zeros(1, 11);
i = 1;
c = 1;
warning('off','all');

%Grab this file
[tm, signal, fs, siginfo] = rdmat(recordName);
    
%Create annotation file
try
   wqrs(recordName);  
catch
    diplay('fail');
end
    
%Calculate RR Interval
[RR, tms] = ann2rr(recordName, 'wqrs');
    
%Calculate Inst. Heart Rate
hr = tach(recordName, 'wqrs');

%Set row 1 to HRV
X(i, c) = std(RR);
c = c + 1;
    
%Set row 2 to mean RR
X(i, c) = mean(RR);
c = c + 1;
    
%Set row 3 to deviation of beat length
X(i, c) = std(hr);
c = c + 1;
    
%Set row 4 to std dev of beat length
X(i, c) = mean(hr);
c = c + 1;
    
%Calculate ECG-Derived Repiratory (NOT WORKING YET)
%y = edr(1, currfile{1}, 'wqrs', fs)
    
%Calculate multiscale entropy
ent = msentropy(signal);
    
%Entropy mean
X(i, c) = mean(ent);
c = c + 1;
    
%Entropy std
X(i, c) = std(ent);
c = c + 1;
    
[peaks, idx] = findpeaks(signal);
    
%Number of peaks
X(i, c) = size(peaks, 1);
c = c + 1;
    
%std dev of peaks
X(i, c) = std(peaks);
c = c + 1;

%Std dev of indices
X(i, c) = std(idx);
c = c + 1;
    
%Actual Frequency Analysis - std dev of fft
f = fft(signal);
X(i, c) = std(f);
c = c + 1;
    
%Actual Frequency Analysis - avg of fft
%X(i, c) = mean(f);
%c = c + 1;
    
%Actual Frequency Analysis - var of fft
X(i, c) = var(f);
c = c + 1;
    
end