function [X] = extractFeaturesCBL(loc, ref, fs)
%%%
%
%   Extracts features from each example listed in example
%
%   @param loc: location of EKG example files
%   @param ref: name of references file (with extension)
%   @param fs: info on signal
%%%

%load filenames from REFERENCES
[filenames, class] = textread(strcat(loc, ref), '%s,%s', 'whitespace', ',');
%Initialize vars
m = size(filenames, 1);
X = zeros(m, 2);
c = 0;
warning('off','all');
warning off;

%Iterate over examples and accumulate features
for i = 1:m
    c = 1;
    %Grab this file
    currfile = strcat(loc, (filenames(i)))
    [tm, signal, fs, siginfo] = rdmat(currfile{1});
    
    %Create annotation file (NOT NEEDED ATM)
    try
        gqrs(currfile{1});
    catch
        dispaly('Error. Continuing.');
    end
    
    %Calculate RR Interval
 %   [RR, tms] = ann2rr(currfile{1}, 'gqrs');
    
    %Calculate Inst. Heart Rate
  %  hr = tach(currfile{1}, 'gqrs');

    %Set row 1 to HRV
    X(i, c) = std(RR);
    c = c + 1;
    
    %Set row 1 to HRV
    X(i, c) = mean(RR);
    c = c + 1;
    
    %Set row 2 to avg HR
    X(i, c) = std(hr);
    c = c + 1;
    
    %Set row 2 to avg HR
    X(i, c) = mean(hr);
    c = c + 1;
    
    %Calculate ECG-Derived Repiratory (NOT WORKING YET)
    %y = edr(1, currfile{1}, 'wqrs', fs)
    
    %Calculate multiscale entropy
   % ent = msentropy(signal);
    
    %Entropy mean
    X(i, c) = mean(ent);
    c = c + 1;
    
    %Entropy std
    X(i, c) = std(ent);
    c = c + 1;
    
    [peaks, idx] = findpeaks(signal);
    
    %Frequency Analysis(?)
    X(i, c) = size(peaks, 1);
    c = c + 1;
    
    %Frequency Analysis(?)
    X(i, c) = std(peaks);
    c = c + 1;
    
    %Time/Frequency Analysis(?)
    X(i, c) = std(idx);
    c = c + 1;
    
    %Actual Frequency Analysis - std dev of fft
    f = fft(signal);
    X(i, c) = std(f);
    c = c + 1;
    
    %Actual Frequency Analysis - avg of fft
    X(i, c) = mean(f);
    c = c + 1;
    
    %Actual Frequency Analysis
    X(i, c) = var(f);
    c = c + 1;
    
    %Set Output to last col
    X(i, c) = cell2mat(class(i));
    
end

end