function [X] = createDataMatrixCBL(loc, ref, min)
%%%
%
%   Extracts features from each example listed in example
%
%   @param loc: location of EKG example files
%   @param ref: name of references file (with extension)
%   @param min: How long each signal schould be 
%       (signals must be at least this long,  
%           otherwise an error will be thrown)
%%%

%load filenames from REFERENCES
[filenames, class] = textread(strcat(loc, ref), '%s,%s', 'whitespace', ',');

%Initialize vars
m = size(filenames, 1);
X = zeros(m, min+1);

%Iterate over examples and accumulate data
for i = 1:m 
    
    %Grab this file, Print name so we can track progress
    currfile = strcat(loc, (filenames(i)))
    [~, signal, ~, ~] = rdmat(currfile{1});
    assert(size(signal,1) >= min);
    
    %Set Partial Signal to features, Set last col to output values
    X(i, :) = [signal(1:min,1)' asciiToNumberingSystem(cell2mat(class(i)))];
    
end

end