function newX = changeOutputValuesCBL(X, oldY, normal, afib, other, noisy)
%%%
%
%	Converts output values of given matrix to new scheme
%
%%%
  
numFeatures = size(X, 2) - 1;
Y = zeros(size(oldY));
Y = Y + normal * (oldY==78);
Y = Y + afib * (oldY==65);
Y = Y + other * (oldY==79);
Y = Y + noisy * (oldY==126);

rec_name = 'Vs';

if(normal == 1)
    rec_name = strcat('Normal', rec_name);
else if(normal == 0)
    rec_name = strcat(rec_name, 'Normal');
end
end
if(afib == 1)
    rec_name = strcat('Afib', rec_name);
else if(afib == 0)
    rec_name = strcat(rec_name, 'Afib');
end
end
if(other == 1)
    rec_name = strcat('Other', rec_name);
else if(other == 0)
    rec_name = strcat(rec_name, 'Other');
end
end
if(noisy == 1)
    rec_name = strcat('Noisy', rec_name);
else if(noisy == 0)
    rec_name = strcat(rec_name, 'Noisy');
end
end

disp(rec_name);
clipboard("copy", rec_name);

X = X(Y>=0,:);
Y = Y(Y>=0);

newX = [X(:,1:numFeatures) Y];
newX = newX(Y > -1, :);
end