function classifyResult = challenge(recordName)
%
% Sample entry for the 2017 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     N = normal rhythm
%                     A = AF
%                     O = other rhythm
%                     ~ = noisy recording (poor signal quality)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2017/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Dan Giaime dsg6874@g.rit.edu
%
% Last modified by: Dan Giaime
%
%
X = extractFeaturesChallengeCBL(recordName);

load('trainedClassifier.mat');

%Y(oldY==78) = 1;  % N
%Y(oldY==65) = 2;  % A
%Y(oldY==79) = 3;  % O
%Y(oldY==126) = 4; % ~

%Classify between Noisy and All others
if trainedClassifier.predictFcn(X) == 126
    classifyResult = '~';
    
%Classify between Normal and Afib/Other
elseif trainedClassifier.predictFcn(X) == 78
    classifyResult = 'N';
    
%Classify between Afib and Other
elseif trainedClassifier.predictFcn(X) == 65
    classifyResult = 'A';
    
%Classify between Afib and Other
elseif trainedClassifier.predictFcn(X) == 79
    classifyResult = 'O';
end
    



%% You can add the determination rules for other rhythm and noisy recordings here

