annfunction [X] = addFeatureCBL(loc, ref, fs, X, n)
%%%
%
%   Extracts features from each example listed in example
%
%   @param loc: location of EKG example files
%   @param ref: name of references file (with extension)
%   @param fs: info on signal
%   @param X: Matrix to add a feature to
%   @param n: number of features to add
%%%

%load filenames from REFERENCES
[filenames, class] = textread(strcat(loc, ref), '%s,%s', 'whitespace', ',');
%Initialize vars
m = size(filenames, 1);
new = zeros(m, n);

%Iterate over examples and accumulate feature
for i = 1:m
    %Grab this file
    currfile = strcat(loc, (filenames(i)))
    [tm, signal, fs, siginfo] = rdmat(currfile{1});
    c = 1;
    
    %Create annotation file (NOT NEEDED ATM)
    %wqrs(currfile{1});
    
    %Calculate RR Interval
    %[RR, tms] = ann2rr(currfile{1}, 'wqrs');
    
    %Calculate Inst. Heart Rate
    %hr = tach(currfile{1}, 'wqrs');

    %Set row 1 to HRV
    %X(i, c) = std(RR);
    %c = c + 1;
    
    %Set row 1 to HRV
    %X(i, c) = mean(RR);
    %c = c + 1;
    
    %Set row 2 to avg HR
    %X(i, c) = std(hr);
    %c = c + 1;
    
    %Set row 2 to avg HR
    %X(i, c) = mean(hr);
    %c = c + 1;
    
    %Calculate ECG-Derived Repiratory (NOT WORKING YET)
    %y = edr(1, currfile{1}, 'wqrs', fs)
    
    %Calculate multiscale entropy
    %ent = msentropy(signal);
    
    %Entropy mean
    %X(i, c) = mean(ent);
    %c = c + 1;
    
    %Entropy std
    %X(i, c) = std(ent);
    %c = c + 1;
    
    %[peaks, idx] = findpeaks(signal);
    
    %Frequency Analysis(?)
    %X(i, c) = size(peaks, 1);
    %c = c + 1;
    
    %Frequency Analysis(?)
    %X(i, c) = std(peaks);
    %c = c + 1;
    
    %Time/Frequency Analysis(?)
    %X(i, c) = std(idx);
    %c = c + 1;
    
    %Actual Frequency Analysis - std dev of fft
    f = fft(signal);
    %new(i, c) = std(f);
    %c = c + 1;
    
    %Actual Frequency Analysis - avg of fft
    %new(i, c) = mean(f);
    %c = c + 1;
    
    %Actual Frequency Analysis
    new(i, c) = var(f);
    c = c + 1;
    
    %Set Output to last col
    new(i, c) = cell2mat(class(i));
end


X = [X new];

end