function [IMF,res]=siftingEMD(sig,p,maxiter)
% IMF=siftingEMD(sig,p,maxiter)
% Esta funcin lleva a cabo el proceso de sifting para la extraccin de una
% nueva "Intrinsic Mode Function".

%% INPUTS %%
% sig       -->     Seal de entrada
% p         -->     Precisin requerida (umbral RMSE entre iteraciones)
% maxiter   -->     N mximo de iteraciones

%% OUTPUTS %%
% IMF       -->     Funcin IMF obtenida
% res       -->     Residuo para continuar con el proceso de descomposicin

%% CDIGO %%
IMF=sig;
RMSE=100;
iter=0;
l=length(sig);
res=zeros(1,l);
while(iter<maxiter && RMSE>p)
    iter=iter+1;
    [pks_min,locs_min,pks_max,locs_max]=extremosRelat(IMF);
    if length(pks_min)>2 && length(pks_max)>2
        envS=spline([1,locs_max,l],[IMF(1),pks_max,IMF(end)],1:l);
        envI=spline([1,locs_min,l],[IMF(1),pks_min,IMF(end)],1:l);
        envM=(envS+envI)/2;
        lastIMF=IMF;
        IMF=IMF-envM;
        RMSE=sqrt(mean((IMF-lastIMF).^2));
        res=sig-IMF;
    else
        break;
    end
end
end

%% FUNCIONES AUXILIARES %%
function [pks_min,locs_min,pks_max,locs_max]=extremosRelat(sig)
sig_inv=abs(sig-max(sig));
[pks_max,locs_max]=findpeaks(sig);
[~,locs_min]=findpeaks(sig_inv);
pks_min=sig(locs_min);
end