function [f] = getChallengeFeatures4(Y, Fs)


    [ Y ] = Filtra_Artefactos( Y, Fs );

    % Get qrs index 
    [ ~, qrs_indices ] = getQRS( Y, Fs );
    QRSms              = (qrs_indices / Fs)*1000; % QRS waves occurrences in ms
    
    rr   = diff(QRSms);        % RR in ms
    rr   = Filter_Outliers(rr);  % Mejores resultados filtrando      
    rrd1 = diff(rr);
    rrd2 = diff(rrd1);  


    % Todas estas son las ptimas
     f0    = getMuSgKuSk(rr);             % Todas estas las medidas aportan informacin
     f1    = getMuSgKu(rrd1);             % Filtramos media y proporcion, las dems son las que mejor resultado dan en conjunto
     f2    = getSgKu(rrd2);               % Filtramos media y proporcin, las dems son las que mejor resultado dan en conjunto
     
     fdt   = getDistanceToPnnCurve(rrd1);                   %  4 Features [01-04]
     ff    = getChallengeFeaturesAux(qrs_indices, length(Y)); % 44 Features [05-48]
     fcx   = getRRComplexFeatures(rr);                        % 2 features  [49-50]
     frr   = [f0, f1, f2];                                    % 9 features  [51-59]
     pf    = getPoincareFeatures(rr);                         % 4 features  [60-63]
     lf    = getLorenzFeatures(rr);                           % 8 features  [64-71]
     ppc   = getPPC(Y, Fs, qrs_indices);                      % 1 features  [  -72]

      
     f    = [fdt, ff, fcx, frr, pf, lf, ppc];

end





function [f] = getChallengeFeaturesAux(rindx, n) % 44 Features


    Fs    = 300;
    QRSms = (rindx / Fs)*1000; % Posicin de los QRS en mili-segundos
    
    %rindx
    %n = length(y);
    win = 2400;
    ste = 1200; %1200;
    
    M = [];
  
    for w = 1 : ste: n-win
        start = w;
        stop  = start+win;
        
        idx = (rindx >= start & rindx <= stop);
        qqq = QRSms(idx);
        rr  = diff(qqq);
        
        if length(rr) > 2
            M = [M; getChallengeFeaturesI(rr)];
        end

    end    
    
    [n, ~] = size(M);
    
    if n == 0
        f = zeros(1, 11*4); % 11 features each
    elseif n == 1
        f = [M, M, M, zeros(1, 11)];
    else
        f = [nanmin(M), nanmax(M), nanmean(M), nanstd(M)];
    end   

end
    

function [ f ] = getChallengeFeaturesI( rr )
    
    rrd1 = diff(rr, 1); % Poincar
    rrd2 = diff(rr, 2); % Lorenz

    % Todas estas son las ptimas
    f0  = getMuSgKu(rr);           % Todas estas las medidas aportan informacin
    f1  = getSgKu(rrd1);           % Filtramos media y proporcion, las dems son las que mejor resultado dan en conjunto
    f2  = getSgKu(rrd2);           % Filtramos media y proporcin, las dems son las que mejor resultado dan en conjunto
    fpf = getPoincareFeatures(rr); % Poincar Features for this sequence
    
    f  = [f0, f1, f2, fpf];
end



function [ x, filter, nout ] = Filter_Outliers( x )

    % Umbrales para outliers
    m = median(x);
    s = std(x);
    
    th_up = m + (3.0 * s);
    th_dn = m - (3.0 * s);
    
    filter    = x<th_dn | x>th_up;
    nout      = sum(filter);
    x(filter) = [];

end



function [results] = getRRComplexFeatures(rr)

    
    % Antes Features 1
    entRR=shannonEntropy(rr);
    
    % Antes Feature 2 (lzcrr)
    aux = rr>median(rr);
    
    if length(aux) < 3
        lzcrr = entRR;
    else
        lzcrr=calc_lz_complexity(aux, 'exhaustive', 1);    
    end 

    results = [entRR, lzcrr];    

end

function [ppc] = getPPC(y, Fs, qrs_idx)

    % Test for errors
    if nargin < 3
        qrs_idx = [];
    elseif length(qrs_idx) < 3
        ppc = 1;
        return;        
    end
    
    % Antes Feature 5
    
    % Test if it is a Noisy Record
    [~,nQRS]=getQRSpattern(y', qrs_idx, 1200, Fs);
    ppc=length(nQRS)/sum(nQRS);
end

function [ values ] = getPoincareFeatures( rr ) %% rr ha de estar en ms

    if isempty(rr)
        values = ones(1, 4);
        return;
    end

    rrd1 = diff(rr);
    
    % RMSSD (Antes Feature 6)
    RMSSD=sqrt(mean(rrd1.^2));
    
    % PNN50 (Antes Features 4)
    n    = length(rrd1);
    NN25 = sum(rrd1>25);
    NN50 = sum(rrd1>50); % > 50 ms... las medidas estn en segundos
    NN75 = sum(rrd1>75);
    pNN25=NN25/n;
    pNN50=NN50/n;
    pNN75=NN75/n;
    

    values = [RMSSD, pNN25, pNN50, pNN75];
    
end

function [results] = getLorenzFeatures(rr)
    
    if isempty(rr) || length(rr) < 3
        results = zeros(1, 8);
        return;
    end

    n     = length(rr);
    x     = rr(1:end-1);
    y     = rr(2:end);
    theta = atand(x ./ y);
    li    = sqrt(x.^2 + y.^2); % Suma de distancias al origen (sdo)
    L     = mean(li);
    VAI   = sum(abs(theta-45))./(n-1);
    VLI   = sqrt(sum((li-L).^2))./(n-1);
    
    rrd1 = diff(rr);
    x    = rrd1(1:end-1);
    y    = rrd1(2:end);
    
    % Suma de distancias al origen
    sdo = sqrt(x.^2 + y.^2); 
   
    % Suma de distancias entre puntos consecutivos
    sdp = sqrt((x(1:end-1)-x(2:end)).^2 + (y(1:end-1)-y(2:end)).^2);
    
    % Diferencias entre distancias de 3 en 3 puntos, con ventana de 1
    dife = sqrt((sdp(1:end-1) - sdp(2:end)).^2);
    
    
    results = [VAI, VLI, getMuSg(sdo), getMuSg(sdp), getMuSg(dife)];
end

function [s] = getMu(v)
    if isempty(v), s = 0;
    else,          s = nanmean(v);
    end
end

function [s] = getMuSg(v)
    if isempty(v), s = [0, 0];
    else,          s = [nanmean(v), nanstd(v)];
    end
end

function [s] = getSgKu(v)
    if isempty(v), s = [0, 0];
    else,          s = [nanstd(v), kurtosis(v)];
    end
end

function [s] = getMuSgKu(v)
    if isempty(v), s = [0, 0, 0];
    else,          s = [nanmean(v), nanstd(v), kurtosis(v)];
    end
end

function [s] = getMuSgKuSk(v)
   
    if isempty(v)
        s = [NaN, NaN, NaN, NaN];
    else        
        s = [nanmean(v), nanstd(v), kurtosis(v), skewness(v)];
    end
end


function [f] = getDistanceToPnnCurve(rrd1ms)
  

   
    
%    mediaPNN = [...
%    0.443505491528788   0.297771705556683   0.293731623483935   0.422246482083091; ...
%    0.437654810046888   0.274899185576290   0.276901641903369   0.413402779336407; ...
%    0.437654810046888   0.274899185576290   0.276901641903369   0.413402779336407; ...
%    0.437654810046888   0.274899185576290   0.276901641903369   0.413402779336407; ...
%    0.426782570060351   0.233433759703390   0.248370515373190   0.402232563139189; ...
%    0.426782570060351   0.233433759703390   0.248370515373190   0.402232563139189; ...
%    0.426782570060351   0.233433759703390   0.248370515373190   0.402232563139189; ...
%    0.416369464476342   0.200419502635439   0.226038326047134   0.391695272507620; ...
%    0.416369464476342   0.200419502635439   0.226038326047134   0.391695272507620; ...
%    0.416369464476342   0.200419502635439   0.226038326047134   0.391695272507620; ...
%    0.411010308631460   0.184692218930935   0.216034181381741   0.387364740388958; ...
%    0.407890834839111   0.174055528275340   0.208939705578058   0.382382592375435; ...
%    0.407890834839111   0.174055528275340   0.208939705578058   0.382382592375435; ...
%    0.407890834839111   0.174055528275340   0.208939705578058   0.382382592375435; ...
%    0.398720619151503   0.152184064163476   0.194715742654498   0.372513793570570; ...
%    0.398720619151503   0.152184064163476   0.194715742654498   0.372513793570570; ...
%    0.398720619151503   0.152184064163476   0.194715742654498   0.372513793570570; ...
%    0.390600357416184   0.134165365775581   0.183683293194416   0.364647122653668; ...
%    0.390600357416184   0.134165365775581   0.183683293194416   0.364647122653668; ...
%    0.390600357416184   0.134165365775581   0.183683293194416   0.364647122653668; ...
%    0.387028465806124   0.127799175758787   0.179437789665524   0.362495692432641; ...
%    0.382051797361460   0.119785148763019   0.174730426862975   0.360098277131396; ...
%    0.382051797361460   0.119785148763019   0.174730426862975   0.360098277131396; ...
%    0.382051797361460   0.119785148763019   0.174730426862975   0.360098277131396; ...
%    0.373061711690620   0.107346909426630   0.166675711418169   0.356059810896244; ...
%    0.373061711690620   0.107346909426630   0.166675711418169   0.356059810896244; ...
%    0.373061711690620   0.107346909426630   0.166675711418169   0.356059810896244; ...
%    0.366008453851381   0.097307180102503   0.160046340921042   0.350617127034600; ...
%    0.366008453851381   0.097307180102503   0.160046340921042   0.350617127034600; ...
%    0.366008453851381   0.097307180102503   0.160046340921042   0.350617127034600; ...
%    0.362031102729717   0.092986622011584   0.157229442313856   0.349217268639381; ...
%    0.357273693008737   0.088770149323980   0.154746155800030   0.347792534837857; ...
%    0.357273693008737   0.088770149323980   0.154746155800030   0.347792534837857; ...
%    0.357273693008737   0.088770149323980   0.154746155800030   0.347792534837857; ...
%    0.349635984148161   0.081712223468463   0.150192472608684   0.343525238382238; ...
%    0.349635984148161   0.081712223468463   0.150192472608684   0.343525238382238; ...
%    0.349635984148161   0.081712223468463   0.150192472608684   0.343525238382238; ...
%    0.342667596372544   0.075820904156105   0.146218659811657   0.341451973088021; ...
%    0.342667596372544   0.075820904156105   0.146218659811657   0.341451973088021; ...
%    0.342667596372544   0.075820904156105   0.146218659811657   0.341451973088021; ...
%    0.339354320976359   0.073387934343371   0.144565041268386   0.341198280961537; ...
%    0.335272190425521   0.070428273771474   0.142549923406404   0.340044414479121; ...
%    0.335272190425521   0.070428273771474   0.142549923406404   0.340044414479121; ...
%    0.335272190425521   0.070428273771474   0.142549923406404   0.340044414479121; ...
%    0.328639367970055   0.066122694553695   0.139489714023674   0.337775608356646; ...
%    0.328639367970055   0.066122694553695   0.139489714023674   0.337775608356646; ...
%    0.328639367970055   0.066122694553695   0.139489714023674   0.337775608356646; ...
%    0.322340128173921   0.062288030594536   0.136778660816419   0.336505206202852; ...
%    0.322340128173921   0.062288030594536   0.136778660816419   0.336505206202852; ...
%    0.322340128173921   0.062288030594536   0.136778660816419   0.336505206202852; ...
%    0.318990102765428   0.060626943430078   0.135834264750304   0.335276321228384; ...
%    0.315515413863044   0.058854173078359   0.134597514274827   0.334370338458828; ...
%    0.315515413863044   0.058854173078359   0.134597514274827   0.334370338458828; ...
%    0.315515413863044   0.058854173078359   0.134597514274827   0.334370338458828; ...
%    0.308847187917633   0.055795520455443   0.132533948052306   0.331852572980328; ...
%    0.308847187917633   0.055795520455443   0.132533948052306   0.331852572980328; ...
%    0.308847187917633   0.055795520455443   0.132533948052306   0.331852572980328; ...
%    0.302372691697283   0.053244383296133   0.130488123340026   0.330328665292626; ...
%    0.302372691697283   0.053244383296133   0.130488123340026   0.330328665292626; ...
%    0.302372691697283   0.053244383296133   0.130488123340026   0.330328665292626; ...
%    0.300565533371808   0.052441183533536   0.129786139795660   0.329919389971690; ...
%    0.296012834162079   0.050880755842109   0.128858062520625   0.328231044625869; ...
%    0.296012834162079   0.050880755842109   0.128858062520625   0.328231044625869; ...
%    0.296012834162079   0.050880755842109   0.128858062520625   0.328231044625869; ...
%    0.289743339480242   0.048705868828445   0.127150440936350   0.326886583650108; ...
%    0.289743339480242   0.048705868828445   0.127150440936350   0.326886583650108; ...
%    0.289743339480242   0.048705868828445   0.127150440936350   0.326886583650108; ...
%    0.283368801437137   0.046897786204647   0.125673695104462   0.325121456476487; ...
%    0.283368801437137   0.046897786204647   0.125673695104462   0.325121456476487; ...
%    0.283368801437137   0.046897786204647   0.125673695104462   0.325121456476487; ...
%    0.281503687038971   0.046275600189290   0.124912142085903   0.324831916549522; ...
%    0.278393358438069   0.045234640731077   0.124094048068058   0.323187398270496; ...
%    0.278393358438069   0.045234640731077   0.124094048068058   0.323187398270496; ...
%    0.278393358438069   0.045234640731077   0.124094048068058   0.323187398270496; ...
%    0.273408075475660   0.043596346904166   0.122770240194550   0.322810484254006; ...
%    0.273408075475660   0.043596346904166   0.122770240194550   0.322810484254006; ...
%    0.273408075475660   0.043596346904166   0.122770240194550   0.322810484254006; ...
%    0.268599016287346   0.042366383499597   0.121651474280144   0.321268375335572; ...
%    0.268599016287346   0.042366383499597   0.121651474280144   0.321268375335572; ...
%    0.268599016287346   0.042366383499597   0.121651474280144   0.321268375335572; ...
%    0.265262478286654   0.041689130644226   0.120838103899568   0.319949753927572; ...
%    0.263883944438385   0.041260335902530   0.120272423959135   0.319659848119610; ...
%    0.263883944438385   0.041260335902530   0.120272423959135   0.319659848119610; ...
%    0.263883944438385   0.041260335902530   0.120272423959135   0.319659848119610; ...
%    0.259915542988848   0.040119112580877   0.118870104700149   0.318166564415535; ...
%    0.259915542988848   0.040119112580877   0.118870104700149   0.318166564415535; ...
%    0.259915542988848   0.040119112580877   0.118870104700149   0.318166564415535; ...
%    0.255288611565874   0.039291386436509   0.117740517031211   0.315608782626264; ...
%    0.255288611565874   0.039291386436509   0.117740517031211   0.315608782626264; ...
%    0.255288611565874   0.039291386436509   0.117740517031211   0.315608782626264; ...
%    0.253077228582162   0.038915776423707   0.117236842393907   0.314493296400121; ...
%    0.250885524366164   0.038451814183913   0.116593133277828   0.313875661524303; ...
%    0.250885524366164   0.038451814183913   0.116593133277828   0.313875661524303; ...
%    0.250885524366164   0.038451814183913   0.116593133277828   0.313875661524303; ...
%    0.246190591369588   0.037681622951246   0.115605679096065   0.312874662727944; ...
%    0.246190591369588   0.037681622951246   0.115605679096065   0.312874662727944; ...
%    0.246190591369588   0.037681622951246   0.115605679096065   0.312874662727944; ...
%    0.241662499635054   0.036953307832665   0.114723196550584   0.312874662727944; ...
%    0.241662499635054   0.036953307832665   0.114723196550584   0.312874662727944; ...
%    0.241662499635054   0.036953307832665   0.114723196550584   0.312874662727944; ...
%    0.239395320127948   0.036477276629561   0.114007240248929   0.312553429191163; ...
%    0.237290669216841   0.036201405340191   0.113617037531666   0.312170113781730; ...
%    0.237290669216841   0.036201405340191   0.113617037531666   0.312170113781730; ...
%    0.237290669216841   0.036201405340191   0.113617037531666   0.312170113781730; ...
%    0.232364076035615   0.035505715337072   0.112752160063614   0.309590255428917; ...
%    0.232364076035615   0.035505715337072   0.112752160063614   0.309590255428917; ...
%    0.232364076035615   0.035505715337072   0.112752160063614   0.309590255428917; ...
%    0.228534098880028   0.034867023710547   0.111927185214636   0.308242553037773; ...
%    0.228534098880028   0.034867023710547   0.111927185214636   0.308242553037773; ...
%    0.228534098880028   0.034867023710547   0.111927185214636   0.308242553037773; ...
%    0.226638011073060   0.034581309791598   0.111461365328763   0.307874472943544; ...
%    0.224504626209491   0.034264788828094   0.110912039765322   0.307170779306988; ...
%    0.224504626209491   0.034264788828094   0.110912039765322   0.307170779306988; ...
%    0.224504626209491   0.034264788828094   0.110912039765322   0.307170779306988; ...
%    0.220314527633718   0.033832633423395   0.110056553294573   0.306028258694503; ...
%    0.220314527633718   0.033832633423395   0.110056553294573   0.306028258694503; ...
%    0.220314527633718   0.033832633423395   0.110056553294573   0.306028258694503; ...
%    0.216454044326266   0.033336234609373   0.109251108071679   0.304162133065127; ...
%    0.216454044326266   0.033336234609373   0.109251108071679   0.304162133065127; ...
%    0.216454044326266   0.033336234609373   0.109251108071679   0.304162133065127; ...
%    0.214244247200849   0.033051973902043   0.108809589530542   0.303655137962413; ...
%    0.212436498178132   0.032887385624195   0.108484598104655   0.303541151868717; ...
%    0.212436498178132   0.032887385624195   0.108484598104655   0.303541151868717; ...
%    0.212436498178132   0.032887385624195   0.108484598104655   0.303541151868717; ...
%    0.207981004485707   0.032467509016484   0.107857047287701   0.302692130198524; ...
%    0.207981004485707   0.032467509016484   0.107857047287701   0.302692130198524; ...
%    0.207981004485707   0.032467509016484   0.107857047287701   0.302692130198524; ...
%    0.203753754727009   0.032086235263398   0.106987373163489   0.301644767667063; ...
%    0.203753754727009   0.032086235263398   0.106987373163489   0.301644767667063; ...
%    0.203753754727009   0.032086235263398   0.106987373163489   0.301644767667063; ...
%    0.202288705366302   0.031953210658709   0.106787567039540   0.300731693768507; ...
%    0.200424236606059   0.031682976392504   0.106435846974253   0.299650041654141; ...
%    0.200424236606059   0.031682976392504   0.106435846974253   0.299650041654141; ...
%    0.200424236606059   0.031682976392504   0.106435846974253   0.299650041654141; ...
%    0.196866890562020   0.031275265929404   0.105581996291278   0.297883134864118; ...
%    0.196866890562020   0.031275265929404   0.105581996291278   0.297883134864118; ...
%    0.196866890562020   0.031275265929404   0.105581996291278   0.297883134864118; ...
%    0.193338973966089   0.031008381840796   0.105045656632710   0.296501211300408; ...
%    0.193338973966089   0.031008381840796   0.105045656632710   0.296501211300408; ...
%    0.193338973966089   0.031008381840796   0.105045656632710   0.296501211300408; ...
%    0.191499429761472   0.030830556586173   0.104650332453552   0.296501211300408];
    
	SS=load('mediaPNN.mat');
    mediaPNN=SS.mediaPNN;

    rrd1n  = length(rrd1ms);
    
    pnn   = 10:1:150;
    pnnMi = zeros(1, length(pnn));
    for pnni = 1:length(pnn)
        NN50 =sum(rrd1ms>pnn(pnni)); % > 50 ms... las medidas estn en segundos
        pNN50=NN50/rrd1n;
        pnnMi(pnni) = (pNN50);
    end  

    
    da = mydtw(pnnMi, mediaPNN(1, :)); % Distance to the mean Atrial Curve
    dn = mydtw(pnnMi, mediaPNN(2, :)); % Distance to the mean Normal Curve
    do = mydtw(pnnMi, mediaPNN(3, :)); % Distance to the mean Others Curve
    dp = mydtw(pnnMi, mediaPNN(4, :)); % Distance to the mean Noise  Curve
    
    f = [da, dn, do, dp];
end


function [ ecg_ok ] = Filtra_Artefactos( ecg, Fs )
%FILTRAARTEFACTOS Filtra los artefactos que puede tener una senyal ECG.
%   De momento simplemente filtra los outliers que tiene la senyal.
%   Esta funcin se llama desde el script Filtra_LineaBase. Para un uso
%   ptimo, mejor llamar a la funcin Filtra_LineaBase.

% INPUTS
%         ecg: Senyal a filtrar sus artefactos. Vector o Matriz de senyales
%          Fs: Frecuencia de muestreo
    
    ecg_ok = ecg;
    
    % Filtramos outliers segundo a segundo, tanto en mnimos como en mximos
    N_MUESTRAS       = length(ecg);
    winStep          = int32(Fs/2);
    iIni             = int32(1);
    iFin             = winStep;
    outliers_indexes = [];
    
    % Por si la senyal es menor que la ventana
    if iFin > N_MUESTRAS
        iFin = N_MUESTRAS;
    end
    
    mins = [];
    maxs = [];
    
    % Obtenemos los mximos y los mnimos segn una ventana de tiempos
    while iFin <= N_MUESTRAS
        
        if iFin + winStep > N_MUESTRAS
            iFin = N_MUESTRAS;
        end
        
        senyal = ecg(iIni: iFin);
        
        mins = [mins; min(senyal)];
        maxs = [maxs; max(senyal)];
        
        iIni = iIni + winStep;
        iFin = iFin + winStep;
    end
    
    % Obtenemos los umbrales
    median_max  = median(maxs);
    median_min  = median(mins);
    std_max     = std(maxs);    
    std_min     = std(mins);
    
    % Necesitamos saber si el R es negativo o positivo
    if abs(median_max) > abs(median_min)
        coef_up = 4;
        coef_dn = 5;
    else
        coef_up = 5;
        coef_dn = 4;
    end
    
    
    % 1 - Detectamos los outliers
    umbral_up = median_max + (std_max * coef_up);
    umbral_dn = median_min - (std_min * coef_dn);
    
    ind_up = find(ecg > umbral_up);
    ind_dn = find(ecg < umbral_dn);
    outliers_indexes = sort([ind_up; ind_dn]);
    
    
    
    % 2 - Ponemos a zero los tramos donde los outliers estn juntos    
    nOutliers = length(outliers_indexes);
    
    % Ponemos a cero los outliers
    if nOutliers >= 1
        ecg_ok(outliers_indexes) = 0;    
    end
    
    for i = 1 : nOutliers
        index = outliers_indexes(i);
        value = ecg(index);
        
        signo = sign(value);
        j = index-1;
        while j >= 1 && sign(ecg(j)) == signo
            ecg_ok(j) = 0;
            j = j - 1;
        end        
        
        j = index+1;
        while j <= N_MUESTRAS && sign(ecg(j)) == signo
            ecg_ok(j) = 0;
            j = j + 1;
        end
    end
    
    % Ponemos a cero los tramos de senyal que tengan outliers muy cercanos
    if nOutliers > 1
        
        min_win = int32(Fs/2);
        for i = 1 : nOutliers-1
            iIni = outliers_indexes(i);
            iFin = outliers_indexes(i+1);
            
            % Si estn muy cerca, ese tramo lo dejamos a cero
            if iFin-iIni <= min_win
                ecg_ok(iIni:iFin) = 0;
            end
        end
        
    end
    
end


function d=mydtw(s,t,w)
% s: signal 1, size is ns*k, row for time, colume for channel 
% t: signal 2, size is nt*k, row for time, colume for channel 
% w: window parameter
%      if s(i) is matched with t(j) then |i-j|<=w
% d: resulting distance

    if nargin<3
        w=Inf;
    end

    ns=size(s,1);
    nt=size(t,1);
    if size(s,2)~=size(t,2)
        warning('Error in dtw(): the dimensions of the two input signals do not match.');
        d = 100000;
        return;
    end
    w=max(w, abs(ns-nt)); % adapt window size

    %% initialization
    D=zeros(ns+1,nt+1)+Inf; % cache matrix
    D(1,1)=0;

    %% begin dynamic programming
    for i=1:ns
        for j=max(i-w,1):min(i+w,nt)
            oost=norm(s(i,:)-t(j,:));
            D(i+1,j+1)=oost+min( [D(i,j+1), D(i+1,j), D(i,j)] );

        end
    end
    d=D(ns+1,nt+1);

end
