function [f] = getChallengeFeatures3(Y, Fs)


    [ Y ] = Filtra_Artefactos( Y, Fs );

    % Get qrs index - Este detector funciona mejor que el de Jaume
    [ ~, qrs_indices ] = getQRS( Y, Fs );
    QRSms  = (qrs_indices / Fs)*1000; % Posicin de los QRS en segundos
    rr     = diff(QRSms); % As est en ms 
    
% % %     [~, ~, QRS]=QRSdelineationHilbert(Y, Fs);
% % %      rr=diff(QRS')/Fs;
    
    
     [rr] = Filter_Outliers(rr);  % Mejores resultados filtrando      
      
      ff = getChallengeFeaturesAux(qrs_indices, length(Y)); %% 44 Features
      
      
      
        % Combinacin correcta
        pf = getPoincareFeatures(rr); % 4 features
        lf = getLorenzFeatures(rr);   % 8 features


        rrd1 = diff(rr);
        rrd2 = diff(rrd1);
    % Todas estas son las ptimas
     f0    = getMuSgKuSk(rr);             % Todas estas las medidas aportan informacin
     f1    = getMuSgKu(rrd1);             % Filtramos media y proporcion, las dems son las que mejor resultado dan en conjunto
     f2    = getSgKu(rrd2);               % Filtramos media y proporcin, las dems son las que mejor resultado dan en conjunto
     frr   = [f0, f1, f2];                % 9 features
     fcx   = getRRComplexFeatures(rr);    % 2 features
     ppc   = getPPC(Y, Fs, qrs_indices);  % 1 features - No mejora significativamente     
% %      frara = getRara(Y, qrs_indices);     % 4 features
% % 
% %      fhd1 = getRRd1HistFeatures(rr);      % 16 features
% %      fhd2 = getRRd2HistFeatures(rr);      % 13 features
% %      fphs = getPatronHistFeatures(Y, Fs); % 9 features
      
     %f    = [ff, fcx, frr, pf, lf, ppc, frara, fhd1, fhd2, fphs];
     f    = [ff, fcx, frr, pf, lf, ppc];
     
%      size(ff)
%      size(fcx)
%      size(frr)
%      size(pf)
%      size(lf)

end



function [f] = getChallengeFeaturesAux(rindx, n) % 44 Features


    Fs    = 300;
    QRSms = (rindx / Fs)*1000; % Posicin de los QRS en mili-segundos
    
    %rindx
    %n = length(y);
    win = 2400;
    ste = 1200; %1200;
    
    M = [];
  
    for w = 1 : ste: n-win
        start = w;
        stop  = start+win;
        
        %yy = Y(start:stop);
        
        idx = (rindx >= start & rindx <= stop);
        qqq = QRSms(idx);
        rr  = diff(qqq);
        
        if length(rr) > 2
            M = [M; getChallengeFeaturesI(rr)];
        end

    end    
    
    [n, ~] = size(M);
    
    if n == 0
        f = zeros(1, 11*4); % 11 features each
    elseif n == 1
        f = [M, M, M, zeros(1, 11)];
    else
        f = [nanmin(M), nanmax(M), nanmean(M), nanstd(M)];
    end   

end
    

function [ features ] = getChallengeFeaturesI( rr )
    
   %   rr = Filter_Outliers(rr);  % Mejores resultados filtrando
    rrd1 = diff(rr, 1); % Poincar
    rrd2 = diff(rr, 2); % Lorenz
  


    % Combinacin correcta
    pf        = getPoincareFeatures(rr);
  %  lf        = getLorenzFeatures(rr);


    % Todas estas son las ptimas
    f0  = getMuSgKu(rr);          % Todas estas las medidas aportan informacin
    f1  = getSgKu(rrd1);          % Filtramos media y proporcion, las dems son las que mejor resultado dan en conjunto
    f2  = getSgKu(rrd2);          % Filtramos media y proporcin, las dems son las que mejor resultado dan en conjunto
    frr = [f0, f1, f2];                           % Combinacin ptima de variables
    %fcx = getRRComplexFeatures(rr);               %fcx = fcx(1); % Nos quedamos slo con la entropia()

    %ppc = getPPC(Y, 300);%, qrs_indices);    % No mejora significativamente
% %     rr
% % pf
% % frr
    
    %features  = [frr, pf, lf, fcx];
    features  = [frr, pf];

end



function [ x, filter, nout ] = Filter_Outliers( x )

    % Umbrales para outliers
    m = median(x);
    s = std(x);
    
    th_up = m + (3.0 * s);
    th_dn = m - (3.0 * s);
    
    filter    = x<th_dn | x>th_up;
    nout      = sum(filter);
    x(filter) = [];

end


function [f] = getRRd1HistFeatures(rr)

    rrd1 = diff(rr);
    
    bins = -500:50:500;
    
    f = hist(rrd1, bins);
    f = f ./sum(f);
    
    
    % bestF1( 4 2): 0.638221 [0.635838, 0.813246, 0.465580, 0.275229] 
    % bestF1( 4 2 17 5 16): 0.632829 [0.632530, 0.814670, 0.451287, 0.213904] 
    % bestF1( 4 2 17 5 16 12 13 1 19): 0.620508 [0.634146, 0.815466, 0.411911, 0.347107] 
    
    % Feature selection (por experimentacion)
    filtro    = [2 4 5 16 17]; 
    f(filtro) = [];
    
end


function [f] = getRRd2HistFeatures(rr)

    rrd2 = diff(rr, 2);
    
    bins = -200:20:200;
    
    f = hist(rrd2, bins);
    f = f ./sum(f);
    
    
% % bestF1( 10 3 14): 0.604350 [0.544629, 0.798535, 0.469885, 0.151163] 
% % bestF1( 10 3 14 2): 0.612217 [0.565217, 0.804204, 0.467231, 0.353791] 
% % bestF1( 10 3 14 16): 0.612469 [0.558966, 0.807644, 0.470798, 0.293333] 
% % bestF1( 10 3 14 16 8 12 7 1): 0.612706 [0.572581, 0.790707, 0.474832, 0.088050] 
% % bestF1( 10 3 14 16 8 12 7 4): 0.619707 [0.575163, 0.800609, 0.483347, 0.025641] 
% % bestF1( 10 3 14 16 8 12 7 5): 0.620980 [0.568862, 0.799472, 0.494606, 0.025478] 
% % bestF1( 10 3 14 16 8 12 7 5 20 2 4): 0.604375 [0.566372, 0.806717, 0.440037, 0.210526] 
% % bestF1( 10 3 14 16 8 12 7 5 20 2 13): 0.612392 [0.585106, 0.801683, 0.450385, 0.296651] 
% % bestF1( 10 3 14 16 8 12 7 5 20 2 13 9 6 15 4): 0.609721 [0.559297, 0.799634, 0.470233, 0.173410] 
    
    % Feature selection (por experimentacion)
    filtro    = [10 3 14 16 8 12 7 5]; % 13 features
    f(filtro) = [];
    
end

function [f] = getPatronHistFeatures(Y, Fs)

    msOffset = 80;
    patron = getQRS_Pattern3(Y, Fs, msOffset);
    
    v = Scale01( patron, true ); %[ y ] = Scale01( y, restar_DC_flag )
    bins = -0.5:0.05:0.5;

%     hist(dp, bins);
    f = hist(v, bins);
    f = f ./sum(f);
    
    
% % bestF1(No filter):                                   0.321767 [0.016304, 0.751315, 0.197682, 0.054645] 
% % bestF1( 5 4):                                        0.376216 [0.027100, 0.739293, 0.362254, 0.047904]  
% % bestF1( 5 4 14 17 7 12 6):                           0.361912 [0.021918, 0.744066, 0.319752, 0.050314] 
% % bestF1( 5 4 14 17 7 12 18):                          0.374449 [0.065217, 0.749396, 0.308732, 0.013245] 
% % bestF1( 5 4 14 17 7 12 18 21 2):                     0.346579 [0.005900, 0.747194, 0.286645, 0.000000] 
% % bestF1( 5 4 14 17 7 12 18 21 11):                    0.353581 [0.005814, 0.752692, 0.302237, 0.036810] 
% % bestF1( 5 4 14 17 7 12 18 21 11 6 13):               0.347387 [0.000000, 0.747821, 0.294340, 0.013072] 
% % bestF1( 5 4 14 17 7 12 18 21 11 6 13 15):            0.349713 [0.000000, 0.748040, 0.301098, 0.000000] 
% % bestF1( 5 4 14 17 7 12 18 21 11 6 13 19):            0.352690 [0.005865, 0.745551, 0.306653, 0.025974] 
% % bestF1( 5 4 14 17 7 12 18 21 11 6 13 19 15 20 3):    0.313532 [0.000000, 0.744421, 0.196175, 0.012903] 
% % bestF1( 5 4 14 17 7 12 18 21 11 6 13 19 15 20 16):   0.319848 [0.000000, 0.747091, 0.212454, 0.000000] 
% % bestF1( 5 4 14 17 7 12 18 21 11 6 13 19 15 20 16 1): 0.322940 [0.000000, 0.739726, 0.229095, 0.000000] 
% % bestF1( 5 4 14 17 7 12 18 21 11 6 13 19 15 20 16 2): 0.323987 [0.000000, 0.742662, 0.229299, 0.000000] 
% % bestF1( 5 4 14 17 7 12 18 21 11 6 13 19 15 20 16 3): 0.332822 [0.000000, 0.745202, 0.253265, 0.000000] 
    
    % Feature selection (por experimentacion)
    filtro    = [5 4 14 17 7 12 18 21 11 6 13 19]; 
    f(filtro) = []; % 9 features
    
    
    
end


function [results] = getRRComplexFeatures(rr)

    
    % Antes Features 1
    entRR=shannonEntropy(rr);
    
    % Antes Feature 2 (lzcrr)
    aux = rr>median(rr);
    
    if length(aux) < 3
        lzcrr = entRR;
    else
        lzcrr=calc_lz_complexity(aux, 'exhaustive', 1);    
    end 

    results = [entRR, lzcrr];    

end

function [ppc] = getPPC(y, Fs, qrs_idx)

    if nargin < 3
        qrs_idx = [];
    elseif length(qrs_idx) < 3
        ppc = 1;
        return;        
    end
    
    % Antes Feature 5
    
    % Test if it is a Noisy Record
    [~,nQRS]=getQRSpattern(y', qrs_idx, 1200, Fs);
    ppc=length(nQRS)/sum(nQRS);

end

function [ values ] = getPoincareFeatures( rr ) %% rr ha de estar en ms

    if isempty(rr)
        values = ones(1, 4);
        return;
    end

% % % %     %Poincare plot
% % % %     xp=rr(1:end-1);
% % % %     xm=rr(2:end);
    rrd1 = diff(rr);
% % % % 
% % % %     %SD1
% % % %     SD1 = std(xp-xm)/sqrt(2);    
% % % % 
% % % %     %SD2
% % % %     SD2 = std(xp+xm)/sqrt(2);
% % % %     
% % % % 
% % % %     %SDRR
% % % %     SDRR=sqrt(SD1^2+SD2^2)/sqrt(2);
    
    % RMSSD (Antes Feature 6)
    RMSSD=sqrt(mean(rrd1.^2));
    
    % PNN50 (Antes Features 4)
    n    = length(rrd1);
    NN25 = sum(rrd1>25);
    NN50 = sum(rrd1>50); % > 50 ms... las medidas estn en segundos
    NN75 = sum(rrd1>75);
    pNN25=NN25/n;
    pNN50=NN50/n;
    pNN75=NN75/n;
    
    % https://marcusvollmer.github.io/HRV/files/paper.pdf
    %SDNN = sqrt(mean((rr-mean(rr)).^2)) % Esto es la SD del rr

    %values = [SD1, SD2, SDRR, SD2/SD1, RMSSD, pNN50];

    values = [RMSSD, pNN25, pNN50, pNN75];
    
end

function [results] = getLorenzFeatures(rr)
    
    if isempty(rr) || length(rr) < 3
        results = zeros(1, 8);
        return;
    end

    n     = length(rr);
    x     = rr(1:end-1);
    y     = rr(2:end);
    theta = atand(x ./ y);
    li    = sqrt(x.^2 + y.^2); % Suma de distancias al origen (sdo)
    L     = mean(li);
    VAI   = sum(abs(theta-45))./(n-1);
    VLI   = sqrt(sum((li-L).^2))./(n-1);
    
    rrd1 = diff(rr);
    x    = rrd1(1:end-1);
    y    = rrd1(2:end);
    
    % Suma de distancias al origen
    sdo = sqrt(x.^2 + y.^2); 
   
    % Suma de distancias entre puntos consecutivos
    sdp = sqrt((x(1:end-1)-x(2:end)).^2 + (y(1:end-1)-y(2:end)).^2);
    
    % Diferencias entre distancias de 3 en 3 puntos, con ventana de 1
    dife = sqrt((sdp(1:end-1) - sdp(2:end)).^2);
    
    
    results = [VAI, VLI, getMuSg(sdo), getMuSg(sdp), getMuSg(dife)];
    %results = [VAI, VLI, std(sdo), std(sdp), std(dife)];
end

function [s] = getMu(v)
    if isempty(v), s = 0;
    else,          s = nanmean(v);
    end
end

function [s] = getMuSg(v)
    if isempty(v), s = [0, 0];
    else,          s = [nanmean(v), nanstd(v)];
    end
end

function [s] = getSgKu(v)
    if isempty(v), s = [0, 0];
    else,          s = [nanstd(v), kurtosis(v)];
    end
end

function [s] = getMuSgKu(v)
    if isempty(v), s = [0, 0, 0];
    else,          s = [nanmean(v), nanstd(v), kurtosis(v)];
    end
end

function [s] = getMuSgKuSk(v)
   
    if isempty(v)
        s = [NaN, NaN, NaN, NaN];
    else        
        s = [nanmean(v), nanstd(v), kurtosis(v), skewness(v)];
    end
    
    %s(1) = mean(v);
    %s(2) = std(v);
    %s(3) = kurtosis(v);
    %s(4) = skewness(v);
    %s(5) = moment(v, 3);
    %s(5) = median(v) / s(1);
    %s(6) = mode(v) / s(1);

end

function [ y ] = BandFilter( x, Fs, Fc1, Fc2 )
%FILTRAPBANDA Aplica a la entrada un filtro Pasa Banda
%
% INPUTS
%    x: Vector o Matriz de entrada de tamao (SAMPLES x CHANNELS)
%   Fs: Frecuencia de Muestreo
%  Fc1: Frecuencia de Corte 1
%  Fc2: Frecuencia de Corte 2
%
% OUTPUTS
%   y: Vector o Matriz resultado de filtrar con los parmetros de entrada
    
    
    rp = 3;
    rs = 60;
    
    if Fc2-Fc1 < 5
        rs = 40;
    end

    Fn    = Fs/2;
    w1    = Fc1/Fn;
    w2    = Fc2/Fn;
     n    = buttord(w1, w2, rp, rs);
    wn    = [w1 w2];
    [b,a] = butter(n, wn, 'bandpass');
    
    y = filtfilt(b, a, x);

end

function [f] = getRara(Y, rindx)

    values1 = [];
    values2 = [];
    %s = 0;
    %n = 0;
    
    %Y = smooth(Y);
    
    for i = 2 : length(rindx)-1
        y1 = Y(rindx(i-1): rindx(i));
        y2 = Y(rindx(i): rindx(i+1));
        
        n1 = round(length(y1));
        n2 = round(length(y2));        
        
        p1 = sum(diff(sign(diff(y1, 1))) ~= 0);
        p2 = sum(diff(sign(diff(y2, 1))) ~= 0);
        
        p3 = sum(diff(sign(diff(y1, 2))) ~= 0);
        p4 = sum(diff(sign(diff(y2, 2))) ~= 0);
        
        
        %15 muestras = 50 ms
        
        values1(i) = sqrt((((p1) - (p2))/(n1+n2))^2);
        values2(i) = sqrt((((p3) - (p4))/(n1+n2))^2);
    end
    
    if isempty(values1)
        f = [0, 0, 0, 0];
    else    
        f = [nanmean(values1), nanstd(values1), nanmean(values2), nanstd(values2)];
    end

end

