function [f] = getChallengeFeatures2(Y, Fs)


    [ Y ] = Filtra_Artefactos( Y, Fs );

    % Get qrs index - Este detector funciona mejor que el de Jaume
    [ ~, qrs_indices ] = getQRS( Y, Fs );
    QRS  = (qrs_indices / Fs); % Posicin de los QRS en segundos
    rr   = diff(QRS)*1000; % As est en ms %*Fs; %%%% quitar el Fs... para dejarlo en segundos
    
% % %     [~, ~, QRS]=QRSdelineationHilbert(Y, Fs);
% % %      rr=diff(QRS')/Fs;
    
    
     [rr] = Filter_Outliers(rr);  % Mejores resultados filtrando
      
      
      ff = getChallengeFeaturesAux(qrs_indices, length(Y));
      
      %ff = ff([2, 4, 9, 18, 27]);
      
% % % % %       ff = ff([2, 9, 18, 27]);
      
      
        % Combinacin correcta
        pf        = getPoincareFeatures(rr);
        lf        = getLorenzFeatures(rr);


        rrd1 = diff(rr);
        rrd2 = diff(rrd1);
    % Todas estas son las ptimas
     f0  = getStats(rr);  % f0 = f0(2:3);                        % Todas estas las medidas aportan informacin
     f1  = getStats(rrd1); f1 = f1(1:3);           % Filtramos media y proporcion, las dems son las que mejor resultado dan en conjunto
     f2  = getStats(rrd2); f2 = f2(2:3);           % Filtramos media y proporcin, las dems son las que mejor resultado dan en conjunto
     frr = [f0, f1, f2];                           % Combinacin ptima de variables
    fcx = getRRComplexFeatures(rr); %fcx = fcx(1); % Nos quedamos slo con la entropia()
    %features  = [frr, pf, lf];
     ppc = getPPC(Y, Fs, qrs_indices);    % No mejora significativamente
     
      [frara] = getRara(Y, qrs_indices);
% %      f = [f, 2-nout];
      
      f = [ff, fcx, frr, pf, lf, ppc, frara];% ./ mean(rr);
      %f = [frr, fcx, lf];
      %f = [f, ppc];

end

function [f] = getChallengeFeaturesAux(rindx, n)


    Fs   = 300;
    QRS  = (rindx / Fs); % Posicin de los QRS en segundos
    
    %rindx
    %n = length(y);
    win = 2400;
    ste = 1200; %1200;
    
    M = [];
  
    for w = 1 : ste: n-win
        start = w;
        stop  = start+win;
        
        %yy = Y(start:stop);
        
        idx = (rindx >= start & rindx <= stop);
        qqq = QRS(idx);
        rr  = diff(qqq);
        
        if length(rr) > 2
            M = [M; getChallengeFeaturesI(rr)];
        end

    end
    
    
    [n, ~] = size(M);
    
    if n == 0
        f = zeros(1, 27);
    elseif n == 1
        f = [M, M, M];
    else
        f = [nanmin(M), nanmax(M), nanmean(M)];%, nanstd(M)];
    end
    
    
    
    

    

end
    

function [ features ] = getChallengeFeaturesI( rr )

    
   
    
   %   rr = Filter_Outliers(rr);  % Mejores resultados filtrando
    rrd1 = diff(rr, 1); % Poincar
    rrd2 = diff(rr, 2); % Lorenz
  


    % Combinacin correcta
    pf        = getPoincareFeatures(rr);
  %  lf        = getLorenzFeatures(rr);


    % Todas estas son las ptimas
    f0  = getStats(rr);   f0 = f0(1:3);          % Todas estas las medidas aportan informacin
    f1  = getStats(rrd1); f1 = f1(2:3);           % Filtramos media y proporcion, las dems son las que mejor resultado dan en conjunto
    f2  = getStats(rrd2); f2 = f2(2:3);           % Filtramos media y proporcin, las dems son las que mejor resultado dan en conjunto
    frr = [f0, f1, f2];                           % Combinacin ptima de variables
    %fcx = getRRComplexFeatures(rr);               %fcx = fcx(1); % Nos quedamos slo con la entropia()

    %ppc = getPPC(Y, 300);%, qrs_indices);    % No mejora significativamente
% %     rr
% % pf
% % frr
    
    %features  = [frr, pf, lf, fcx];
    features  = [frr, pf];

end



function [ x, filter, nout ] = Filter_Outliers( x )

    % Umbrales para outliers
    m = median(x);
    s = std(x);
    
    th_up = m + (3.0 * s);
    th_dn = m - (3.0 * s);
    
    filter    = x<th_dn | x>th_up;
    nout      = sum(filter);
    x(filter) = [];

end






function [results] = getRRComplexFeatures(rr)

    
    % Antes Features 1
    entRR=shannonEntropy(rr);
    
    % Antes Feature 2 (lzcrr)
    aux = rr>median(rr);
    
    if length(aux) < 3
        lzcrr = entRR;
    else
        lzcrr=calc_lz_complexity(aux, 'exhaustive', 1);    
    end
 

    results = [entRR, lzcrr];
    

end

function [ppc] = getPPC(y, Fs, qrs_idx)

    if nargin < 3
        qrs_idx = [];
    elseif length(qrs_idx) < 3
        ppc = 1;
        return;
        
    end
    
    % Antes Feature 5
    
    % Test if it is a Noisy Record
    [~,nQRS]=getQRSpattern(y', qrs_idx, 1200, Fs);
    ppc=length(nQRS)/sum(nQRS);

end

function [ values ] = getPoincareFeatures( rr )

    if isempty(rr)
        values = ones(1, 2);
        return;
    end

% % % %     %Poincare plot
% % % %     xp=rr(1:end-1);
% % % %     xm=rr(2:end);
    rrd1 = diff(rr);
% % % % 
% % % %     %SD1
% % % %     SD1 = std(xp-xm)/sqrt(2);    
% % % % 
% % % %     %SD2
% % % %     SD2 = std(xp+xm)/sqrt(2);
% % % %     
% % % % 
% % % %     %SDRR
% % % %     SDRR=sqrt(SD1^2+SD2^2)/sqrt(2);
    
    % RMSSD (Antes Feature 6)
    RMSSD=sqrt(mean(rrd1.^2));
    
    % PNN50 (Antes Features 4)
    NN50 =sum(rrd1*1000>50); % > 50 ms... las medidas estn en segundos
    pNN50=NN50/length(rr);
    
    % https://marcusvollmer.github.io/HRV/files/paper.pdf
    %SDNN = sqrt(mean((rr-mean(rr)).^2)) % Esto es la SD del rr

    %values = [SD1, SD2, SDRR, SD2/SD1, RMSSD, pNN50];

    values = [RMSSD, pNN50];
    
end

function [results] = getLorenzFeatures(rr)
    
    if isempty(rr) || length(rr) < 3
        results = zeros(1, 8);
        return;
    end

    n     = length(rr);
    x     = rr(1:end-1);
    y     = rr(2:end);
    theta = atand(x ./ y);
    li    = sqrt(x.^2 + y.^2); % Suma de distancias al origen (sdo)
    L     = mean(li);
    VAI   = sum(abs(theta-45))./(n-1);
    VLI   = sqrt(sum((li-L).^2))./(n-1);
    
    rrd1 = diff(rr);
    x    = rrd1(1:end-1);
    y    = rrd1(2:end);
    
    % Suma de distancias al origen
    sdo = sqrt(x.^2 + y.^2); 
   
    % Suma de distancias entre puntos consecutivos
    sdp = sqrt((x(1:end-1)-x(2:end)).^2 + (y(1:end-1)-y(2:end)).^2);
    
    % Diferencias entre distancias de 3 en 3 puntos, con ventana de 1
    dife = sqrt((sdp(1:end-1) - sdp(2:end)).^2);
    
    
    results = [VAI, VLI, getMuSigma(sdo), getMuSigma(sdp), getMuSigma(dife)];
    %results = [VAI, VLI, std(sdo), std(sdp), std(dife)];
end

function [s] = getMuSigma(v)
    if isempty(v), s = [0, 0];
    else,          s = [mean(v), std(v)];
    end
end

function [s] = getMuSgKu(v)
    if isempty(v), s = [0, 0, 0];
    else,          s = [mean(v), std(v), kurtosis(v)];
    end
end

function [s] = getStats(v)
   
    if isempty(v)
        s = [NaN, NaN, NaN, NaN, NaN];
    else
        mu = mean(v);
        s = [mu, std(v), kurtosis(v), skewness(v), median(v)/mu];
    end
    
    %s(1) = mean(v);
    %s(2) = std(v);
    %s(3) = kurtosis(v);
    %s(4) = skewness(v);
    %s(5) = moment(v, 3);
    %s(5) = median(v) / s(1);
    %s(6) = mode(v) / s(1);

end

function [ y ] = BandFilter( x, Fs, Fc1, Fc2 )
%FILTRAPBANDA Aplica a la entrada un filtro Pasa Banda
%
% INPUTS
%    x: Vector o Matriz de entrada de tamao (SAMPLES x CHANNELS)
%   Fs: Frecuencia de Muestreo
%  Fc1: Frecuencia de Corte 1
%  Fc2: Frecuencia de Corte 2
%
% OUTPUTS
%   y: Vector o Matriz resultado de filtrar con los parmetros de entrada
    
    
    rp = 3;
    rs = 60;
    
    if Fc2-Fc1 < 5
        rs = 40;
    end

    Fn    = Fs/2;
    w1    = Fc1/Fn;
    w2    = Fc2/Fn;
     n    = buttord(w1, w2, rp, rs);
    wn    = [w1 w2];
    [b,a] = butter(n, wn, 'bandpass');
    
    y = filtfilt(b, a, x);

end

function [f] = getRara(Y, rindx)

    values1 = [];
    values2 = [];
    %s = 0;
    %n = 0;
    
    %Y = smooth(Y);
    
    for i = 2 : length(rindx)-1
        y1 = Y(rindx(i-1): rindx(i));
        y2 = Y(rindx(i): rindx(i+1));
        
        n1 = round(length(y1));
        n2 = round(length(y2));
        
        %y1=shannonEntropy(y1);
        %y2=shannonEntropy(y2);
        %m1 = mean(abs(diff(y1)));
        %m2 = mean(abs(diff(y2)));
        
        p1 = sum(diff(sign(diff(y1, 2))) ~= 0);
        p2 = sum(diff(sign(diff(y2, 2))) ~= 0);
        
        p3 = sum(diff(sign(diff(y1, 1))) ~= 0);
        p4 = sum(diff(sign(diff(y2, 1))) ~= 0);
        
        %npos1 = sum(abs(diff(y1))>m1);
        %npos2 = sum(abs(diff(y2))>m2);
        
        %p1 = s1;
        %p2 = s2;
        
        %rv = abs(Y(rindx(i)));
        

        
        %15 muestras = 50 ms
        %y1 = abs(y1(n1:end-10));
        %y2 = abs(y2(10:n2));
        
%         s1 = getMuSigma(y1);
%         s2 = getMuSigma(y2);
%         
        
%         dm = mean(y1) - mean(y2);
%         ds = std(y1) - std(y2);
%         
%         dm = dm^2;
%         ds = ds^2;
%         d  = sqrt(dm + ds);
        
        values1(i) = sqrt((((p1) - (p2))/(n1+n2))^2);
        values2(i) = sqrt((((p3) - (p4))/(n1+n2))^2);% + (y2))^2;
    end
    
    f = [mean(values1), std(values1), mean(values2), std(values2)];

end

