function [ features ] = getChallengeFeatures( Y, Fs )

    % Filtering
    %Y = BandFilter( Y, Fs, 1, 40 ); % Mejores resultados sin filtrar

    % Get qrs index - Este detector funciona mejor que el de Jaume
    [ ~, qrs_indices ] = getQRS( Y, Fs );
    QRS  = (qrs_indices / Fs); % Posicin de los QRS en segundos
    rr   = diff(QRS)*Fs; %%%% quitar el Fs... para dejarlo en segundos
    
% % %     [~, ~, QRS]=QRSdelineationHilbert(Y, Fs);
% % %      rr=diff(QRS')/Fs;
    
    
    [rr, nout] = Filter_Outliers(rr);  % Mejores resultados filtrando
    rrd1 = diff(rr, 1); % Poincar
    rrd2 = diff(rr, 2); % Lorenz
    
% QRS
% rr
% qrs_indices
% pause
    


    % Combinacin correcta
    pf        = getPoincareFeatures(rr);
    lf        = getLorenzFeatures(rr);


    % Todas estas son las ptimas
    f0  = getStats(rr);   %f0 = f0(2:3);                        % Todas estas las medidas aportan informacin
    f1  = getStats(rrd1); f1 = f1(2:3);           % Filtramos media y proporcion, las dems son las que mejor resultado dan en conjunto
    f2  = getStats(rrd2); f2 = f2(2:3);           % Filtramos media y proporcin, las dems son las que mejor resultado dan en conjunto
    frr = [f0, f1, f2];                           % Combinacin ptima de variables
    fcx = getRRComplexFeatures(rr); %fcx = fcx(1); % Nos quedamos slo con la entropia()
    %features  = [frr, pf, lf];


% % 
     
     rar = getRara2(Y, qrs_indices);
     ppc = getPPC(Y, Fs, qrs_indices);    % No mejora significativamente
% la deteccin de ruido
% % 
% % 
% %     features  = [fcx, rar, ppc];

    %features  = [frr, pf, lf, fcx];
    
    features  = [frr, rar, pf, lf, fcx, ppc];

end

function [ x, num_outliers ] = Filter_Outliers( x )

    % Umbrales para outliers
    m = median(x);
    s = std(x);
    
    th_up = m + (3.0 * s);
    th_dn = m - (3.0 * s); 
    
    f = x<th_dn | x>th_up;
    
    num_outliers = sum(f);
    
    x(f) = [];

end



function [f] = getRara2(y, rindx)

    Fs = 300;
    QRS  = (rindx / Fs); % Posicin de los QRS en segundos
    rr   = diff(QRS);          % quitar el Fs... para dejarlo en segundos
    
    
    n = length(y);
    win = 1800;
    ste = 300; %1200;
    
    max_sigma = -Inf;
    min_sigma = +Inf;
    best_min  = zeros(1, 3);
    best_max  = zeros(1, 3);
    
    for w = 1 : ste: n-win
        start = w;
        stop  = start+win;
        
        idx = (rindx >= start & rindx <= stop);
        qq  = QRS(idx) / Fs;
        rri = diff(qq);
        
        if length(rri) < 4
            continue;
        end
        
        musg = getMuSgKu(rri);
        
        if isnan(musg(3))
            musg(3)=0;
        end
        
        if musg(2) < min_sigma
            min_sigma = musg(2);
            best_min = musg;
        end
        if musg(2) > max_sigma
            max_sigma = musg(2);
            best_max = musg;
        end
        

    end
    
    f = [best_min, best_max];
    
    f(isnan(f)) = 0;
    
    %f = [f(2:3), f(5:6)];

end


function [f] = getRara(Y, rindx)

    values = [];
    %s = 0;
    %n = 0;
    
    for i = 2 : length(rindx)-1
        y1 = Y(rindx(i-1): rindx(i));
        y2 = Y(rindx(i): rindx(i+1));
        
%         s1 = getMuSigma(y1);
%         s2 = getMuSigma(y2);
%         
        
%         dm = mean(y1) - mean(y2);
%         ds = std(y1) - std(y2);
%         
%         dm = dm^2;
%         ds = ds^2;
%         d  = sqrt(dm + ds);
        
        values(i) = dtw(y1, y2); %d 
    end
    
    f = [mean(values), std(values)];

end


function [results] = getRRComplexFeatures(rr)

    
    % Antes Features 1
    entRR=shannonEntropy(rr);
    
    % Antes Feature 2 (lzcrr)
    aux = rr>median(rr);
    
    if length(aux) < 3
        lzcrr = entRR;
    else
        lzcrr=calc_lz_complexity(aux, 'exhaustive', 1);    
    end
 

    results = [entRR, lzcrr];
    

end

function [ppc] = getPPC(y, Fs, qrs_idx)

    if nargin < 3
        qrs_idx = [];
    elseif length(qrs_idx) < 3
        ppc = 1;
        return;
        
    end
    
    % Antes Feature 5
    
    % Test if it is a Noisy Record
    [~,nQRS]=getQRSpattern(y', qrs_idx, 1200, Fs);
    ppc=length(nQRS)/sum(nQRS);

end

function [ values ] = getPoincareFeatures( rr )

    if isempty(rr)
        values = ones(1, 6);
        return;
    end

    %Poincare plot
    xp=rr(1:end-1);
    xm=rr(2:end);
    rrd1 = diff(rr);

    %SD1
    SD1 = std(xp-xm)/sqrt(2);    

    %SD2
    SD2 = std(xp+xm)/sqrt(2);
    

    %SDRR
    SDRR=sqrt(SD1^2+SD2^2)/sqrt(2);
    
    % RMSSD (Antes Feature 6)
    RMSSD=sqrt(mean(rrd1.^2));
    
    % PNN50 (Antes Features 4)
    NN50 =sum(rrd1*1000>50); % > 50 ms... las medidas estn en segundos
    pNN50=NN50/length(rr);
    
    % https://marcusvollmer.github.io/HRV/files/paper.pdf
    %SDNN = sqrt(mean((rr-mean(rr)).^2)) % Esto es la SD del rr

    values = [SD1, SD2, SDRR, SD2/SD1, RMSSD, pNN50];

    %values = [RMSSD, pNN50];
    
end

function [results] = getLorenzFeatures(rr)
    
    if isempty(rr) || length(rr) < 3
        results = zeros(1, 8);
        return;
    end

    n     = length(rr);
    x     = rr(1:end-1);
    y     = rr(2:end);
    theta = atand(x ./ y);
    li    = sqrt(x.^2 + y.^2); % Suma de distancias al origen (sdo)
    L     = mean(li);
    VAI   = sum(abs(theta-45))./(n-1);
    VLI   = sqrt(sum((li-L).^2))./(n-1);
    
    rrd1 = diff(rr);
    x    = rrd1(1:end-1);
    y    = rrd1(2:end);
    
    % Suma de distancias al origen
    sdo = sqrt(x.^2 + y.^2); 
   
    % Suma de distancias entre puntos consecutivos
    sdp = sqrt((x(1:end-1)-x(2:end)).^2 + (y(1:end-1)-y(2:end)).^2);
    
    % Diferencias entre distancias de 3 en 3 puntos, con ventana de 1
    dife = sqrt((sdp(1:end-1) - sdp(2:end)).^2);
    
    
    results = [VAI, VLI, getMuSigma(sdo), getMuSigma(sdp), getMuSigma(dife)];
    %results = [VAI, VLI, std(sdo), std(sdp), std(dife)];
end

function [s] = getMuSigma(v)
    if isempty(v), s = [0, 0];
    else,          s = [mean(v), std(v)];
    end
end

function [s] = getMuSgKu(v)
    if isempty(v), s = [0, 0, 0];
    else,          s = [mean(v), std(v), kurtosis(v)];
    end
end

function [s] = getStats(v)
   
    if isempty(v)
        s = [NaN, NaN, NaN, NaN, NaN];
    else
        mu = mean(v);
        s = [mu, std(v), kurtosis(v), skewness(v), median(v)/mu];
    end
    
    %s(1) = mean(v);
    %s(2) = std(v);
    %s(3) = kurtosis(v);
    %s(4) = skewness(v);
    %s(5) = moment(v, 3);
    %s(5) = median(v) / s(1);
    %s(6) = mode(v) / s(1);

end

function [ y ] = BandFilter( x, Fs, Fc1, Fc2 )
%FILTRAPBANDA Aplica a la entrada un filtro Pasa Banda
%
% INPUTS
%    x: Vector o Matriz de entrada de tamao (SAMPLES x CHANNELS)
%   Fs: Frecuencia de Muestreo
%  Fc1: Frecuencia de Corte 1
%  Fc2: Frecuencia de Corte 2
%
% OUTPUTS
%   y: Vector o Matriz resultado de filtrar con los parmetros de entrada
    
    
    rp = 3;
    rs = 60;
    
    if Fc2-Fc1 < 5
        rs = 40;
    end

    Fn    = Fs/2;
    w1    = Fc1/Fn;
    w2    = Fc2/Fn;
     n    = buttord(w1, w2, rp, rs);
    wn    = [w1 w2];
    [b,a] = butter(n, wn, 'bandpass');
    
    y = filtfilt(b, a, x);

end

