%% Limpieza inicial
clc;
close all;

%% Creacin de variables 
n            = length(grps); % Nmero de muestras
num_features = 11;

% Estructuras a generar
dataset = zeros(n, num_features);
class   = cell(n, 1);
classi  = zeros(n, 1);
headers = {'entRR', 'lzcrr', 'meanRR', 'pNN50', 'ppc', 'RMSSD', 'skewRR', 'sqdev', 'stdRR', 'VAI', 'VLI'};

%% Bucle principal
for i = 1 : n
    
    class{i}       = grps{i};
    dataset(i,  1) = entRR(i);
    dataset(i,  2) = lzcrr(i);
    dataset(i,  3) = meanRR(i);
    dataset(i,  4) = pNN50(i);
    dataset(i,  5) = ppc(i);
    dataset(i,  6) = RMSSD(i);
    dataset(i,  7) = skewRR(i);
    dataset(i,  8) = sqdev(i);
    dataset(i,  9) = stdRR(i);
    dataset(i, 10) = VAI(i);
    dataset(i, 11) = VLI(i);
    
end


%% Creacin del vector de clases en formato numrico
clases = unique(class);
colors = {'r*', 'c*', 'b+', 'go'};
for i = 1 : length(clases)
    idx = strcmp(class, clases{i});
    classi(idx) = i;
end

figure;
for i = 1 : 11
    subplot(3, 4, i);
    boxplot(dataset(:, i), class');
    title(headers{i}, 'Interpreter', 'none');
end

test = zeros(n, 4);
test(classi == 1, 1) = 1;
test(classi == 2, 2) = 1;
test(classi == 3, 3) = 1;
test(classi == 4, 4) = 1;

hay_nan            = sum(isnan(dataset), 2);
filtro             = hay_nan > 0;
fprintf('Clases filtradas: \n');
classi(filtro)
class(filtro)

dataset(filtro, :) = [];
test(filtro, :)    = [];
classi(filtro)     = [];

[n, ~] = size(dataset);
fprintf('Nmero filas filtradas: %d \n', sum(hay_nan>0));
%class{hay_nan > 0}

%%
ff = zeros(n, 1);
for i = 1:1:8400
    ff(i) = 1;
end
cut_point = 4200;%round(n*0.5);
train_i   = ff == 1; %1:cut_point;
test_i    = ff == 0; %cut_point+1 : n;

train_x = dataset(train_i, :);
test_x  = train_x; % dataset(test_i, :);
train_y = test(train_i, :);
test_y  = train_y; %test(test_i, :);


%% Cambiamos el tipo de los datos y normalizamos
[train_x, mu, sigma] = zscore(train_x);
test_x=bsxfun(@minus,   test_x, mu);
test_x=bsxfun(@rdivide, test_x, sigma);
train_y = double(train_y);
test_y  = double(test_y);


