%% Limpieza inicial
clc;
close all;

%% Creacin de variables 
n            = length(database); % Nmero de muestras
num_features = 8; % + 103; % + 103;                % Nmero de caractersticas

% Estructuras a generar
dataset = zeros(n, num_features);
class   = cell(n, 1);
classi  = zeros(n, 1);
headers = {'mean(RR)', 'std(RR)', 'kurt(RR)', 'skew(RR)', 'RMSSD', 'pNN50', 'HRV', 'qrs_pattern_area'};

%% Bucle principal
for i = 1 : n
    
    ST       = database{i};
    class{i} = ST.Info.Clase;
    
    errors = true;
    
    if ~isempty(ST.hrvFeatures.meanRR)
        dataset(i, 1) = ST.hrvFeatures.meanRR;
    end
    if ~isempty(ST.hrvFeatures.stdRR)
        dataset(i, 2) = ST.hrvFeatures.stdRR;
        errors = false;
    end    
    
    if ~isempty(ST.hrvFeatures.kurtRR)
        dataset(i, 3) = ST.hrvFeatures.kurtRR;
    end
    
    if ~isempty(ST.hrvFeatures.skewRR)
        dataset(i, 4) = ST.hrvFeatures.skewRR;
    end
    
    if ~isempty(ST.hrvFeatures.RMSSD)
        dataset(i, 5) = ST.hrvFeatures.RMSSD;
    end
    
    if ~isempty(ST.hrvFeatures.pNN50)
        dataset(i, 6) = ST.hrvFeatures.pNN50;
    end
    
    % HRV --> Parmetro relacionado con la variabilidad del ritmo (std(RR)/mean(RR))
    if ~errors
        dataset(i, 7) = dataset(i, 2) / dataset(i, 1);
    end
    
    % rea del patrn QRS
    dataset(i, 8) = sum(abs(database{i}.Senyales.pattern));
    
    continue;
    
    % Welch de la FA, en frecuencias de 0 a 30 Hz
    filt    = y.SpectralFeatures.freqsAA < 30;
    welchAA = ST.SpectralFeatures.AAperiodogram(filt);
    dataset(i, 9:111)   = welchAA;
    
    
    if(~isempty(ST.SpectralFeatures.AAfft_phase))
        filt    = y.SpectralFeatures.freqsAAfft < 30;    
        phaseAA = ST.SpectralFeatures.AAfft_phase(filt);
        dataset(i, 112:end) = phaseAA;
    end
    
end


%% Creacin del vector de clases en formato numrico
clases = unique(class);
colors = {'r*', 'c*', 'b+', 'go'};
for i = 1 : length(clases)
    idx = strcmp(class, clases{i});
    classi(idx) = i;
end

% figure;
% for i = 1 : 8 
%     subplot(2, 4, i);
%     boxplot(dataset(:, i), class');
%     title(headers{i}, 'Interpreter', 'none');
% end

test = zeros(n, 4);
test(classi == 1, 1) = 1;
test(classi == 2, 2) = 1;
test(classi == 3, 3) = 1;
test(classi == 4, 4) = 1;

hay_nan            = sum(isnan(dataset), 2);
filtro             = hay_nan > 0;
dataset(filtro, :) = [];
test(filtro, :)    = [];
classi(filtro)     = [];

[n, ~] = size(dataset);
fprintf('Nmero filas filtradas: %d \n', sum(hay_nan>0));
%class{hay_nan > 0}

%%
ff = zeros(n, 1);
for i = 1:2:8400
    ff(i) = 1;
end
cut_point = 4200;%round(n*0.5);
train_i   = ff == 1; %1:cut_point;
test_i    = ff == 0; %cut_point+1 : n;

train_x = dataset(train_i, :);
test_x  = dataset(test_i, :);
train_y = test(train_i, :);
test_y  = test(test_i, :);


%% Cambiamos el tipo de los datos y normalizamos
[train_x, mu, sigma] = zscore(train_x);
test_x=bsxfun(@minus,   test_x, mu);
test_x=bsxfun(@rdivide, test_x, sigma);
train_y = double(train_y);
test_y  = double(test_y);


