
%% Limpieza inicial
clc;
close all;

%% Creacin de variables 
n            = length(database); % Nmero de muestras
num_features = 273;                % Nmero de caractersticas

% Estructuras a generar
dataset = zeros(n, num_features);
class   = cell(n, 1);
classi  = zeros(n, 1);
headers = {'nbins',  'mean(Centers)', 'std(Centers)', 'kur(Centers)', 'ske(Centers)', 'pp'  };

max_mV = -Inf;
min_mV = +Inf;
for i = 1 : n
    ST       = database{i};
    class{i} = ST.Info.Clase;
    mx = max(ST.Senyales.ECG); 
    mn = min(ST.Senyales.ECG);
    
    if mx > max_mV, max_mV = mx; end
    if mn < min_mV, min_mV = mn; end
end


%% Creacin del vector de clases en formato numrico
clases = unique(class);
for i = 1 : length(clases)
    idx = strcmp(class, clases{i});
    classi(idx) = i;
end

%% Bucle principal
parfor i = 1 : n
    
    ST       = database{i};
    fprintf('[%4d / %4d] \n', i, n);
    
    [ r, x ] = getNBinsMaxVar( ST.Senyales.ECG, min_mV, max_mV, class{i}, classi(i) );
    dataset(i, :) = x;    
end


%%

figure;
for i = 1 :  num_features
    k=1;
    %for j = i : i+3
    subplot(1, 6, i); %num_features, i);
    boxplot(dataset(:, i), class');
    title(headers{i}, 'Interpreter', 'none');
    k=k+1;
end
return;
    %pause
%end

%%
test = zeros(n, 4);
test(classi == 1, 1) = 1;
test(classi == 2, 2) = 1;
test(classi == 3, 3) = 1;
test(classi == 4, 4) = 1;

test = zeros(n, 2);
test(classi == 1, 1) = 1;
test(classi == 2, 1) = 1;
test(classi == 3, 1) = 1;
test(classi == 4, 2) = 1;



hay_nan            = sum(isnan(dataset), 2);
filtro             = hay_nan > 0;
dataset(filtro, :) = [];
test(filtro, :)    = [];
classi(filtro)     = [];

[n, ~] = size(dataset);
fprintf('Nmero filas filtradas: %d \n', sum(hay_nan>0));
%class{hay_nan > 0}

%%
ff = zeros(n, 1);
for i = 1:2:8400
    ff(i) = 1;
end
cut_point = 4200;%round(n*0.5);
train_i   = ff == 1; %1:cut_point;
test_i    = ff == 0; %cut_point+1 : n;

train_x = dataset(train_i, :);
test_x  = dataset(test_i, :);
train_y = test(train_i, :);
test_y  = test(test_i, :);


%% Cambiamos el tipo de los datos y normalizamos
[train_x, mu, sigma] = zscore(train_x);
test_x=bsxfun(@minus,   test_x, mu);
test_x=bsxfun(@rdivide, test_x, sigma);
train_y = double(train_y);
test_y  = double(test_y);


