function [QRSon,QRSoff,QRS]=QRSdelineationHilbert(sig,fs)

Wp=[12 40]/fs;
Ws=[8 44]/fs;
[n,Wn]=buttord(Wp,Ws,3,10);
[B,A]=butter(n,Wn);
sig_filt=filtfilt(B,A,sig');
sig_filt=sig_filt-mean(sig_filt);
sig_Hil=hilbert(sig_filt);
% plot(sig)
% hold on
% %plot(sig_filt,'r')
% plot(abs(sig_Hil),'r')
[~,QRS]=findpeaks(abs(sig_Hil),'minPeakHeight',prctile(abs(sig_Hil),80),'MinPeakDistance',0.3*fs);
QRS=QRS(QRS>30);
QRS=QRS(QRS<length(sig)-30);
[~,negPeaks]=findpeaks(-abs(sig_Hil));
% plot(QRS,sig(QRS),'ok')
% plot(negPeaks,sig(negPeaks),'^k')
for i=1:length(QRS)
    try
        QRSon(i)=negPeaks(find(negPeaks<QRS(i),1,'last'));
        QRSoff(i)=negPeaks(find(negPeaks>QRS(i),1,'first'));
    catch
        try
            QRSon(i)=find(abs(sig_filt(1:QRS(i)))<0.1*abs(sig_filt(QRS(i))),1,'last');
            QRSoff(i)=QRS(i)-1+find(abs(sig_filt(QRS(i):end))<0.1*abs(sig_filt(QRS(i))),1,'first');
        catch
            QRSon(i)=nan;
            QRSoff(i)=nan;
        end
    end
end
QRSon=QRSon(~isnan(QRSon));
QRSoff=QRSoff(~isnan(QRSon));
% plot(QRSon(~isnan(QRSon)),sig(QRSon(~isnan(QRSon))),'g*')
% plot(QRSoff(~isnan(QRSoff)),sig(QRSoff(~isnan(QRSoff))),'r*')

