function [IMFs,res]=EMD_decomp(sig,n_levels,p,maxiter)

% [IMFs,res]=EMD_decomp(sig,n_levels,p,maxiter)
% Funcin que realiza la descomposicin en modo emprico de n niveles de
% una seal de entrada.

%%INPUTS%%
% sig       -->     Seal a descomponer.
% n_levels  -->     n de niveles de la descomposicin.
% p         -->     Precisin en el clculo de cada nivel (RMSE entre dos   
%                   iteraciones consecutivas).
% maxiter   -->     N mximo de iteraciones en cada nivel.

%%OUTPUTS%%
% IMFs      -->     Funciones de modo intrinseco de cada nivel.
% res       -->     Residuo de la descomposicin.

%%CDIGO%%

l=length(sig);
IMFs=zeros(n_levels,l);
res=sig;

for i=1:n_levels
    [IMFs(i,:),res]=siftingEMD(res,p,maxiter);
end
end