function [ OutSignal ] = RemovOutlieres( InSignal, percentage, direction )
%
% input:
% InSignal: the input signal
% percentage : percentage of the outlieres ]0,1[
% direction:
%                 0 remove outlieres from both tails
%                 1 remove outlieres from left tail
%                 2 remove outlieres from right tail
% output:
%  the same signal replacing the outlieres with the nearest value from the signal,
%  i.e. replace all the outlieres  on the right tail with the maximum non-outlier value; and 
%  replace all the outlieres  on the left tail withthe minimum non-outlier value.
%  
L=length(InSignal);
% uq=unique(InSignal);
% Luq=length(uq);
% H=hist(InSignal,Luq);

percentiles=percentage*L;
percentiles=fix(percentiles);

OutSignal=InSignal;
[~, Indexes ]=sort(OutSignal);

switch direction
    case 0
        %         remove outlieres from both tails
        replaceMinwith=OutSignal(Indexes(percentiles+1));
        replaceMaxwith=OutSignal(Indexes(L-percentiles));
        OutSignal(Indexes(1:percentiles))=replaceMinwith;
        OutSignal(Indexes(L-percentiles+1:L))=replaceMaxwith;
    case 1 
%         remove outlieres from left tail
        replaceMinwith=OutSignal(Indexes(percentiles+1));
        OutSignal(Indexes(1:percentiles))=replaceMinwith;
    case 2
%         remove outlieres from left tail
        replaceMaxwith=OutSignal(Indexes(L-percentiles));
        OutSignal(Indexes(L-percentiles+1:L))=replaceMaxwith;
        end
end

