function [P, Q,S, T ] =PQSTWaves ( QRS,ecg )
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

LQRS=length(QRS);
Lsignal=length(ecg);
P=zeros(1,LQRS);
Q=zeros(1,LQRS);
S=zeros(1,LQRS);
T=zeros(1,LQRS);
df=diff(QRS);
meanwidth=mean(df);
medianwidth=median(df);
interval=min(meanwidth,medianwidth);
interval=fix(interval);
for ii=1:LQRS
    if (ii==1)
        leftEnd=QRS(1)-interval;
        if leftEnd<1
            leftEnd=1;
        end
    else
        leftEnd=(QRS(ii)-QRS(ii-1))/2;
        leftEnd=fix(leftEnd);
        leftEnd=leftEnd+QRS(ii-1);
    end
    if (ii==LQRS)
        rightEnd=QRS(LQRS)+interval;
        if rightEnd>Lsignal
        rightEnd=Lsignal;
        end
    else
        rightEnd=(QRS(ii+1)-QRS(ii))/2;
        rightEnd=fix(rightEnd);
        rightEnd=rightEnd+QRS(ii);
    end
    
    %find Q
    Q(ii)=QRS(ii)-1; %default
    if Q(ii)<1
        Q(ii)=1;
    end
    previousindex=QRS(ii)-1;
    if previousindex<1
        previousindex=1;
    end;
    sgn=ecg(QRS(ii))-ecg(previousindex);
    if sgn~=0
        sgn=sgn/abs(sgn);
    else
        sgn=1;
    end
    for jj=QRS(ii)-1:-1:leftEnd+1
        currentSignal=ecg(jj);
        nextSignal=ecg(jj-1);
        newsign=currentSignal-nextSignal;
        if newsign~=0
            newsign=newsign/abs(newsign);
        else
            newsign=1;
        end
        if newsign~=sgn
            Q(ii)=jj;
            jj=0;
            break;
        end
    end %Q for
   
     %find S
    S(ii)=QRS(ii)+1; %default
    if S(ii)>length(ecg)
        S(ii)=length(ecg);
    end
    nextqrsindex=QRS(ii)+1;
    if nextqrsindex>length(ecg)
        nextqrsindex=length(ecg);
    end
    sgn=ecg(QRS(ii))-ecg(nextqrsindex);
    if sgn~=0
        sgn=sgn/abs(sgn);
    else
        sgn=1;
    end
    for jj=QRS(ii)+1:rightEnd-1
        currentSignal=ecg(jj);
        nextSignal=ecg(jj+1);
        newsign=currentSignal-nextSignal;
        if newsign~=0
            newsign=newsign/abs(newsign);
        else
            newsign=1;
        end
        if newsign~=sgn
            S(ii)=jj;
            jj=rightEnd; %safe gaurd for the break statement
            break;
        end
    end %S for  
   %check to see if r is negative or positive
   positive=1;
   if ecg(QRS(ii))<ecg(QRS(ii)-1) && ecg(QRS(ii))<ecg(QRS(ii)+1)
       positive=0;
   end
   if positive
        [~,indx]=max(ecg(leftEnd:Q(ii)-1));
   else
        [~,indx]=min(ecg(leftEnd:Q(ii)-1));
   end
    if ~isempty(indx)
        P(ii)=indx+leftEnd;
    else
        P(ii)=Q(ii)-1; %default
    end
     if P(ii)<1;
            P(ii)=1;
     end
     if positive
        [~,indx]=max(ecg(S(ii)+1:rightEnd));
     else
          [~,indx]=min(ecg(S(ii)+1:rightEnd));
     end
     if ~isempty(indx)
        T(ii)=indx+S(ii)+1;
     else
         T(ii)=S(ii)+1; %default
     end
     if T(ii)>length(ecg)
         T(ii)=length(ecg);
     end
end % end for all QRS array

end

