function [ h ] = GetFeatures( recordName )
%input record name for the signal example
%   output statistical feature vector 
h=zeros(1,57);
[tm,ecg,fs,siginfo]=rdmat(recordName);

signal=ecg;

[QRS,sign,~] = qrs_detect2(signal',0.25,0.6,fs);

% signal pre-processing ===============================
Lsignal=length(signal);
mid=Lsignal/2;
L1=length(QRS);
    if L1>0
        range=max(QRS)-min(QRS);
    else
        range=0;
    end

if L1<2*Lsignal/1000  || range<mid
   
        newecg=RemovOutlieres2(signal,0.1);
        [QRS,sign,en_thres] = qrs_detect2(newecg',0.25,0.6,fs);
       L1=length(QRS);
    if L1>0
        range=max(QRS)-min(QRS);
    else
        range=0;
    end
    if L1<2*Lsignal/1000  || range<mid
            newecg=RemovOutlieres2(signal,0.25);
            [QRS,sign,en_thres] = qrs_detect2(newecg',0.25,0.6,fs);
            L1=length(QRS);
            if L1>0
                range=max(QRS)-min(QRS);
            else
                range=0;
            end
            if L1<2*Lsignal/1000  || range<mid
                newecg=Normalize01(signal);
                [QRS,sign,en_thres] = qrs_detect2(newecg',0.25,0.6,fs);
                %4th level enhancement
                L1=length(QRS);
                if L1>0
                    range=max(QRS)-min(QRS);
                else
                    range=0;
                end
                if L1<2*Lsignal/1000  || range<mid
                    newecg=RemovOutlieres2(signal,0.25);
                    newecg=Normalize01(newecg);
                    [QRS,sign,en_thres] = qrs_detect2(newecg',0.25,0.6,fs);
                end
                %end 4th level
                %5th level
                     L1=length(QRS);
                    if L1>0
                        range=max(QRS)-min(QRS);
                    else
                        range=0;
                    end
%                     if L1<2*Lsignal/1000  || range<mid
%                          [~,QRS2,~]=pan_tompkin(newecg,fs, 0);
%                          if length(QRS2)>length(QRS)
%                              QRS=QRS2;
%                          end
%                     end
                %end 5th level
            end
    end
end
 
%fix R wave locations
QRS2=FixQRS3(signal,QRS,sign);

if ~isequal(QRS2,QRS)
     QRS=QRS2;
end

% Features exctraction =====================================
R=zeros(1,21);
% PQ=zeros(1,7);
 QS=zeros(1,8);
  DCTs=zeros(1,16);
  peks=zeros(1,5);
QRSRate=0;
PQinterval= 0; QSinterval = 0; Rinterval= 0; STinterval=0; PTinterval=0;
 HistValuesQRS=zeros(1,2);
if length(QRS)>1
    %detect feature points
     [P,Q,S,T]=PQSTWaves(QRS,signal);
     %qrs ratios to signal length
     QRSRate=length(QRS)/length(signal);
     %hist of the valuse of the qrs or stats 
    
     v=signal(QRS);
     v=abs(diff(v));
     HistValuesQRS(1)=min(v);
     HistValuesQRS(2)=max(v);

    %R
    [R , indx]=StatArrayDiff1(QRS,tm);
    QS=StatArrayDiff2(Q,S,tm);
    
     [ PQinterval,  QSinterval, Rinterval, STinterval , PTinterval] = QRSintervals(P,Q,QRS,S,T,tm,indx);
    
     if Rinterval~=0
         PQinterval=PQinterval/Rinterval;
         QSinterval=QSinterval/Rinterval;
         STinterval=STinterval/Rinterval;   
         PTinterval=PTinterval/Rinterval; 
     end
     %dct of fft stats between QRS complexes
         DCTs=DCTFeatures3(signal,QRS);
         %stats of peaks  between QRS sequences 
         peks=PeaksStat(signal,QRS);
    
end
h=[R QS PQinterval  QSinterval  STinterval PTinterval DCTs QRSRate HistValuesQRS peks];%[R QSratios];%[R PQ QS ST];

end

