function [ QRS2 ] = FixQRS3( ecg, QRS, sgn)
%Fix the QRS locations in a signal based on the maximum or minimum  value of ecg based on the sign  of QRS detector
%
%location is dislocated by [-9 9] indexes
if QRS(1)>100;
    QRS2=QRS;
else
    QRS2=QRS(2:end);
end


Lsignal=length(ecg);
if QRS2(length(QRS2))>Lsignal-100
    QRS2=QRS2(1:length(QRS2)-1);
end
LQRS=length(QRS2);


for ii=1:LQRS
    currentindexofmax=QRS2(ii);   
    maxvalue=ecg(QRS2(ii));
     for jj=-10:10
         currentindex=QRS2(ii)+jj;
         currentvalue=ecg(currentindex);
         if sgn>0
             %work for possitive qrs
             if currentvalue>maxvalue
                 maxvalue=currentvalue;
                 currentindexofmax=currentindex;
             end
         else
             %work for negative qrs
             if currentvalue<maxvalue
                 maxvalue=currentvalue;
                 currentindexofmax=currentindex;
             end
         end
     end
     QRS2(ii)=currentindexofmax;
end %for each QRS
% remove too close qrs
ctr=1;
ctr2=1;
while ctr< length(QRS2)-1
    current=QRS2(ctr);
    next=QRS2(ctr+1);
    if (next-current)<100
        QRS2(ctr+1)=[];
        ctr2=ctr2+1;
        if ctr2>LQRS/2
            
            break;
        end
    else
        ctr=ctr+1;
    end
    
end
end  %function

