function [ DCTs ] = DCTFeatures3( signal, QRS )

DCTs=zeros(1,10);
L=length (QRS);
ctr=0;

for jj=1:L-1
    ctr=ctr+1;
    Y = fft( signal(QRS(jj):QRS(jj+1)) );
    LY=fix(length(Y)/2);
    Y=Y(1:LY);
    Y=dct(Y);
    Y=Y(1:10);
    DCTs=DCTs+Y';
end
if ctr~=0
    DCTs=abs(abs(DCTs))/ctr;
end
mn=min(DCTs);
mx=max(DCTs);
avrg=mean(DCTs);
DCTs(11)=mn;
DCTs(12)=mx;
DCTs(13)=avrg;

%number of sines in periods
sines=[];
for jj=1:L-1
    
    Y =  signal(QRS(jj):QRS(jj+1)) ;
    X=dct(Y);
    [~,ind] = sort(abs(X),'descend');
    ctr = 1;
    while norm(X(ind(1:ctr)))/norm(X)<0.99
        ctr = ctr + 1;
    end
    sines(jj) = ctr;
    
end
DCTs(14)=min(sines);
DCTs(15)=max(sines);
DCTs(16)=mean(sines);
end

